/*
 * strspn - search a string for a set of characters.
 * count the initial segment of the string consisting entirely of characters
 * in accept
 */
int strspn(const char *s, const char *accept)
{
  int count;
  const char *p;

  for (count = 0; *s; s++, count++) {
    for (p = accept; *p; p++)	/* for each *s search accept string */
      if (*s == *p)
	break;			/* if found */
    if (*p == 0)
      return count;		/* if end of accept string, not found */
  }

  return count;			/* if all found */
}
