/*************************************************************
 * File: util/memmove.c
 * Purpose: Part of C runtime library
 */

/*************************************************************
*  memmove(dst,src,nbytes)
*	A rather slow implementation of memmove, this should
*	be rewritten in assembler.
*/
char *memmove(dst,src,nbytes)
unsigned char *dst,*src;
int nbytes;
{
  char *savedst = dst;
  if (dst < src)
    for (;nbytes>0;nbytes--) *dst++ = *src++;
  else {
    dst += nbytes;
    src += nbytes;
    for (;nbytes>0;nbytes--) *--dst = *--src;
  }
  return savedst;
}

