/*************************************************************
 * File: lib/cpdata.s
 * Purpose: Part of C runtime library
 * Author: Phil Bunce (pjb@carmel.com)
 * Revision History:
 *	970304	Start of revision history
 *	971231	Added ifdef for GHS
 */

#include "mips.h"
#include "brecis.h"

#define icache_indinv(r)	.word	(0xbc000000|((r)<<21))

	.globl clrbbloadbss
	.ent clrbbloadbss
clrbbloadbss:	# clear the bss area
		
	la		t0, clrbbloadbsshandler
	la		t1, eclrbbloadbsshandler
	la		t2, 0x80000000
		
1:	lw		t3, (t0)
	lw		t4, 4(t0)
	lw		v0, 8(t0)
	lw		v1, 12(t0)			
	icache_indinv(r_t2)
	sw		t3, (t2)
	sw		t4, 4(t2)
	sw		v0, 8(t2)
	sw		v1, 12(t2)			
	addu	t0, 16
	addu	t2, 16
	blt		t0, t1, 1b

	.set push
	.set mips3
	sync
	.set pop
	ld		v0, MEM_CNFG_REG	/* force memory controller to finish writes */

	la	v0,_fbss
	la	v1,bbloadend

	la	t1, 0x80000000
	j	t1
clrbbloadbsshandler:
1:		
	sw	zero,0x0(v0)
	sw	zero,0x4(v0)
	sw	zero,0x8(v0)
	sw	zero,0xc(v0)
	addu	v0,16
	blt	v0,v1,1b
	j	ra
eclrbbloadbsshandler:	
	.end clrbbloadbss

/*
 * Copy bbload data from ROM to RAM, used in ROM-based applications.
 */
	.globl cpdata
	.ent cpdata
cpdata: # copy .data to RAM
	# s0 = address to flush mips caches
	# src=ftext dst=eromtext stop=edata

	la		t0, cpdatahandler
	la		t1, ecpdatahandler
	la		t2, 0x80000000
		
1:	lw		t3, (t0)
	lw		t4, 4(t0)
	lw		v0, 8(t0)
	lw		v1, 12(t0)			
	icache_indinv(r_t2)
	sw		t3, (t2)
	sw		t4, 4(t2)
	sw		v0, 8(t2)
	sw		v1, 12(t2)			
	addu	t0, 16
	addu	t2, 16
	blt		t0, t1, 1b

	move t5, ra			# save ra
	la	t6, 0x80000000

	la	t0,ldata
	la	t2,bbloadedata
 	la	t1,bbloadfdata
	jal	t6
		
	move ra, t5			# restore ra
	j	ra
			
cpdatahandler:	
1:	lw		t3, (t0)
	lw		t4, 4(t0)
	lw		v0, 8(t0)
	lw		v1, 12(t0)			
	sw		t3, (t1)
	sw		t4, 4(t1)
	sw		v0, 8(t1)
	sw		v1, 12(t1)			
	addu	t0, 16
	addu	t1, 16
	blt		t1, t2, 1b

	j	ra
	nop
ecpdatahandler:		
	.end cpdata
