/*
 * Part of Very Secure FTPd
 * Licence: GPL v2
 * Author: Chris Evans
 * utility.c
 */

#include <stdarg.h>
#include <iconv.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "tunables.h"
#include "utility.h"
#include "sysutil.h"
#include "str.h"
#include "defs.h"

#define DIE_DEBUG

void
die(const char* p_text)
{
#ifdef DIE_DEBUG
  bug(p_text);
#endif
  vsf_sysutil_exit(1);
}

char *
local2remote(const char *buf)
{
  char *in_ptr;
  char *out_ptr;
  size_t inbytesleft, outbytesleft;
  char *p;
  iconv_t ic;

  if (tunable_enable_iconv == 0) return NULL;
  ic = iconv_open(tunable_remote_charset, tunable_local_charset);
  if (ic == (iconv_t)(-1)) return NULL;
  iconv(ic, NULL, NULL, NULL, NULL);

  inbytesleft = strlen(buf);
  outbytesleft = inbytesleft * 6;
  p = vsf_sysutil_malloc(outbytesleft+1);

  in_ptr = buf;
  out_ptr = p;
  while (inbytesleft) {
    if (iconv(ic, &in_ptr, &inbytesleft, &out_ptr, &outbytesleft) == (size_t)(-1)) {
      iconv_close(ic);
      vsf_sysutil_free(p);
      return NULL;
    }
  }

  *out_ptr = 0;

  iconv_close(ic);
  return p;
}

char *
remote2local(const char *buf)
{
  char *in_ptr;
  char *out_ptr;
  size_t inbytesleft, outbytesleft;
  char *p;
  iconv_t ic;

  if (tunable_enable_iconv == 0) return NULL;
  ic = iconv_open(tunable_local_charset, tunable_remote_charset);
  if (ic == (iconv_t)(-1)) return NULL;
  iconv(ic, NULL, NULL, NULL, NULL);

  inbytesleft = strlen(buf);
  outbytesleft = inbytesleft * 6;
  p = vsf_sysutil_malloc(outbytesleft+1);

  in_ptr = buf;
  out_ptr = p;
  while (inbytesleft) {
    if (iconv(ic, &in_ptr, &inbytesleft, &out_ptr, &outbytesleft) == (size_t)(-1)) {
      iconv_close(ic);
      vsf_sysutil_free(p);
      return NULL;
    }
  }

  *out_ptr = 0;

  iconv_close(ic);
  return p;
}

void
die2(const char* p_text1, const char* p_text2)
{
  struct mystr die_str = INIT_MYSTR;
  str_alloc_text(&die_str, p_text1);
  str_append_text(&die_str, p_text2);
  die(str_getbuf(&die_str));
}

void
bug(const char* p_text)
{
  /* Rats. Try and write the reason to the network for diagnostics */
  vsf_sysutil_activate_noblock(VSFTP_COMMAND_FD);
  (void) vsf_sysutil_write_loop(VSFTP_COMMAND_FD, "500 OOPS: ", 10);
  (void) vsf_sysutil_write_loop(VSFTP_COMMAND_FD, p_text,
                                vsf_sysutil_strlen(p_text));
  (void) vsf_sysutil_write_loop(VSFTP_COMMAND_FD, "\r\n", 2);
  vsf_sysutil_exit(1);
}

void
vsf_exit(const char* p_text)
{
  (void) vsf_sysutil_write_loop(VSFTP_COMMAND_FD, p_text,
                                vsf_sysutil_strlen(p_text));
  vsf_sysutil_exit(0);
}

