#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../amit_open_include/sysinfo.h"
#include "../amit_open_include/open_debug.h"

#define WANIP		0x0000
#define LANIP		0x0001
#define BRIDGEIP	0x0002
#define DEVICEID	0x0003
#define VERSION		0x0004
#define WOLMAC		0x0005


//
// ت:
//	qfileotθT
//
// J:
//	ret_p: return pointer
//	data_type:	WANIP, LANIP, BridgeIP, DeviceID
//
// X:
//	return 0 -- OK
//	return -1 -- NG
//
int read_sysinfo(void *ret_p, int data_type)
{
	FILE *fp;
	Sys_info sysinfo_temp;
	
	// file lock
	
	// }, ŪX
	fp = fopen(SYS_INFO_PATH, "r");
	if(fp == NULL)
	{
		Dprintf("open sysinfo error\n");
		return -1;
	}
	else
	{
		fread(&sysinfo_temp, sizeof(sysinfo_temp), 1, fp);
		fclose(fp);

		// oUT
		switch(data_type)
		{
			case WANIP:
				*(unsigned long *)ret_p = sysinfo_temp.wan_ip;
				break;
			case LANIP:
				*(unsigned long *)ret_p = sysinfo_temp.lan_ip;
				break;
			case LANMASK:
				*(unsigned long *)ret_p = sysinfo_temp.lan_mask;
				break;
			case BRIDGEIP:
				*(unsigned long *)ret_p = sysinfo_temp.bridge_ip;
				break;
			case BRIDGEMASK:
				*(unsigned long *)ret_p = sysinfo_temp.bridge_mask;
				break;
			case DEVICEID:
				strncpy((char *)ret_p, sysinfo_temp.device_ID, sizeof(sysinfo_temp.device_ID));
				break;
			case VERSION:
				strncpy((char *)ret_p, sysinfo_temp.VersionName, sizeof(sysinfo_temp.VersionName));
				break;
			case WOLMAC:
				memcpy((char *)ret_p, sysinfo_temp.wolmac, sizeof(sysinfo_temp.wolmac));
				break;
			default:
				return -1;
		}
	}

	return 0;

	// file unlock
}


//
// ت:
//	Ǧ^wolmac
//
// J:
//	None
//
// ^:
//	wolmacr
//
char * get_wolmac()
{
	static char wolmac[6];
	
	if(read_sysinfo((void *)wolmac, WOLMAC) == 0)
		return wolmac;
	else
		return NULL;
}


//
// ت:
//	Ǧ^DeviceID
//
// J:
//	None
//
// ^:
//	DeviceIDr
//
char * get_DeviceID()
{
	static char DeviceID[16];
	
	if(read_sysinfo((void *)DeviceID, DEVICEID) == 0)
		return DeviceID;
	else
		return NULL;
}

//
// ت:
//	Ǧ^VersionName
//
// J:
//	None
//
// ^:
//	Versionr
//
char * get_VersionName()
{
	static char VersionName[32];
	
	if(read_sysinfo((void *)VersionName, VERSION) == 0)
		return VersionName;
	else
		return NULL;
}
