#ifndef _SYSINFO_H
#define _SYSINFO_H

#define SYS_INFO_PATH	"/var/config/sysinfo"

#define WANIP		0x0000
#define LANIP		0x0001
#define BRIDGEIP	0x0002
#define DEVICEID	0x0003
#define VERSION		0x0004
#define WOLMAC		0x0005
#define WANMASK		0x0006
#define LANMASK		0x0007
#define BRIDGEMASK	0x0008

#define GET_WANIP()			get_ip(WANIP)
#define GET_WANMASK()		get_ip(WANMASK)
#define GET_LANIP()			get_ip(LANIP)
#define GET_LANMASK()		get_ip(LANMASK)
#define GET_BRIDGEIP()		get_ip(BRIDGEIP)
#define GET_BRIDGEMASK()	get_ip(BRIDGEMASK)

typedef struct _sysinfo
{
	unsigned long wan_ip;
	unsigned long wan_mask;
	unsigned long lan_ip;
	unsigned long lan_mask;
	unsigned long bridge_ip;
	unsigned long bridge_mask;
	char device_ID[16];
	char VersionName[32];
	unsigned char wolmac[6];
} Sys_info;

struct	dhcp_client_elm{
	unsigned long	client_ip;
	unsigned long	start_time;
	unsigned long	end_time;
	char	client_host[20];
	char	client_mac[6];
	char	reserv[2];
};


#	define	LANPORTNAME		"eth1"
#	define WANPORTNAME		"eth1"
#	define WLANPORTNAME    "wl0"  // wireless
#	define WDSPORTNAME     "wds"   // wds

#define PPPPORTNAME		"ppp0"
#define IPSECPORTNAME	"ipsec0"
#define BRIDGEPORTNAME	"br0"
#endif
