#ifndef __C6010_SYM_H
#define __C6010_SYM_H

#define C6010_PE_PDCS_MIN	0x00000000
#define C6010_PE_PDCS_8		0x04000000
#define C6010_PE_PDCS_16	0x08000000
#define C6010_PE_PDCS_32	0x10000000
#define C6010_PE_PDCS_64	0x20000000
#define C6010_PE_PDCS_128	0x40000000
#define C6010_PE_PDCS_256	0x80000000
#define C6010_PE_ERR_MASK	0x0000F000
#define C6010_PE_ERR_CMD	0x00000000
#define C6010_PE_ERR_ALG	0x00001000
#define C6010_PE_ERR_PKTLEN	0x00003000
#define C6010_PE_ERR_DMA	0x00004000
#define C6010_PE_ERR_SAADDR	0x00005000
#define C6010_PE_ERR_COLLEN	0x00007000
#define C6010_PE_ERR_SPLEN	0x0000A000
#define C6010_PE_ERR_FLAG	0x00000800
#define C6010_PE_OPSP_CONTI	0x00000000
#define C6010_PE_OPSP_SP	0x00000080
#define C6010_PE_IPCO_CONTI	0x00000000
#define C6010_PE_IPCO_COL	0x00000040
#define C6010_PE_HFIN_EN	0x00000020
#define C6010_PE_OWN_HOST	0x00000000
#define C6010_PE_OWN_PE		0x00000001

#define C6010_OWN_BIT		0x8000

// SA Command 0 Register
// RDC data sheet page 28.
#define	SA_CMD0_SAVH		0x20000000
#define SA_CMD0_SAVIV		0x10000000
#define SA_CMD0_LDH_SA		0x08000000
#define SA_CMD0_LDH_NO		0x0C000000
#define SA_CMD0_IVLD_AUTO	0x00000000
#define SA_CMD0_IVLD_INPUT	0x01000000
#define SA_CMD0_IVLD_SA		0x02000000
#define SA_CMD0_IVLD_INDIR	0x03000000
#define SA_CMD0_HALG_MD5	0x00000000
#define SA_CMD0_HALG_SHA1	0x00001000
#define SA_CMD0_HALG_AESCBC	0x00008000
#define SA_CMD0_HALG_AESXCBC	0x00009000
#define SA_CMD0_HALG_NULL	0x0000F000
#define SA_CMD0_EALG_DES	0x00000000
#define SA_CMD0_EALG_3DES	0x00000100
#define SA_CMD0_EALG_AES	0x00000300
#define SA_CMD0_EALG_NULL	0x00000F00
#define SA_CMD0_EPD_10		0x00000080
#define SA_CMD0_EPD_00		0x000000C0
#define SA_CMD0_ENC			0x00000000
#define SA_CMD0_ENC_HASH	0x00000001
#define SA_CMD0_HASH		0x00000003
#define SA_CMD0_DEC			0x00000008
#define SA_CMD0_DEC_HASH	0x00000009


// SA Command 1 register
// RDC data sheet page 30.
#define SA_CMD1_AESKLEN_128	0x02000000
#define SA_CMD1_AESKLEN_192	0x03000000
#define SA_CMD1_AESKLEN_256	0x08000000
#define SA_CMD1_ICVLEN_64	0x00000000
#define SA_CMD1_ICVLEN_96	0x00001000
#define SA_CMD1_ICVLEN_128	0x00002000
#define SA_CMD1_ICVLEN_160	0x00003000
#define SA_CMD1_ICVMD_STD	0x00000000
#define SA_CMD1_ICVMD_HMAC	0x00000400
#define SA_CMD1_EMD_ECB		0x00000000
#define SA_CMD1_EMD_CBC		0x00000100
#define SA_CMD1_EMD_CTR		0x00000200
#define SA_CMD1_COPY_PAYLOAD	0x00000004
#define SA_CMD1_COPY_HEADER	0x00000002

#define C6010_INT_OWN_BY_HOST	0x00000080
#define C6010_INT_NEXT_NULL		0x00000040
#define C6010_INT_PE_OP_DONE	0x00000020
#define C6010_INT_PE_ERR		0x00000010
#define C6010_INT_PE_ALL_DONE	0x00000008

#define C6010_PESTAT_PE_READY	0x00000400
#define C6010_PESTAT_PE_BUSY	0x00000200
#define C6010_PESTAT_HASH_DONE	0x00000008
#define C6010_PESTAT_ENC_DONE	0x00000004
#define C6010_PESTAT_OUT_DONE	0x00000002
#define C6010_PESTAT_IN_DONE	0x00000001

#define C6010_DES_ENC(in_buf, out_buf, k1, iv, len) \
		run_c6010(SA_CMD0_EALG_DES, SA_CMD0_HALG_NULL, SA_CMD0_ENC, in_buf, out_buf, k1, NULL, NULL, NULL, iv, NULL, len)
#define C6010_DES_DEC(in_buf, out_buf, k1, iv, len) \
		run_c6010(SA_CMD0_EALG_DES, SA_CMD0_HALG_NULL, SA_CMD0_DEC, in_buf, out_buf, k1, NULL, NULL, NULL, iv, NULL, len)
#define C6010_3DES_ENC(in_buf, out_buf, k1, k2, k3, iv, len) \
		run_c6010(SA_CMD0_EALG_3DES, SA_CMD0_HALG_NULL, SA_CMD0_ENC, in_buf, out_buf, k1, k2, k3, NULL, iv, NULL, len)
#define C6010_3DES_DEC(in_buf, out_buf, k1, k2, k3, iv, len) \
		run_c6010(SA_CMD0_EALG_3DES, SA_CMD0_HALG_NULL, SA_CMD0_DEC, in_buf, out_buf, k1, k2, k3, NULL, iv, NULL, len)
#define C6010_AES_ENC(in_buf, out_buf, k1, k2, k3, k4, iv, len) \
		run_c6010(SA_CMD0_EALG_AES, SA_CMD0_HALG_NULL, SA_CMD0_ENC, in_buf, out_buf, k1, k2, k3, k4, iv, NULL, len)
#define C6010_AES_DEC(in_buf, out_buf, k1, k2, k3, k4, iv, len) \
		run_c6010(SA_CMD0_EALG_AES, SA_CMD0_HALG_NULL, SA_CMD0_DEC, in_buf, out_buf, k1, k2, k3, k4, iv, NULL, len)
#define C6010_HMAC_MD5(in_buf, out_buf, iv, len) \
		run_c6010(SA_CMD0_EALG_NULL, SA_CMD0_HALG_MD5, SA_CMD0_HASH, in_buf, out_buf, NULL, NULL, NULL, NULL, NULL, iv, len)
#define C6010_HMAC_SHA1(in_buf, out_buf, iv, len) \
		run_c6010(SA_CMD0_EALG_NULL, SA_CMD0_HALG_SHA1, SA_CMD0_HASH, in_buf, out_buf, NULL, NULL, NULL, NULL, NULL, iv, len)

int run_c6010(	unsigned short ealg,
				unsigned short halg,
				unsigned short enc_flag,
				unsigned char *in_buf,
				unsigned char *out_buf,
				unsigned char *k1, unsigned char *k2, unsigned char *k3, unsigned char *k4,
				unsigned char *eiv,
				unsigned char *hiv,
				unsigned int len
				);

#endif
