
#include "rlxsim_newlib.h"
#include "rlxsim_fileio.h"

#ifndef NULL
#define NULL 0
#endif

#define __MYPID 1

extern __PutCharacter(char, char);


#undef errno
int errno;
     
extern int outbyte(char ch);
extern unsigned char inbyte();
extern int havebyte();
     
void
__main()
{
  return;
}

int
read(fd, buf, nbytes)
     int fd;
     char *buf;
     int nbytes;
{
  return rlxsim_gdb_read(fd, (void *)buf, (unsigned int)nbytes);
}
     
int
write(fd, buf, nbytes)
     int fd;
     char *buf;
     int nbytes;
{
  int i;
     
      return rlxsim_gdb_write(fd, (void *)buf, (unsigned int)nbytes);
}
     
int
open(buf, flags, mode)
     char *buf;
     int flags;
     int mode;
{
  return rlxsim_gdb_open(buf, flags, mode);
}
     
int
close(fd)
     int fd;
{
  return rlxsim_gdb_close(fd);
}

/*
      * sbrk -- changes heap size size. Get nbytes more
      *         RAM. We just increment a pointer in what's
      *         left of memory on the board.
      */
caddr_t
sbrk(nbytes)
     int nbytes;
{
  static caddr_t heap_ptr = (caddr_t)&HEAP_START;
  caddr_t        base;
     
  if ((RAMSIZE - heap_ptr) >= 0) {
    base = heap_ptr;
    heap_ptr += nbytes;
    return (base);
  } else {
    errno = ENOMEM;
    return ((caddr_t)-1);
  }
}

int
isatty(fd)
     int fd;
{
  return rlxsim_gdb_isatty(fd);
}

off_t
lseek(fd,  offset, whence)
     int fd;
     off_t offset;
     int whence;
{
  return (off_t)rlxsim_gdb_lseek(fd, offset, whence);
}

int
fstat(fd, buf)
     int fd;
     struct stat *buf;
{
  return rlxsim_gdb_fstat(fd, buf);
}

/*
      * getpid -- only one process, so just return 1.
      */
int
getpid()
{
  return __MYPID;
}

/*
      * kill -- go out via exit...
      */
int
kill(pid, sig)
     int pid;
     int sig;
{
  if(pid == __MYPID)
    _exit(sig);
  return 0;
}

/*
      * print -- do a raw print of a string
      */
int
print(ptr)
     char *ptr;
{
  while (*ptr) {
    outbyte (*ptr++);
  }
}

/*
      * putnum -- print a 32 bit number in hex
      */
int
putnum (num)
     unsigned int num;
{
  char  buffer[9];
  int   count;
  char  *bufptr = buffer;
  int   digit;
     
  for (count = 7 ; count >= 0 ; count--) {
    digit = (num >> (count * 4)) & 0xf;
     
    if (digit <= 9)
      *bufptr++ = (char) ('0' + digit);
    else
      *bufptr++ = (char) ('a' - 10 + digit);
  }
     
  *bufptr = (char) 0;
  print (buffer);
  return;
}

int outbyte(char ch)
{     
  __PutCharacter(ch, ch);
}

unsigned char inbyte()
{
}
