# =============================================================================
# This file include the functions to implement newlib lowest level functions 
# to support remote file IO
# =============================================================================

#include "include/regdef.h"
#include "rlxsim_fileio.h"
    .set  	noat
    .set  	noreorder

    .text

# =============================================================================
# int rlxsim_gdb_open(const char *pathname, int flags, mode_t mode)
# =============================================================================
    .globl	rlxsim_gdb_open
    .ent 	rlxsim_gdb_open
rlxsim_gdb_open:
    li  t0, GDB_SERV_OPEN
    li  t1, GDB_SYSCALL_PARA_ADDR
    sw  t0, 0x0(t1)
    sw  a0, 0x8(t1)
    sw  a1, 0xC(t1)
    sw  a2, 0x10(t1)
    syscall GDB_SYSCALL_NUM
    lw  v0, 0x4(t1)
    j   ra
    nop
    .end rlxsim_gdb_open

# =============================================================================
# int rlxsim_gdb_close(int fd)
# =============================================================================
    .globl	rlxsim_gdb_close
    .ent 	rlxsim_gdb_close
rlxsim_gdb_close:   
    li  t0, GDB_SERV_CLOSE
    li  t1, GDB_SYSCALL_PARA_ADDR
    sw  t0, 0x0(t1)
    sw  a0, 0x8(t1)
    syscall GDB_SYSCALL_NUM
    lw  v0, 0x4(t1)
    j   ra
    nop
	.end rlxsim_gdb_close

# =============================================================================
# int rlxsim_gdb_read(int fd, void *buf, unsigned int count)
# =============================================================================
    .globl	rlxsim_gdb_read
    .ent 	rlxsim_gdb_read
rlxsim_gdb_read:
    li  t0, GDB_SERV_READ
    li  t1, GDB_SYSCALL_PARA_ADDR
    sw  t0, 0x0(t1)
    sw  a0, 0x8(t1)
    sw  a1, 0xC(t1)
    sw  a2, 0x10(t1)
    syscall GDB_SYSCALL_NUM
    lw  v0, 0x4(t1)
    j   ra
    nop
	.end rlxsim_gdb_read

# =============================================================================
# int rlxsim_gdb_write(int fd, void *buf, unsigned int count)
# =============================================================================
    .globl	rlxsim_gdb_write
    .ent 	rlxsim_gdb_write
rlxsim_gdb_write:
    li  t0, GDB_SERV_WRITE
    li  t1, GDB_SYSCALL_PARA_ADDR
    sw  t0, 0x0(t1)
    sw  a0, 0x8(t1)
    sw  a1, 0xC(t1)
    sw  a2, 0x10(t1)
    syscall GDB_SYSCALL_NUM
    lw  v0, 0x4(t1)
    j   ra
    nop
	.end rlxsim_gdb_write

# =============================================================================
# int rlxsim_gdb_lseek(int fd, long offset, int flag)
# =============================================================================
    .globl	rlxsim_gdb_lseek
    .ent 	rlxsim_gdb_lseek
rlxsim_gdb_lseek:
    li  t0, GDB_SERV_LSEEK
    li  t1, GDB_SYSCALL_PARA_ADDR
    sw  t0, 0x0(t1)
    sw  a0, 0x8(t1)
    sw  a1, 0xC(t1)
    sw  a2, 0x10(t1)
    syscall GDB_SYSCALL_NUM
    lw  v0, 0x4(t1)
    j   ra
    nop
	.end rlxsim_gdb_lseek

# =============================================================================
# int rlxsim_gdb_fstat(int fd, struct stat *buf)
# =============================================================================
    .globl	rlxsim_gdb_fstat
    .ent 	rlxsim_gdb_fstat
rlxsim_gdb_fstat:
    li  t0, GDB_SERV_FSTAT
    li  t1, GDB_SYSCALL_PARA_ADDR
    sw  t0, 0x0(t1)
    sw  a0, 0x8(t1)
    sw  a1, 0xC(t1)
    sw  a2, 0x10(t1)
    syscall GDB_SYSCALL_NUM
    lw  v0, 0x4(t1)
    j   ra
    nop
	.end rlxsim_gdb_fstat

# =============================================================================
# int rlxsim_gdb_isatty(int fd)
# =============================================================================
    .globl	rlxsim_gdb_isatty
    .ent 	rlxsim_gdb_isatty
rlxsim_gdb_isatty:
    li  t0, GDB_SERV_ISATTY
    li  t1, GDB_SYSCALL_PARA_ADDR
    sw  t0, 0x0(t1)
    sw  a0, 0x8(t1)
    sw  a1, 0xC(t1)
    sw  a2, 0x10(t1)
    syscall GDB_SYSCALL_NUM
    lw  v0, 0x4(t1)
    j   ra
    nop
	.end rlxsim_gdb_isatty
