
#define GDB_SYSCALL_NUM 5
#define GDB_SYSCALL_PARA_ADDR 0xbfffff00
#define GDB_SERV_OPEN   0
#define GDB_SERV_CLOSE  1
#define GDB_SERV_READ   2
#define GDB_SERV_WRITE  3
#define GDB_SERV_LSEEK  4
#define GDB_SERV_FSTAT  5
#define GDB_SERV_ISATTY 6

#ifndef __ASM
int rlxsim_gdb_open(const char *pathname, int flags, mode_t mode);
int rlxsim_gdb_close(int fd);
int rlxsim_gdb_read(int fd, void *buf, unsigned int count);
int rlxsim_gdb_write(int fd, void *buf, unsigned int count);
int rlxsim_gdb_lseek(int fd, long offset, int flag);
int rlxsim_gdb_fstat(int fd, struct stat *buf);
int rlxsim_gdb_isatty(int fd);
#endif
