'\"
'\" Copyright (c) 1994 The Australian National University
'\" Copyright (c) 1994-1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" Author: Paul Mackerras (paulus@cs.anu.edu.au),
'\"	    Department of Computer Science,
'\"	    Australian National University.
'\"
'\" RCS: @(#) $Id: photo.n,v 1.12 2002/06/22 00:37:16 dkf Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.4 2000/08/25 06:18:32 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH photo n 4.0 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
photo \- Full-color images
.SH SYNOPSIS
\fBimage create photo \fR?\fIname\fR? ?\fIoptions\fR?
.BE

.SH DESCRIPTION
.PP
A photo is an image whose pixels can display any color or be
transparent.  A photo image is stored internally in full color (32
bits per pixel), and is displayed using dithering if necessary.  Image
data for a photo image can be obtained from a file or a string, or it
can be supplied from
C code through a procedural interface.  At present, only GIF and PPM/PGM
formats are supported, but an interface exists to allow additional
image file formats to be added easily.  A photo image is transparent
in regions where no image data has been supplied
.VS 8.4
or where it has been set transparent by the \fBtransparency set\fR
subcommand.
.VE 8.4

.SH "CREATING PHOTOS"
.PP
Like all images, photos are created using the \fBimage create\fR
command.
Photos support the following \fIoptions\fR:
.TP
\fB\-data \fIstring\fR
Specifies the contents of the image as a string.  The string can
contain base64 encoded data or binary data.  The format of the
string must be one of those for which there is an image file format
handler that will accept string data.  If both the \fB\-data\fR
and \fB\-file\fR options are specified, the \fB\-file\fR option takes
precedence.
.TP
\fB\-format \fIformat-name\fR
Specifies the name of the file format for the data specified with the
\fB\-data\fR or \fB\-file\fR option.
.TP
\fB\-file \fIname\fR
\fIname\fR gives the name of a file that is to be read to supply data
for the photo image.  The file format must be one of those for which
there is an image file format handler that can read data.
.TP
\fB\-gamma \fIvalue\fR
Specifies that the colors allocated for displaying this image in a
window should be corrected for a non-linear display with the specified
gamma exponent value.  (The intensity produced by most
CRT displays is a power function of the input value, to a good
approximation; gamma is the exponent and is typically around 2).
The value specified must be greater than zero.  The default
value is one (no correction).  In general, values greater than one
will make the image lighter, and values less than one will make it
darker.
.TP
\fB\-height \fInumber\fR
Specifies the height of the image, in pixels.  This option is useful
primarily in situations where the user wishes to build up the contents
of the image piece by piece.  A value of zero (the default) allows the
image to expand or shrink vertically to fit the data stored in it.
.TP
\fB\-palette \fIpalette-spec\fR
Specifies the resolution of the color cube to be allocated for
displaying this image, and thus the number of colors used from the
colormaps of the windows where it is displayed.  The
\fIpalette-spec\fR string may be either a single decimal number,
specifying the number of shades of gray to use, or three decimal
numbers separated by slashes (/), specifying the number of shades of
red, green and blue to use, respectively.  If the first form (a single
number) is used, the image will be displayed in monochrome (i.e.,
grayscale).
.TP
\fB\-width \fInumber\fR
Specifies the width of the image, in pixels.    This option is useful
primarily in situations where the user wishes to build up the contents
of the image piece by piece.  A value of zero (the default) allows the
image to expand or shrink horizontally to fit the data stored in it.

.SH "IMAGE COMMAND"
.PP
When a photo image is created, Tk also creates a new command
whose name is the same as the image.
This command may be used to invoke various operations
on the image.
It has the following general form:
.CS
\fIimageName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.
.PP
Those options that write data to the image generally expand the size
of the image, if necessary, to accommodate the data written to the
image, unless the user has specified non-zero values for the
\fB\-width\fR and/or \fB\-height\fR configuration options, in which
case the width and/or height, respectively, of the image will not be
changed.
.PP
The following commands are possible for photo images:
.TP
\fIimageName \fBblank\fR
Blank the image; that is, set the entire image to have no data, so it
will be displayed as transparent, and the background of whatever
window it is displayed in will show through.
.TP
\fIimageName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the
\fBimage create photo\fR command.
.TP
\fIimageName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options for the image.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIimageName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the
\fBimage create photo\fR command.
.TP
\fIimageName \fBcopy\fR \fIsourceImage\fR ?\fIoption value(s) ...\fR?
Copies a region from the image called \fIsourceImage\fR (which must
be a photo image) to the image called \fIimageName\fR, possibly with
pixel zooming and/or subsampling.  If no options are specified, this
command copies the whole of \fIsourceImage\fR into \fIimageName\fR,
starting at coordinates (0,0) in \fIimageName\fR.  The following
options may be specified:
.RS
.TP
\fB\-from \fIx1 y1 x2 y2\fR
Specifies a rectangular sub-region of the source image to be copied.
(\fIx1,y1\fR) and (\fIx2,y2\fR) specify diagonally opposite corners of
the rectangle.  If \fIx2\fR and \fIy2\fR are not specified, the
default value is the bottom-right corner of the source image.  The
pixels copied will include the left and top edges of the specified
rectangle but not the bottom or right edges.  If the \fB\-from\fR
option is not given, the default is the whole source image.
.TP
\fB\-to \fIx1 y1 x2 y2\fR
Specifies a rectangular sub-region of the destination image to be
affected.  (\fIx1,y1\fR) and (\fIx2,y2\fR) specify diagonally opposite
corners of the rectangle.  If \fIx2\fR and \fIy2\fR are not specified,
the default value is (\fIx1,y1\fR) plus the size of the source
region (after subsampling and zooming, if specified).  If \fIx2\fR and
\fIy2\fR are specified, the source region will be replicated if
necessary to fill the destination region in a tiled fashion.
.TP
\fB\-shrink\fR
Specifies that the size of the destination image should be reduced, if
necessary, so that the region being copied into is at the bottom-right
corner of the image.  This option will not affect the width or height
of the image if the user has specified a non-zero value for the
\fB\-width\fR or \fB\-height\fR configuration option, respectively.
.TP
\fB\-zoom \fIx y\fR
Specifies that the source region should be magnified by a factor of
\fIx\fR in the X direction and \fIy\fR in the Y direction.  If \fIy\fR
is not given, the default value is the same as \fIx\fR.  With this
option, each pixel in the source image will be expanded into a block
of \fIx\fR x \fIy\fR pixels in the destination image, all the same
color.  \fIx\fR and \fIy\fR must be greater than 0.
.TP
\fB\-subsample \fIx y\fR
Specifies that the source image should be reduced in size by using
only every \fIx\fRth pixel in the X direction and \fIy\fRth pixel in
the Y direction.  Negative values will cause the image to be flipped
about the Y or X axes, respectively.  If \fIy\fR is not given, the
default value is the same as \fIx\fR.
.TP
\fB\-compositingrule \fIrule\fR
.VS 8.4
Specifies how transparent pixels in the source image are combined with
the destination image.  When a compositing rule of \fIoverlay\fR is
set, the old contents of the destination image are visible, as if the
source image were printed on a piece of transparent film and placed
over the top of the destination.  When a compositing rule of \fIset\fR
is set, the old contents of the destination image are discarded and
the source image is used as-is.  The default compositing rule is
\fIoverlay\fR.
.VE 8.4
.RE
.TP
\fIimageName \fBdata ?\fIoption value(s) ...\fR?
Returns image data in the form of a string. The following options
may be specified:
.RS
.TP
\fB\-background\fI color\fR
If the color is specified, the data will not contain any transparency
information. In all transparent pixels the color will be replaced by
the specified color.
.TP
\fB\-format\fI format-name\fR
Specifies the name of the image file format handler to be used.
Specifically, this subcommand searches
for the first handler whose name matches a initial substring of
\fIformat-name\fR and which has the capability to read this image data.
If this option is not given, this subcommand uses the first
handler that has the capability to read the image data.
.TP
\fB\-from \fIx1 y1 x2 y2\fR
Specifies a rectangular region of \fIimageName\fR to be returned.
If only \fIx1\fR and \fIy1\fR are specified, the region
extends from \fI(x1,y1)\fR to the bottom-right corner of
\fIimageName\fR.  If all four coordinates are given, they specify
diagonally opposite corners of the rectangular region, including x1,y1
and excluding x2,y2.  The default, if this option is not given, is the
whole image.
.TP
\fB\-grayscale\fR
If this options is specified, the data will not contain color
information. All pixel data will be transformed into grayscale.
.RE
.TP
\fIimageName \fBget\fR \fIx y\fR
Returns the color of the pixel at coordinates (\fIx\fR,\fIy\fR) in the
image as a list of three integers between 0 and 255, representing the
red, green and blue components respectively.
.TP
\fIimageName \fBput\fR \fIdata\fR ?\fIoption value(s) ...\fR?
Sets pixels in \fI imageName\fR to the data specified in
\fIdata\fR. This command first searches the list of image file
format handlers for a handler that can interpret the data
in \fIdata\fR, and then reads the image in \fIfilename\fR into
\fIimageName\fR (the destination image). The following options
may be specified:
.RS
.TP
\fB\-format \fIformat-name\fR
Specifies the format of the image data in \fIdata\fR.
Specifically, only image file format handlers whose names begin with
\fIformat-name\fR will be used while searching for an image data
format handler to read the data.
.TP
\fB\-from \fIx1 y1 x2 y2\fR
Specifies a rectangular sub-region of the image file data to be
returned. If only \fIx1\fR and \fIy1\fR are specified, the region
extends from (\fIx1,y1\fR) to the bottom-right corner of the image
in the image file.  If all four coordinates are specified, they
specify diagonally opposite corners or the region. The default,
if this option is not specified, is the whole of the image.
.TP
\fB\-shrink\fR
If this option, the size of \fIimageName\fR will be reduced, if
necessary, so that the region into which the image file data are read
is at the bottom-right corner of the \fIimageName\fR.  This option
will not affect the width or height of the image if the user has
specified a non-zero value for the \fB\-width\fR or \fB\-height\fR
configuration option, respectively.
.TP
\fB\-to \fIx y\fR
Specifies the coordinates of the top-left corner of the region of
\fIimageName\fR into which data from \fIfilename\fR are to be read.
The default is (0,0).
.RE
.TP
\fIimageName \fBread\fR \fIfilename\fR ?\fIoption value(s) ...\fR?
Reads image data from the file named \fIfilename\fR into the image.
This command first searches the list of
image file format handlers for a handler that can interpret the data
in \fIfilename\fR, and then reads the image in \fIfilename\fR into
\fIimageName\fR (the destination image).  The following options may be
specified:
.RS
.TP
\fB\-format \fIformat-name\fR
Specifies the format of the image data in \fIfilename\fR.
Specifically, only image file format handlers whose names begin with
\fIformat-name\fR will be used while searching for an image data
format handler to read the data.
.TP
\fB\-from \fIx1 y1 x2 y2\fR
Specifies a rectangular sub-region of the image file data to be copied
to the destination image.  If only \fIx1\fR and \fIy1\fR are
specified, the region extends from (\fIx1,y1\fR) to the bottom-right
corner of the image in the image file.  If all four coordinates are
specified, they specify diagonally opposite corners or the region.
The default, if this option is not specified, is the whole of the
image in the image file.
.TP
\fB\-shrink\fR
If this option, the size of \fIimageName\fR will be reduced, if
necessary, so that the region into which the image file data are read
is at the bottom-right corner of the \fIimageName\fR.  This option
will not affect the width or height of the image if the user has
specified a non-zero value for the \fB\-width\fR or \fB\-height\fR
configuration option, respectively.
.TP
\fB\-to \fIx y\fR
Specifies the coordinates of the top-left corner of the region of
\fIimageName\fR into which data from \fIfilename\fR are to be read.
The default is (0,0).
.RE
.TP
\fIimageName \fBredither\fR
The dithering algorithm used in displaying photo images propagates
quantization errors from one pixel to its neighbors.
If the image data for \fIimageName\fR is supplied in pieces, the
dithered image may not be exactly correct.  Normally the difference is
not noticeable, but if it is a problem, this command can be used to
recalculate the dithered image in each window where the image is
displayed.
.TP
\fIimageName \fBtransparency \fIsubcommand ?arg arg ...?\fR
.VS 8.4
Allows examination and manipulation of the transparency information in
the photo image.  Several subcommands are available:
.RS
.TP
\fIimageName \fBtransparency get \fIx y\fR
Returns a boolean indicating if the pixel at (\fIx\fR,\fIy\fR) is
transparent.
\fIimageName \fBtransparency set \fIx y boolean\fR
Makes the pixel at (\fIx\fR,\fIy\fR) transparent if \fIboolean\fR is
true, and makes that pixel opaque otherwise.
.RE
.VE 8.4
.TP
\fIimageName \fBwrite \fIfilename\fR ?\fIoption value(s) ...\fR?
Writes image data from \fIimageName\fR to a file named \fIfilename\fR.
The following options may be specified:
.RS
.TP
\fB\-background\fI color\fR
If the color is specified, the data will not contain any transparency
information. In all transparent pixels the color will be replaced by
the specified color.
.TP
\fB\-format\fI format-name\fR
Specifies the name of the image file format handler to be used to
write the data to the file.  Specifically, this subcommand searches
for the first handler whose name matches a initial substring of
\fIformat-name\fR and which has the capability to write an image
file.  If this option is not given, this subcommand uses the first
handler that has the capability to write an image file.
.TP
\fB\-from \fIx1 y1 x2 y2\fR
Specifies a rectangular region of \fIimageName\fR to be written to the
image file.  If only \fIx1\fR and \fIy1\fR are specified, the region
extends from \fI(x1,y1)\fR to the bottom-right corner of
\fIimageName\fR.  If all four coordinates are given, they specify
diagonally opposite corners of the rectangular region.  The default,
if this option is not given, is the whole image.
.TP
\fB\-grayscale\fR
If this options is specified, the data will not contain color
information. All pixel data will be transformed into grayscale.
.RE
.SH "IMAGE FORMATS"
.PP
The photo image code is structured to allow handlers for additional
image file formats to be added easily.  The photo image code maintains
a list of these handlers.  Handlers are added to the list by
registering them with a call to \fBTk_CreatePhotoImageFormat\fR.  The
standard Tk distribution comes with handlers for PPM/PGM and GIF formats,
which are automatically registered on initialization.
.PP
When reading an image file or processing
string data specified with the \fB\-data\fR configuration option, the
photo image code invokes each handler in turn until one is
found that claims to be able to read the data in the file or string.
Usually this will find the correct handler, but if it doesn't, the
user may give a format name with the \fB\-format\fR option to specify
which handler to use.  In fact the photo image code will try those
handlers whose names begin with the string specified for the
\fB\-format\fR option (the comparison is case-insensitive).  For
example, if the user specifies \fB\-format gif\fR, then a handler
named GIF87 or GIF89 may be invoked, but a handler
named JPEG may not (assuming that such handlers had been
registered).
.PP
When writing image data to a file, the processing of the
\fB\-format\fR option is slightly different: the string value given
for the \fB\-format\fR option must begin with the complete name of the
requested handler, and may contain additional information following
that, which the handler can use, for example, to specify which variant
to use of the formats supported by the handler.
.VS 8.4
Note that not all image handlers may support writing transparency data
to a file, even where the target image format does.
.VE 8.4

.SH "COLOR ALLOCATION"
.PP
When a photo image is displayed in a window, the photo image code
allocates colors to use to display the image and dithers the image, if
necessary, to display a reasonable approximation to the image using
the colors that are available.  The colors are allocated as a color
cube, that is, the number of colors allocated is the product of the
number of shades of red, green and blue.
.PP
Normally, the number of
colors allocated is chosen based on the depth of the window.  For
example, in an 8-bit PseudoColor window, the photo image code will
attempt to allocate seven shades of red, seven shades of green and
four shades of blue, for a total of 198 colors.  In a 1-bit StaticGray
(monochrome) window, it will allocate two colors, black and white.  In
a 24-bit DirectColor or TrueColor window, it will allocate 256 shades
each of red, green and blue.  Fortunately, because of the way that
pixel values can be combined in DirectColor and TrueColor windows,
this only requires 256 colors to be allocated.  If not all of the
colors can be allocated, the photo image code reduces the number of
shades of each primary color and tries again.
.PP
The user can exercise some control over the number of colors that a
photo image uses with the \fB\-palette\fR configuration option.  If
this option is used, it specifies the maximum number of shades of
each primary color to try to allocate.  It can also be used to force
the image to be displayed in shades of gray, even on a color display,
by giving a single number rather than three numbers separated by
slashes.

.SH CREDITS
.PP
The photo image type was designed and implemented by Paul Mackerras,
based on his earlier photo widget and some suggestions from
John Ousterhout.

.SH KEYWORDS
photo, image, color
