/*
* Copyright c                  Realtek Semiconductor Corporation, 2006
* All rights reserved.
* 
* Program :  light rome rtl865x_lightromeext.c
* Abstract : 
* Author :  qy_wang(qy_wang@realsil.com.cn)
*
*/
#include "rtl_types.h"
#include "rtl_glue.h"

#include "asicregs.h"
#include "mbuf.h"
#define RTL8651_TBLDRV_LOCAL_H
#include "rtl8651_aclLocal.h"
#ifdef CONFIG_RTL865XC
#include "rtl865xC_tblAsicDrv.h"
#else
#include "rtl8651_tblAsicDrv.h"
#endif

#include "rtl865x_lightrome.h"
#include "light_rome.h"
#include "rtl865x_lightromeext.h"
#include "rtl8651_debug.h"

#include <linux/interrupt.h>
#include <linux/timer.h>
#include <linux/netdevice.h>

/*
	peripheralExtPortMask is the portmask of loopback(in 8651) or ext port(in 8650B)
	which already has a USB/PCI device registered.
*/
uint32 rtl8651_ExtPortNum = 3;
static uint32 rtl8651_usrSettingMemberDevMask[RTL8651_VLAN_NUMBER];			/* set by user, need to rearrange to apply internal setting */
__DRAM_EXTDEV static uint32 rtl8651_vlanMemberDevMask[RTL8651_VLAN_NUMBER];	/* Actually used mask : generated by _rtl8651_arrangeAllExtDeviceVlanMbr() */
static uint32 _rtl8651_vlanMemberDevMask[RTL8651_VLAN_NUMBER];

uint32 peripheralExtPortMask = 0;
__DRAM_EXTDEV static _rtl8651_extDevice_t rtl8651_extDevList[_RTL8651_EXTDEV_DEVCOUNT];

// mark "static" of extPortMaskToPortNum[]
__DRAM_EXTDEV uint8 extPortMaskToPortNum[_RTL865XB_EXTPORTMASKS+1];
static uint8 _extPortMaskToPortNum[_RTL865XB_EXTPORTMASKS+1] =
{
	0, 1, 2, 0, 3, 0, 0, 0
};
extern int32 miiPhyAddress;
extern int32 rtl8651_allExtPortMask;
//static uint32 _extPortNumToLinkMask[3]={	0x00000000,0x00000000,0x00000000};/*for extension port multicast usage,by qjj*/

#define VLAN_MEMDEV_LID_CHECK(linkId, vid, mask)	(mask[rtl8651_vlanTableIndex(vid)] & (1<<_RTL8651_EXTDEV_LINKID2IDX(linkId)))
#define VLAN_MEMDEV_IDX_CHECK(idx, vid, mask)		(mask[rtl8651_vlanTableIndex(vid)] & (1<<(idx)))
#define VLAN_MEMDEV_LID_CLR(linkId, vid, mask)		(mask[rtl8651_vlanTableIndex(vid)] &= ~(1<<_RTL8651_EXTDEV_LINKID2IDX(linkId)))
#define VLAN_MEMDEV_IDX_CLR(idx, vid, mask)			(mask[rtl8651_vlanTableIndex(vid)] &= ~(1<<(idx)))
#define VLAN_MEMDEV_LID_SET(linkId, vid, mask)		(mask[rtl8651_vlanTableIndex(vid)] |= (1<<_RTL8651_EXTDEV_LINKID2IDX(linkId)))
#define VLAN_MEMDEV_IDX_SET(idx, vid, mask)			(mask[rtl8651_vlanTableIndex(vid)] |= (1<<(idx)))


static int32 rtl8651_bridgeEnable = FALSE;
static int32 rtl8651_extDevCnt = 0;

static int32 _rtl8651_fwdEngineRegExtDevice(	uint32 portNumber,
												uint16 defaultVID,
												uint32 *linkID_p,
												void *extDevice);
static _rtl8651_extDevice_t *_rtl8651_fwdEngineGetExtDevEntryByExtDevPtr(void *extDevice);
static int32 _rtl8651_fwdEngineUnregExtDevice(uint32 linkID);
int32 _rtl8651_addPeripheralExtPort(uint32 port);
static void _rtl8651_fwdEngineRearrangeExtDevBridge(void);

static int32 _rtl8651_fwdEngineUnregExtDevice(uint32 linkID);

static inline void _rtl8651_extDeviceVlanMbrClr(uint32 linkID);
void _rtl8651_arrangeAllExtDeviceVlanMbr(void);
static int32 _rtl8651_fwdEngineSetExtDeviceVlanProperty(	uint32 linkID,
																uint16 vid,
																uint32 property);

/* L2 SMAC learning cache */
#ifdef _RTL8651_L2ENG_EXTDEV_MACLEARNING_CACHE
static int32 _rtl8651_extDevMacLearningCache_reset(void);
__IRAM_EXTDEV static inline void _rtl8651_extDevMacLearningCache_addEntry(	ether_addr_t *	smac,
																				uint16			vid,
																				uint32			portMask,
																				uint32			linkID		);

static int32 _rtl8651_extDevMacLearningCache_flush(void);
__DRAM_EXTDEV static _rtl8651_extDevMacLearningCache_t _rtl8651_extDev_macLearning_Cache[_RTL8651_EXTDEV_MACLEARNING_CACHE_COUNT];
#endif

#ifdef CONFIG_RTL865XB
__IRAM_EXTDEV static void _rtl8651_ExtPortChecksumProcess(struct rtl_mBuf *mbuf);
#endif
uint16  _rtl8651_ipChecksum(struct ip * pip);
uint16 _rtl8651_tcpChecksum(struct ip *pip);
uint16 _rtl8651_icmpChecksum(struct ip * pip);

static void _rtl8651_extPortRecvL2Lookup(ether_addr_t *smac, uint16 myvid, uint32 myportmask, uint32 linkID);

#if 0
__IRAM_EXTDEV static int32 _rtl8651_fwdEngineHWExtDevUcast(	struct rtl_pktHdr *pktHdr,
																	uint32 txLinkID);
static int32 _rtl8651_fwdEngineExtDevBcast(	struct rtl_pktHdr *pktHdr,
												struct vlan_entry *ventry,
												uint32 txPortFilterMask,
												uint32 incomingLinkID,
												uint8 priority,
												uint8 freeOrgPkt);
static int32 _rtl8651_fwdEngineExtDevBridge(	uint8 *data,
												struct rtl_pktHdr* pktHdr,
												uint32 linkID,
												struct vlan_entry *ventry);
#endif

// copied from romedrv_linux.c
// CONFIG_BRIDGE is undefined in 865x SDK
#undef CONFIG_BRIDGE

#define DEVICE_NUMBER					2
#define TX_PORT_MASK(n)					0
#define DEV_MAP_SIZE					RTL8651_VLAN_NUMBER

struct re865x_dev {
	u16						ready;
	u16						nic_init;
	spinlock_t				lock;
	struct net_device			*dev[DEV_MAP_SIZE];
#ifdef CONFIG_BRIDGE
	struct net_device			*ext_dev[_RTL8651_EXTDEV_DEVCOUNT];
#endif
	struct tasklet_struct		rx_tasklet;
	struct timer_list 			timer;	
};

struct re865x_priv {
	u16						port_no;
	u16						vid;
	spinlock_t				lock;
	
	struct net_device			*dev;
	struct net_device_stats	net_stats;	/* network interface statistic */
	
};

static struct re865x_dev __re865x_dev;

#ifdef CONFIG_BRIDGE
void lightrome_regExtDev(void* extdev, int32 idx)
{
	__re865x_dev.ext_dev[idx] = (struct net_device *)extdev;
}
#endif

void re865x_LRtimer(unsigned long data)
{
#ifdef _RTL8651_L2ENG_EXTDEV_MACLEARNING_CACHE
	REG32(WDTCNR)|=WDTCLR;

	rtl8651_LRtimeUpdate(0);
	//__re865x_dev.timer.expires = jiffies + 10;
	__re865x_dev.timer.expires = jiffies + 2*HZ;
	add_timer(&__re865x_dev.timer); 	
#endif	
}

void rtl8651_extDeviceInitTimer(void)
{
	memset(&__re865x_dev, 0, sizeof(struct re865x_dev));
	spin_lock_init(&__re865x_dev.lock);

	init_timer(&__re865x_dev.timer);
	__re865x_dev.timer.expires = jiffies + 3*HZ;
	__re865x_dev.timer.data = (unsigned long)0;
	__re865x_dev.timer.function = &re865x_LRtimer;/* timer handler */
	add_timer(&__re865x_dev.timer);
		
	__re865x_dev.ready = 1;
}

/********   register ************/
/*
@func int32		| rtl8651_fwdEngineRegExtDevice | Register (LinkID<->Port Number) binding into Rome Driver
@parm uint32		|	portNumber	| Extension Port Number to bind.
@parm uint16		|	defaultVID	| Default VID of this extension device.
@parm uint32*	|	linkID_p		| pointer to the LinkID of current extension device.
@parm void*		|	extDevice	| extension device's own pointer ( can NOT be NULL ).
@rvalue FAILED	|	No free LinkID or extDevice == NULL.
@rvalue SUCCESS	|	Registration OK.
@comm 
Register Extension Device into Rome Driver:
	Extension device would need to provide it's binding <p portNumber> and <p extDevice>.
	Rome Driver would fill the <p linkID> if registration success.
	<p defaultVID> indicates the default VLAN ID of this extension device. It is used in TX vlan filtering
	now.

	- Note: We don't support per-LinkID's untag set setting yet.
*/
int32 rtl8651_fwdEngineRegExtDevice(	uint32 portNumber,
											uint16 defaultVID,
											uint32 *linkID_p,
											void *extDevice)
{
	int32 retval = FAILED;

	rtlglue_drvMutexLock();
	retval = _rtl8651_fwdEngineRegExtDevice(portNumber, defaultVID, linkID_p, extDevice);
	rtlglue_drvMutexUnlock();

	return retval;
}

/* Internal Function for Extension Device Registration */
static int32 _rtl8651_fwdEngineRegExtDevice(	uint32 portNumber,
												uint16 defaultVID,
												uint32 *linkID_p,
												void *extDevice)
{
	_rtl8651_extDevice_t *extDev = NULL;
	int32 idx = 0;
	struct vlan_entry *ventry;

	if (	(portNumber < RTL8651_PORT_NUMBER) ||
		(portNumber >= (RTL8651_PORT_NUMBER + rtl8651_ExtPortNum))	||
		(extDevice == NULL) ||
		(linkID_p == NULL))
	{
		return LR_ERROR_PARAMETER;
	}

	if (defaultVID==0 || defaultVID==0xfff)
		return (int32)LR_INVVID;
       
	ventry = lr_get_vlan(defaultVID); 
	if (ventry == NULL )
		return LR_INVAPARAM;
       
	else if (ventry->valid == FALSE || ((ventry->mbr &  (1 << portNumber)) == 0) ) 
		return LR_INVAPARAM;
       
	/* 1. use the extDevice to find entry to check if this registration exist or not. */
	extDev = _rtl8651_fwdEngineGetExtDevEntryByExtDevPtr(extDevice);

	/* If same extDevice exist, we remote original entry first */
	if (extDev)
	{
		_rtl8651_fwdEngineUnregExtDevice(extDev->linkID);
	}

	/* Add New Entry */
	for ( idx = 0 ; idx < _RTL8651_EXTDEV_DEVCOUNT ; idx ++ )
	{
		if ( rtl8651_extDevList[idx].extDevice == NULL )
		{
			extDev = &(rtl8651_extDevList[idx]);
			break;
		}
	}

	if (idx >= _RTL8651_EXTDEV_DEVCOUNT)
	{
		return LR_NOBUFFER;
	}

	if (_rtl8651_addPeripheralExtPort(portNumber) != SUCCESS)
	{
		return LR_ERROR_PARAMETER;
	}

	assert(extDev);
	if (extDev == NULL)
		return FAILED;

	/* set information for the new entry */
	extDev->extDevice = extDevice;
	extDev->portMask = 1<<portNumber;
	extDev->linkID = _RTL8651_EXTDEV_IDX2LINKID(idx);
	
#ifdef CONFIG_BRIDGE
	lightrome_regExtDev(extDevice, idx);
#endif

#ifdef STP_PATCH
	/*qy_wang stp init state = forwarding to prevent extention device stay blocking when stp is disableed*/
	extDev->portStat = RTL8651_PORTSTA_FORWARDING;
	extDev->defaultVid = defaultVID;
#endif

	/* init and set VLAN filtering masks for this LinkID */
	_rtl8651_extDeviceVlanMbrClr(extDev->linkID);
	if (defaultVID > 0)
	{
		_rtl8651_fwdEngineSetExtDeviceVlanProperty(	extDev->linkID,
													defaultVID,
													RTL8651_EXTDEV_VLANPROPER_ISMBR);
	}

	/* increase registration count */
	rtl8651_extDevCnt ++;

	RTL_NOTICE(RTL_MSG_EXTDEV,
				"Add Extension Device [%d] : PortMask(0x%x) extDevice(0x%p) defaultVID (%d)",
				extDev->linkID,
				extDev->portMask,
				extDev->extDevice,
				defaultVID);
	
	_rtl8651_fwdEngineRearrangeExtDevBridge();

	/* return LinkID */
	*linkID_p = extDev->linkID;

	return SUCCESS;
}

/*
@func int32		| rtl8651_fwdEngineUnregExtDevice | Un-Register (LinkID<->Port Number) binding.
@parm uint32		|	linkID		| pointer to the LinkID of current extension device.
@rvalue FAILED	|	LinkID is not found.
@rvalue SUCCESS	| 	UnRegistration OK.
@comm 
UnRegister exist LinkID from Rome Driver.
	Extension device would need to provide it's <p linkID> which gotten from registration function.
	Rome Driver would remove the related information for this <p linkID>.
 */
int32 rtl8651_fwdEngineUnregExtDevice(uint32 linkID)
{
	int32 retval = FAILED;
 
	rtlglue_drvMutexLock();
	retval = _rtl8651_fwdEngineUnregExtDevice(linkID);
	rtlglue_drvMutexUnlock();

	return retval;
}

/* Internal Function for Extension Device Un-Registration */
static int32 _rtl8651_fwdEngineUnregExtDevice(uint32 linkID)
{
	int32 idx;

	idx = _RTL8651_EXTDEV_LINKID2IDX(linkID);

	if (	(idx < 0) ||
		(idx >= _RTL8651_EXTDEV_DEVCOUNT))
	{
		return LR_ERROR_PARAMETER;
	}

	if (rtl8651_extDevList[idx].linkID == 0)
	{
		return LR_NOTFOUND;
	}

	RTL_NOTICE(RTL_MSG_EXTDEV,
				"Remove Extension Device [%d] : PortMask(0x%x) extDevice(0x%p)",
				rtl8651_extDevList[idx].linkID,
				rtl8651_extDevList[idx].portMask,
				rtl8651_extDevList[idx].extDevice);

	/* clear related information about this extension device */
//	_rtl8651_removeArpAndNaptFlowWhenLinkDown(-1, &linkID);

#ifdef _RTL8651_L2ENG_EXTDEV_MACLEARNING_CACHE
	/* flush SMAC cache */
	_rtl8651_extDevMacLearningCache_flush();
#endif
	/* If no other extension devices use this port, we remove it from peripheral extenion port */
	{
		int32 i;
		int32 extPortInused = FALSE;

		for ( i = 0 ; i < _RTL8651_EXTDEV_DEVCOUNT ; i ++ )
		{
			if (	(i == idx) ||
				(rtl8651_extDevList[idx].linkID == 0))
			{
				continue;
			}

			/*
				This imply:
					This extension port is used by other extension device.
					So we don't need to remove it from extension port list (this used in other part of Rome Driver).
			*/
			if (rtl8651_extDevList[idx].portMask == rtl8651_extDevList[i].portMask)
			{
				extPortInused = TRUE;
				break;
			}
		}

		if (extPortInused == FALSE)
		{
			uint32 removePortMask = rtl8651_extDevList[idx].portMask;

			for ( i = 0 ; removePortMask != 1 ; i ++ )
			{
				removePortMask >>= 1;
			}

			RTL_NOTICE(	RTL_MSG_EXTDEV,
							"Remove Peripheral Port Number (%d) (mask 0x%x)",
							i,
							rtl8651_extDevList[idx].portMask);
			
			_rtl8651_delPeripheralExtPort(i);
		}
	}

	/* clear Vlan filtering mask for this extension device */
	_rtl8651_extDeviceVlanMbrClr(linkID);

	/* clear Entry */
	memset(&(rtl8651_extDevList[idx]), 0, sizeof(_rtl8651_extDevice_t));
	
#ifdef CONFIG_BRIDGE
	lightrome_regExtDev(NULL, idx);
#endif

	/* decrease registration count */
	rtl8651_extDevCnt --;

	_rtl8651_fwdEngineRearrangeExtDevBridge();

	return SUCCESS;
}
static _rtl8651_extDevice_t *_rtl8651_fwdEngineGetExtDevEntryByExtDevPtr(void *extDevice)
{
	int32 idx;

	for ( idx = 0 ; idx < _RTL8651_EXTDEV_DEVCOUNT ; idx ++ )
	{
		if (	(rtl8651_extDevList[idx].extDevice == extDevice) &&
			(rtl8651_extDevList[idx].linkID != 0) )
		{
			//assert(rtl8651_extDevList[idx].portMask != 0);
			if (rtl8651_extDevList[idx].portMask != 0)
				return NULL;

			return &(rtl8651_extDevList[idx]);
		}
	}

	return NULL;
}

/*
@func int32		| rtl8651_fwdEngineGetLinkIDByExtDevice | Get LinkID for the specific extension device.
@parm void*		|	extDevice	| extension device's own pointer.
@rvalue LinkID	|	LinkID of the specific device, return 0 if not found.
@comm 
Get the LinkID of the specific extension device by <p extDevice> provided in registration proceduce.
We can make sure there is no any redundancy for <p extDevice> so the LinkID would be unique for
an <p extDevice>.
If <p extDevice> is not found in Rome Driver, 0 would be returned.
 */
int32 rtl8651_fwdEngineGetLinkIDByExtDevice(void *extDevice)
{
	int32 linkID = 0;
	_rtl8651_extDevice_t *extDev = NULL;

	if (extDevice == NULL)
	{
		goto out;
	}

	rtlglue_drvMutexLock();

	extDev = _rtl8651_fwdEngineGetExtDevEntryByExtDevPtr(extDevice);
	if (extDev)
	{
		linkID = extDev->linkID;
	}

	rtlglue_drvMutexUnlock();

out:
	return linkID;
}

/*
@func int32			| rtl8651_fwdEngineSetExtDeviceVlanProperty | Set LinkID's VLAN property for TX filtering/process
@parm uint32			|	linkID		| LinkID of extension device.
@parm uint16			|	vid			| VID to process.
@parm uint32			|	property		| property to apply on <p linkID> and <p vid> relationship.
@rvalue SUCCESS		|	Property set OK.
@rvalue NON-SUCCESS	|	Problem occurs when setting property.
@comm 
Set VLAN TX filtering property for specific extension device:
	<p RTL8651_EXTDEV_VLANPROPER_ISMBR>	notes that the extension device indicated by <p linkID> is VLAN <p vid>'s member.
	<p RTL8651_EXTDEV_VLANPROPER_NOTMBR>	notes that the extension device indicated by <p linkID> is not VLAN <p vid>'s member.

	- Note: the relationship is used ONLY for TX yet.
*/
int32 rtl8651_fwdEngineSetExtDeviceVlanProperty(uint32 linkID, uint16 vid, uint32 property)
{
	int32 retval = FAILED;

	rtlglue_drvMutexLock();
	retval = _rtl8651_fwdEngineSetExtDeviceVlanProperty(linkID, vid, property);
	rtlglue_drvMutexUnlock();

	return retval;
}

static int32 _rtl8651_fwdEngineSetExtDeviceVlanProperty(	uint32 linkID,
																uint16 vid,
																uint32 property)
{
	uint32 idx;
	struct vlan_entry *ventry;
	
	idx = _RTL8651_EXTDEV_LINKID2IDX(linkID);
	/*
		Check parameters.
	*/

	if (	(idx < 0) ||
		(idx >= _RTL8651_EXTDEV_DEVCOUNT))
	{
		return LR_ERROR_PARAMETER;
	}

	if (vid == 0)
	{
		return LR_ERROR_PARAMETER;
	}


	if (rtl8651_extDevList[idx].linkID == 0)
	{
		return LR_NOTFOUND;
	}

/*	if (	(DrvTbl.vlan[rtl8651_vlanTableIndex(vid)].valid == FALSE) ||
		(DrvTbl.vlan[rtl8651_vlanTableIndex(vid)].vid != vid) ||
		((DrvTbl.vlan[rtl8651_vlanTableIndex(vid)].memberPortMask & rtl8651_extDevList[idx].portMask) == 0)	)
	{
		return TBLDRV_EINVALIDINPUT;
	}*/
	//ventry = lr_get_vlan(rtl8651_vlanTableIndex(vid));
	ventry = lr_get_vlan(vid);
	if (ventry == NULL )
		return LR_INVAPARAM;
	if (ventry->valid == FALSE || (ventry->mbr & rtl8651_extDevList[idx].portMask) == 0)
		return LR_INVAPARAM;


	/* ======================================================
			Property process
	    ====================================================== */
	switch (property)
	{
		/*
			This LinkID is VLAN's member port.
		*/
		case RTL8651_EXTDEV_VLANPROPER_ISMBR:
		{
			VLAN_MEMDEV_IDX_SET(idx, vid, rtl8651_usrSettingMemberDevMask);
			break;
		}
		/*
			This LinkID is NOT VLAN's member port.
		*/
		case RTL8651_EXTDEV_VLANPROPER_NOTMBR:
		{
			VLAN_MEMDEV_IDX_CLR(idx, vid, rtl8651_usrSettingMemberDevMask);
			break;
		}
	}

	/*
		Always rearrange Extension Device VLAN member port settting for internal process.
	*/
	_rtl8651_arrangeAllExtDeviceVlanMbr();

	return SUCCESS;
}

int32 _rtl8651_addPeripheralExtPort(uint32 port)
{
	RTL_NOTICE(	RTL_MSG_EXTDEV,
					"Add Peripheral Extension port: %d",
					port);

	if (port >= RTL8651_PORT_NUMBER + rtl8651_ExtPortNum)
	{
		RTL_ERR(	RTL_MSG_EXTDEV,
					"Illegal peripheral extension port : %d (Too large, Max: %d)",
					port,
					RTL8651_PORT_NUMBER + rtl8651_ExtPortNum);

		return FAILED;
	}
	peripheralExtPortMask |= 1<<port;

	RTL_NOTICE(	RTL_MSG_EXTDEV,
					"Reserve port %d for peripheral device. Current peripheral Port Mask: 0x%x",
					port,
					peripheralExtPortMask);

	return SUCCESS;
}

int32 _rtl8651_delPeripheralExtPort(uint32 port)
{
	RTL_NOTICE(	RTL_MSG_EXTDEV,
					"Remove Peripheral Extension port: %d",
					port);

	if (port >= RTL8651_PORT_NUMBER + rtl8651_ExtPortNum)
	{
		RTL_ERR(	RTL_MSG_EXTDEV,
					"Illegal peripheral extension port : %d (Too large, Max: %d)",
					port,
					RTL8651_PORT_NUMBER + rtl8651_ExtPortNum);

		return FAILED;
	}

	peripheralExtPortMask &= ~ ( 1 << port);

	RTL_NOTICE(	RTL_MSG_EXTDEV,
					"Remove port %d for peripheral device. Current peripheral Port Mask: 0x%x",
					port,
					peripheralExtPortMask);

	return SUCCESS;
}

/*
	Automatically turn ON/OFF Extenion Device Bridge Module according to exist extension device count.
*/
static void _rtl8651_fwdEngineRearrangeExtDevBridge(void)
{
	if ( rtl8651_extDevCnt > 1 )
	{	/* Turn ON Extension-Device-bridge module because more than 1 extension devices exist */
		rtl8651_bridgeEnable = TRUE;
	} else
	{	/* Turn OFF Extension-Device-bridge module because less than 1 extension device exist */
		rtl8651_bridgeEnable = FALSE;
	}

	RTL_NOTICE(RTL_MSG_EXTDEV,
				"Registered Extension Device Count: %d : Bridge module [%s]",
				rtl8651_extDevCnt,
				(rtl8651_bridgeEnable == TRUE)?"ENABLE":"DISABLE");

}

/*
	Clear VLAN Member Device mask for specific LinkID

	- Note that we don't check the correctness of linkID in this function.
*/
static inline void _rtl8651_extDeviceVlanMbrClr(uint32 linkID)
{
	uint32 idx;
	for ( idx = 0 ; idx < RTL8651_VLAN_NUMBER ; idx ++ )
	{
		VLAN_MEMDEV_LID_CLR(	linkID,
								/*
									We CAN just simply use vidx as VLAN id here.
									Because there is a bit-mask relationship between VLAN table Index and VID.
								*/
								idx,
								rtl8651_usrSettingMemberDevMask);
	}
	_rtl8651_arrangeAllExtDeviceVlanMbr();
}

/*
	Automatically set some default VLAN membership of LinkIDs

	Arrange process:

	User Setting VLAN member port ------
									|
									|
									+ ----------------> Actual VLAN member port setting in DATA PATH
									|
									|
	Internal VLAN member port setting ----



	
*/
void _rtl8651_arrangeAllExtDeviceVlanMbr(void)
{
	uint32 extDevIdx;
	struct vlan_entry *ventry;
	uint32 vidx;


	/* ================================================================
			1.	Copy user-setting VLAN member port to Actual VLAN member port
	    ================================================================ */

	memcpy(	rtl8651_vlanMemberDevMask,
				rtl8651_usrSettingMemberDevMask,
				sizeof(rtl8651_vlanMemberDevMask));

	/* ================================================================
			2.	Apply internal VLAN member port setting	- For Each LinkID
	    ================================================================ */

	for ( extDevIdx = 0 ; extDevIdx < _RTL8651_EXTDEV_DEVCOUNT ; extDevIdx ++ )
	{

		/* ============================================================ */

		/*
			2.1	Passthrough VLAN Member Port
				we need to add ALL linkID as member for passthrough VLAN.
		*/
/*		if (	(rtl8651_l2protoPassThrough & PASSTHRU_PPPOE) &&
			(rtl8651_gPPPoEPassthruVlanID != RTL8651_PPPOEPASSTHRU_VLANID_IS_NOT_SET))
		{
			VLAN_MEMDEV_IDX_SET(	extDevIdx,
									rtl8651_gPPPoEPassthruVlanID,
									rtl8651_vlanMemberDevMask);
		}
		if (	(rtl8651_l2protoPassThrough & PASSTHRU_IPV6) &&
			(rtl8651_gIPv6PassthruVlanID != RTL8651_PPPOEPASSTHRU_VLANID_IS_NOT_SET))
		{
			VLAN_MEMDEV_IDX_SET(	extDevIdx,
									rtl8651_gIPv6PassthruVlanID,
									rtl8651_vlanMemberDevMask);
		}
		if (	(rtl8651_l2protoPassThrough & PASSTHRU_IPX) &&
			(rtl8651_gIPXPassthruVlanID != RTL8651_PPPOEPASSTHRU_VLANID_IS_NOT_SET))
		{
			VLAN_MEMDEV_IDX_SET(	extDevIdx,
									rtl8651_gIPXPassthruVlanID,
									rtl8651_vlanMemberDevMask);
		}
		if (	(rtl8651_l2protoPassThrough & PASSTHRU_NETBIOS) &&
			(rtl8651_gNetbiosPassthruVlanID != RTL8651_PPPOEPASSTHRU_VLANID_IS_NOT_SET))
		{
			VLAN_MEMDEV_IDX_SET(	extDevIdx,
									rtl8651_gNetbiosPassthruVlanID,
									rtl8651_vlanMemberDevMask);
		}*/

		/* ============================================================ */
	}

	/* ================================================================
			3.	Filter bit setting if VLAN is invalid or
				VLAN member port doest not include LinkID's port mask
	    ================================================================ */
	for ( vidx = 0 ; vidx < RTL8651_VLAN_NUMBER ; vidx ++ )
	{
		/*
			3.1	Invalid VLAN : clear ALL related mask
		*/
		//ventry = lr_get_vlan(vidx);
		ventry = lr_get_vlan_byidx(vidx);
		if (ventry == NULL )
			continue ;
		
		if (ventry->valid == FALSE)
		{
			if((ventry->vid != 0) && (vidx == rtl8651_vlanTableIndex(ventry->vid)))
			{
				for ( extDevIdx = 0 ; extDevIdx < _RTL8651_EXTDEV_DEVCOUNT ; extDevIdx ++ )
				{
					VLAN_MEMDEV_IDX_CLR(	extDevIdx,
											ventry->vid,
											rtl8651_vlanMemberDevMask);
				}
			}
			
		} else
		{
			/* Exist VLAN process */
		
			/*
				3.2	VLAN's member port does NOT include extension device's member port : clear it's related mask
			*/
			for ( extDevIdx = 0 ; extDevIdx < _RTL8651_EXTDEV_DEVCOUNT ; extDevIdx ++ )
			{
				if ((ventry->mbr& rtl8651_extDevList[extDevIdx].portMask) == 0)
				{
					VLAN_MEMDEV_IDX_CLR(	extDevIdx,
											ventry->vid,
											rtl8651_vlanMemberDevMask);
				}
			}
		}
	}
}

/*
	Initial function of external device support
*/
static int32 _rtl8651_extDeviceInit(void)
{
	/* init extenion device list */
	memset(rtl8651_extDevList, 0, sizeof(rtl8651_extDevList));
	memcpy(extPortMaskToPortNum, _extPortMaskToPortNum, sizeof(extPortMaskToPortNum));

	/* init member port mask : all bits are zero at initial state */
	memcpy(rtl8651_vlanMemberDevMask, _rtl8651_vlanMemberDevMask, sizeof(rtl8651_vlanMemberDevMask));
	memset(rtl8651_vlanMemberDevMask, 0, sizeof(rtl8651_vlanMemberDevMask));
	memset(rtl8651_usrSettingMemberDevMask, 0, sizeof(rtl8651_usrSettingMemberDevMask));
	_rtl8651_arrangeAllExtDeviceVlanMbr();

#ifdef _RTL8651_L2ENG_EXTDEV_MACLEARNING_CACHE
	/* Init MAC learning cache */
	_rtl8651_extDevMacLearningCache_reset();
#endif

	rtl8651_bridgeEnable = FALSE;
	rtl8651_extDevCnt = 0;

	return SUCCESS;
}
/*
	Init function for Layer2 Forwarding Engine
*/
int32 rtl8651_extDeviceinit(void)
{
	_rtl8651_extDeviceInit();

	return SUCCESS;
}

#if 0
/*==========================receive package================================*/

__IRAM_EXTDEV static int32  _rtl8651_fwdEnginePciSend(void * data, int16 dvid, int32 iphdrOffset)
{
	struct rtl_pktHdr * pkthdrPtr=(struct rtl_pktHdr *)data;

	struct rtl_mBuf *mbuf;
	//rtl8651_tblDrv_vlanTable_t *local_vlanp;	

	mbuf=pkthdrPtr->ph_mbuf;
	pkthdrPtr->ph_vlanIdx = rtl8651_vlanTableIndex(dvid);
	//local_vlanp = &DrvTbl.vlan[pkthdrPtr->ph_vlanIdx ];
	if (peripheralExtPortMask > RTL8651_PHYSICALPORTMASK)
	{
		/*	specify a NULL portlist and a src ext port number to let NIC driver know that this pkt is to be 
			sent via ext port.																*/
		pkthdrPtr->ph_srcExtPortNum =
			extPortMaskToPortNum[(pkthdrPtr->ph_portlist>>RTL8651_PORT_NUMBER) & _RTL865XB_EXTPORTMASKS];
		pkthdrPtr->ph_portlist = 0;
	} else
	{
		pkthdrPtr->ph_srcExtPortNum = 0;
	}

	
	/* send pkt here */
	rtlglue_drvSend((void*)data);

	return SUCCESS;
}
/*
@func int32		| rtl8651_fwdEngineExtPortRecv | Receive packet from Extension Device to HW
@parm void*		| id				| external buffer pointer (For Linux platform, it would be SKBuff's pointer).
@parm uint8*		| data			| packet content
@parm uint32		| len			| length of packet
@parm uint16		| myvid			| source VID
@parm uint32		| myportmask		| source PortMASK
@parm uint32		| linkID			| source LinkID
@rvalue FAILED	| Packet processing FAILED.
@rvalue SUCCESS	| Packet is successfully sent.
@rvalue THROW_TO_PS	| Throw the package to protocol stack.
@comm
Receive Packet from extension device, this function would do
L2 extension port BRIDGE if this packet need forward to other extension devices.
 */
__IRAM_EXTDEV int32 rtl8651_fwdEngineExtPortRecv(	void *id,
														uint8 *data,
														uint32 len,
														uint16 myvid,
														uint32 myportmask,
														uint32 linkID)
{
	struct rtl_pktHdr *	pktHdr	= NULL;	
	struct rtl_mBuf*	m		= NULL;
	int32			retval	= FAILED;
//	rtl8651_tblDrv_vlanTable_t *thisVlan;
	struct vlan_entry *ventry;

	
	//thisVlan = &DrvTbl.vlan[ rtl8651_vlanTableIndex(myvid)];
	//ventry = lr_get_vlan(rtl8651_vlanTableIndex(myvid));
	ventry = lr_get_vlan(myvid);


#ifdef CONFIG_RTL865XB	
	/*reset watchdog timer.*/
	REG32(WDTCNR)|=WDTCLR;
#endif

	if (linkID == 0)
	{
		rtlglue_printf("packet from illegal-device-LinkID (%d)\n", linkID);
		goto unlock_out;
	}

	assert(data);

	rtlglue_drvMutexLock();

		
	if ((data[0] & 1) || (*((uint16 *)(data+12)) != htons(0x0800)))
	{
		/* only check L2 table when broadcast pkt or non-IP pkt is received. */
		_rtl8651_extPortRecvL2Lookup(	(ether_addr_t*)&(data[6]),
										myvid,
										myportmask,
										linkID);
	}
#ifdef _RTL8651_L2ENG_EXTDEV_MACLEARNING_CACHE
	else
	{	/* Other case : use SMAC cache to process off-line SMAC-learnning */
		_rtl8651_extDevMacLearningCache_addEntry(	(ether_addr_t*)&(data[6]),
													myvid,
													myportmask,
													linkID);
		RTL_DEBUG(RTL_MSG_EXTDEV,"non ip packet src mac learn linkID is %d\n", linkID);
	}
#endif	
	
#ifdef CONFIG_BRIDGE
	if (memcmp(data, &(ventry->mac), sizeof(ether_addr_t)))
	{
		retval = -2;
		goto out;
	}
#endif

	/* get a new mbuf/pkthdr pair to bind with given packet */
	m = mBuf_attachHeader((void*)UNCACHE(data),(uint32)(id),m_clusterSize, len,0);
	if (!m)
	{
		#ifdef RTL865X_DEBUG
		rtlglue_printf("X");
		#endif/* RTL865X_DEBUG*/
		goto out;
	}
	SETBITS(m->m_flags, MBUF_EXT);

	pktHdr = m->m_pkthdr;
	pktHdr->ph_property = PH_PROPER_EXTDEV;
	pktHdr->ph_portlist = myportmask;			/* set for _rtl8651_fwdEnginePciSend() : To indicate Source extension port number */


	/* Don't touch higher layer cksum fields. */
	pktHdr->ph_flags &= ~(CSUM_IP| CSUM_L4|PKTHDR_BRIDGING);

	/* When WDS is enabled,is unicast pkt,is not GW mac, check if it is to another WLAN station. */
	if (rtl8651_bridgeEnable)
	{
#ifdef CONFIG_RTL865X_MULTICAST		
		if((data[0]==0x01) && (data[1]==0x00) && (data[2]==0x5e) && ( rtl8651_drvMulticastProcessEnable == TRUE)) 
		{
			/*don't flood igmp or multicast data, because igmp proxy available, by qjj */
		}
		else
#endif
		{
		
			if (_rtl8651_fwdEngineExtDevBridge (	data,
												pktHdr,
												linkID,
												ventry) > 0)
			{
				retval = SUCCESS;
				goto out;
			}
		}
	}

	/* check some checksum related issue before sending to ASIC */
#ifdef CONFIG_RTL865XB
	_rtl8651_ExtPortChecksumProcess(m);
#endif

	/* Finally, send to swcore directly */
	_rtl8651_fwdEnginePciSend((void*)pktHdr, myvid, -1);
	retval = SUCCESS;	

out:
	rtlglue_drvMutexUnlock();
unlock_out:

	return retval;	/* pkt consumed. */
}
#endif

#ifdef CONFIG_RTL865X_EXTPORT
/*
 * purpose: mapping rtlglue_extPortRecv() to swNic_send()
 * int32 swNic_send(void *skb, void * output, uint32 len,unsigned int vid, unsigned int pid)
 */
int32 rtlglue_extPortRecv2(void *id, uint8 *data,  uint32 len, uint16 myvid, uint32 myportmask, uint32 linkID)
{

/* =========================================
	Forward packet to driver
     ========================================= */

	int32			retval	= FAILED;
	struct vlan_entry *ventry;

	ventry = lr_get_vlan(myvid);

	if (linkID == 0)
	{
		rtlglue_printf("packet from illegal-device-LinkID (%d)\n", linkID);
              retval = -2; // trap to CPU
		goto unlock_out;
	}

	assert(data);

	rtlglue_drvMutexLock();

	if ((data[0] & 1) || (*((uint16 *)(data+12)) != htons(0x0800)))
	{
		/* only check L2 table when broadcast pkt or non-IP pkt is received. */
		_rtl8651_extPortRecvL2Lookup(	(ether_addr_t*)&(data[6]),
										myvid,
										myportmask,
										linkID);
	}
#ifdef _RTL8651_L2ENG_EXTDEV_MACLEARNING_CACHE
	else
	{	/* Other case : use SMAC cache to process off-line SMAC-learnning */
		_rtl8651_extDevMacLearningCache_addEntry(	(ether_addr_t*)&(data[6]),
													myvid,
													myportmask,
													linkID);
		RTL_DEBUG(RTL_MSG_EXTDEV,"non ip packet src mac learn linkID is %d\n", linkID);
	}
#endif	

#ifdef CONFIG_BRIDGE
	if (memcmp(data, &(ventry->mac), sizeof(ether_addr_t)))
	{
		retval = -2;
		goto out;
	}
#endif

    if ((data[0] & 0x01)) //MC/BC, trap to CPU
    {
        retval = -2;
        goto out;
    }

	/* Finally, send to swcore directly */

	if (peripheralExtPortMask > RTL8651_PHYSICALPORTMASK)
	{
              myportmask = extPortMaskToPortNum[(myportmask>>RTL8651_PORT_NUMBER) & _RTL865XB_EXTPORTMASKS];
	       /* send packet here */
	       rtl865x_start_xmit2( (struct sk_buff *)id, myportmask);
              retval = SUCCESS;
	} else
	{
              retval = -2; //trap to CPU
	}
  

out:

	rtlglue_drvMutexUnlock();
unlock_out:

	return retval;	/* pkt consumed. */
}
#endif

#ifdef _RTL8651_L2ENG_EXTDEV_MACLEARNING_CACHE
/*
	Init MAC Learning cache
*/
static int32 _rtl8651_extDevMacLearningCache_reset(void)
{
	RTL_DEBUG(	RTL_MSG_EXTDEV,
				"Clear extension-device MAC learning cache");

	/* init extension device's SMAC learning cache : set valid bit to 0 at initial state */
	memset(_rtl8651_extDev_macLearning_Cache, 0, sizeof(_rtl8651_extDev_macLearning_Cache));

	return SUCCESS;
}

/*
	Store SMAC information into CACHE
*/
__IRAM_EXTDEV static inline void _rtl8651_extDevMacLearningCache_addEntry(	ether_addr_t *	smac,
																				uint16			vid,
																				uint32			portMask,
																				uint32			linkID		)
{
	_rtl8651_extDevMacLearningCache_t *macCacheEntry_p;
	uint32 idx;

	RTL_DEBUG(	RTL_MSG_EXTDEV,
				"Add MAC Learning cache entry:");
	RTL_DEBUG(	RTL_MSG_EXTDEV,
				"\tMAC[%x:%x:%x:%x:%x:%x]",	smac->octet[0],
												smac->octet[1],
												smac->octet[2],
												smac->octet[3],
												smac->octet[4],
												smac->octet[5]	);
	RTL_DEBUG(	RTL_MSG_EXTDEV,
				"\tSVID: %d", vid);
	RTL_DEBUG(	RTL_MSG_EXTDEV,
				"\tPortMASK: %x", portMask);
	RTL_DEBUG(	RTL_MSG_EXTDEV,
				"\tLinkID: %d", linkID);

	/* simply hash to get index */
	idx = ((uint32)(smac->octet[5]) ^ (uint32)(linkID)) & (_RTL8651_EXTDEV_MACLEARNING_CACHE_COUNT - 1);

	RTL_DEBUG(	RTL_MSG_EXTDEV,
				"\tHash table index: %d", idx);

	/* Set corresponding entry */
	macCacheEntry_p = &(_rtl8651_extDev_macLearning_Cache[idx]);

	macCacheEntry_p->valid = 1;
	memcpy(&(macCacheEntry_p->mac), smac, sizeof(ether_addr_t));
	macCacheEntry_p->vid = vid;
	macCacheEntry_p->portMask = portMask;
	macCacheEntry_p->linkId = linkID;

	return;
}


/*
	Periodically set SMAC information into system
*/
static int32 _rtl8651_extDevMacLearningCache_flush(void)
{
	uint32 idx;

	for ( idx = 0 ; idx < _RTL8651_EXTDEV_MACLEARNING_CACHE_COUNT ; idx ++ )
	{
		if (_rtl8651_extDev_macLearning_Cache[idx].valid)
		{
			RTL_DEBUG(RTL_MSG_EXTDEV,"find valid l2 software cache\n");
			RTL_DEBUG(RTL_MSG_EXTDEV,"the mac is %d %d %d %d %d %d",	_rtl8651_extDev_macLearning_Cache[idx].mac.octet[0],
													_rtl8651_extDev_macLearning_Cache[idx].mac.octet[1],
													_rtl8651_extDev_macLearning_Cache[idx].mac.octet[2],
													_rtl8651_extDev_macLearning_Cache[idx].mac.octet[3],
													_rtl8651_extDev_macLearning_Cache[idx].mac.octet[4],
													_rtl8651_extDev_macLearning_Cache[idx].mac.octet[5]);
			/* Store SMAC cache's information into system */
			_rtl8651_extPortRecvL2Lookup(	&(_rtl8651_extDev_macLearning_Cache[idx].mac),
											_rtl8651_extDev_macLearning_Cache[idx].vid,
											_rtl8651_extDev_macLearning_Cache[idx].portMask,
											_rtl8651_extDev_macLearning_Cache[idx].linkId			);

			
			/* Clear learned MAC */
			_rtl8651_extDev_macLearning_Cache[idx].valid = 0;
		}
	}
	return SUCCESS;
}

#endif

#ifdef CONFIG_RTL865XB
__IRAM_EXTDEV static void _rtl8651_ExtPortChecksumProcess(struct rtl_mBuf *mbuf)
{
	/* handler for the case: (UDP checksum == 0) */
	uint8 *pkt = mbuf->m_data;
	uint16 byte2;
	uint32 etherPos = 12;
	struct ip *pip = NULL;

nextRound:
	byte2 = *(uint16*)(&pkt[etherPos]);
	switch (byte2)
	{
		case 0x0800:
			pip = (struct ip *)(&pkt[(etherPos+2)]);
			break;
		case 0x8864:
			byte2 = ntohs(*((uint16 *)(&pkt[etherPos + 8])));
			if (byte2 == 0x2100)
			{
				pip = (struct ip *)(&pkt[(etherPos + 10)]);
				break;
			} else
			{
				goto check_done;
			}
		case 0x8100:	/* Tagged */
			if ( pkt[etherPos + 2] & 0x10 )
			{	/* CFI bit is set, ignore */
				goto check_done;
			}
			etherPos += 4;
			goto nextRound;
		default:	/* other cases, including LLC, other Ethertypes .... we don't process them or don't support them (ex.LLC) here */
			goto check_done;
	}

	assert(pip);

	if ((pip->ip_vhl & 0xf0) != 0x40)
	{
		goto check_done;
	}

	if (	(!IS_FRAGMENT(pip->ip_off)) &&
		(pip->ip_p == IPPROTO_UDP))
	{
		struct udphdr *ud = (struct udphdr*)L4HDR_ADDR(pip);

		if (ud->uh_sum == 0)
		{
			ud->uh_sum = 0;
			pip->ip_sum = 0;
			ud->uh_sum = _rtl8651_tcpChecksum(pip);
			pip->ip_sum = _rtl8651_ipChecksum(pip);
		}
	}

check_done:
	return;
}
#endif

#if 0
/*********************************************************************************
* Routine Name :  _rtl8651_ipChecksum                                   
* Description : 
* Input :                                                               
* Output :                                                             
* Return :                                                             
* Note :   
*        ThreadSafe: n
**********************************************************************************/
uint16 
_rtl8651_ipChecksum(struct ip * pip)
{


	uint32     sum=0,oddbyte=0;
	uint16 *ptr = (uint16 *)pip;
	uint32 nbytes = ((pip->ip_vhl & 0xf) << 2);	

	while (nbytes > 1)
	{
		
		sum += (*ptr++);
		nbytes -= 2;
	}
	if (nbytes == 1)
	{
		//oddbyte = 0;
		//((uint8 *) & oddbyte)[0] = *(uint8 *) ptr;
		//((uint8 *) & oddbyte)[1] = 0;
		oddbyte = (*ptr & 0xff00);
		sum += oddbyte;
	}
	
	sum = (sum >> 16) + (sum & 0xffff);
	sum += (sum >> 16);
	
	return (~sum);


}


/*********************************************************************************
* Routine Name :  _rtl8651_tcpChecksum                                   
* Description : 
* Input :                                                               
* Output :                                                             
* Return :                                                             
* Note :   
*        ThreadSafe: n
**********************************************************************************/

uint16 _rtl8651_tcpChecksum(struct ip *pip)
{
	int32 sum, nbytes, nhdr, i;
	uint16 *sip, *dip, *ptr;

	nhdr =  ((pip->ip_vhl & 0xf) << 2);
	nbytes = ntohs(pip->ip_len) - nhdr;
	ptr = (uint16 *) ((char *) pip + nhdr);
	sum = 0;

	/* Note: We always padding zero to the tail of the packet!! */
	*(((uint8 *)pip) + nhdr + nbytes) = (uint8)0;
	for (i=0; i<nbytes ;i=i+2){
		sum += (unsigned long)*ptr++;
	}

	/* "Pseudo-header" data */
	dip=(uint16 *)&pip->ip_dst;
	sum += *dip; dip++;
	sum += *dip;
	sip=(uint16 *)&pip->ip_src;
	sum += *sip; sip++;
	sum += *sip;	

	sum +=  nbytes;
	sum += ((uint16) pip->ip_p);

	/* Roll over carry bits */
	while (sum>>16)
		sum = (sum & 0xFFFF)+(sum >> 16);
	
	/* Take the one's complement of sum */
	sum = ~sum;
	return (uint16)sum;
	
}

/*********************************************************************************
* Routine Name :  _rtl8651_icmpChecksum                                   
* Description : 
* Input :                                                               
* Output :                                                             
* Return :                                                             
* Note :   
*        ThreadSafe: n
**********************************************************************************/
/* shoud continue memory */
uint16 
_rtl8651_icmpChecksum(struct ip * pip)
{
	uint16   *ptr;
	int32  nhdr, nbytes;
	int32  sum, i;


	nhdr =  ((pip->ip_vhl &0xf) << 2);
	nbytes = ntohs(pip->ip_len) - nhdr;
	ptr = (uint16 *) ((char *) pip + nhdr);
	sum = 0;

	/* Note: we always padding here!! */
	*(((uint8 *)pip) + nhdr + nbytes) = (uint8)0;
	for (i=0; i<nbytes ; i=i+2){
		sum +=  (unsigned long) *ptr++;
	}

	/* Roll over carry bits */
	sum = (sum >> 16) + (sum & 0xffff);
	sum += (sum >> 16);

	/* Return checksum */
	return ((uint16) ~ sum);
}

__IRAM_L2_FWD int32 rtl8651_txPktPostProcessing(struct rtl_pktHdr * pPkt)
{
	uint32 destPortMask = pPkt->ph_portlist;

	destPortMask &= ~0x40; /* clear CPU port. */
	if (destPortMask)
	{
		/* if portmask contains MII port. MII port must be configured before we can send pkt to it. */
		if (destPortMask & RTL8651_MII_PORTMASK && miiPhyAddress < 0)
		{
			destPortMask&=~RTL8651_MII_PORTMASK;
		}

		pPkt->ph_srcExtPortNum = pPkt->ph_extPortList = 0;
		pPkt->ph_flags &= ~(PKTHDR_BRIDGING|PKTHDR_HWLOOKUP);
		destPortMask &= ~rtl8651_allExtPortMask;
	}
#if defined (CONFIG_RTL865XB) || defined (CONFIG_RTL865XC)
	else if (pPkt->ph_srcExtPortNum)
	{
		pPkt->ph_flags |= PKTHDR_HWLOOKUP;	/* turn on hardware L3/4 offloading for pkts from extension port. */
		destPortMask = 7;	/* send from extension port. destination portmask unknown */

	} else
#endif /*CONFIG_RTL865XB*/
	{
		pPkt->ph_flags &= ~(PKTHDR_BRIDGING|PKTHDR_HWLOOKUP);	/* always clear these bits in 8650/51 */
	}
	pPkt->ph_portlist = destPortMask;


	return SUCCESS;

}	
#endif


static void _rtl8651_extPortRecvL2Lookup(ether_addr_t *smac, uint16 myvid, uint32 myportmask, uint32 linkID)
{
	uint32 memport;
	uint32 link_id;
	uint32 way0;
 	
	RTL_DEBUG(RTL_MSG_EXTDEV,"enter extPortRecvL2Lookup\n");
	struct vlan_entry *ventry;
	
	
	ventry = lr_get_vlan(myvid);
	if (ventry == NULL || ventry->valid == FALSE)
		return;

	//SA learning, but don't learn gateway MAC.
	if (memcmp(&ventry->mac, smac, sizeof(ether_addr_t)) == 0)
		return;
	
	 if (lr_ext_fdb_lookup(ventry->fid, (ether_addr_t*)smac, &memport, &link_id,&way0,FDB_DYNAMIC) == LR_INVAPARAM){
		

		rtl865x_addExtFdbEntry(ventry->fid, (ether_addr_t *)smac, myportmask, linkID, FDB_FWD);

		
	} else {
		rtl865x_modifyExtFdbEntry(ventry->fid, (ether_addr_t *)smac, myportmask, linkID, FDB_FWD);
	}
}

#if 0
/*
	Remove VLAN Tag from packet
*/
static void 
_rtl8651_fwdEngineStripVlanTag(struct rtl_pktHdr * pPkthdr)
{
	struct rtl_mBuf *thisMbuf = pPkthdr->ph_mbuf;
	uint8 *data = thisMbuf->m_data;
	uint8 dasa[12];

	memcpy(dasa, data, 12);
	memcpy(data+4, dasa, 12);
	pPkthdr->ph_len -= 4;
	thisMbuf->m_len -= 4;
	thisMbuf->m_data += 4;
}

/*
	Modify VLAN Tag in packet
*/
static void _rtl8651_fwdEngineModifyVlanTag(	struct rtl_pktHdr *pktHdr,
												uint16 vid,
												uint8 priority)
{
	struct rtl_mBuf *mbuf;

	mbuf = pktHdr->ph_mbuf;

	/* We need to make sure this packet is C-Tagged */
	if (VLAN_TAGGED(mbuf->m_data))
	{
		/* Modify VLAN Tag */
		*(uint16*)(&(mbuf->m_data[14])) = htons(vid);					/* VID */
		*(uint8*)(&(mbuf->m_data[14])) &= 0x0f;							/* clear most-significant nibble of byte 14 */
		*(uint8*)(&(mbuf->m_data[14])) |= (((uint8)(priority)) << 5);		/* Add Priority bit, we just get most-significant 3 bits from priority */
	}
}

/*
	Add Tag into packet
*/
static void _rtl8651_fwdEngineAddVlanTag(	struct rtl_pktHdr *pktHdr,
												uint16 vid,
												uint8 priority)
{
	ether_addr_t smac, dmac;
	uint8 priorityField;
	struct rtl_mBuf *mbuf;

	mbuf = pktHdr->ph_mbuf;
	priorityField = ((uint8)(priority)) << 5;	/* just get most-significant 3 bits */

	memcpy(&dmac, mbuf->m_data, sizeof(ether_addr_t));
	memcpy(&smac, &(mbuf->m_data[6]), sizeof(ether_addr_t));
	mbuf->m_data -= 4;
	mbuf->m_len += 4;
	pktHdr->ph_len += 4;

	memcpy(mbuf->m_data, &dmac, sizeof(ether_addr_t));
	memcpy(&(mbuf->m_data[6]), &smac, sizeof(ether_addr_t));

	/* Insert VLAN Tag */
	*(uint16*)(&(mbuf->m_data[12])) = htons(0x8100);		/* TPID */
	*(uint16*)(&(mbuf->m_data[14])) = htons(vid);			/* VID */
	*(uint8*)(&(mbuf->m_data[14])) &= 0x0f;					/* clear most-significant nibble of byte 14 */
	*(uint8*)(&(mbuf->m_data[14])) |= priorityField;			/* Add Priority bit */
}

static void _rtl8651_fwdEngineVlanProcess(	uint8 pktIsTag,
												uint8 txNeedTag,
												struct rtl_pktHdr *pktHdr,
												uint16 vid,
												uint8 priority)
{
	/* We ONLY modify VLAN information for Rome Driver forwarded packets */
	if (pktHdr->ph_property != PH_PROPER_DRVFWD)
	{
		return;
	}

	if (txNeedTag)
	{
		if (pktIsTag)
		{
			/*
				CASE 1: Packet is tagged and Tx packet need tag.
						- We would need to modify VLAN tag
			*/
			_rtl8651_fwdEngineModifyVlanTag(	pktHdr,
												vid,
												priority);
		} else
		{
			/*
				CASE 2: Packet is not tagged and Tx packet need tag.
						- We would need to add VLAN tag
			*/
			_rtl8651_fwdEngineAddVlanTag(	pktHdr,
											vid,
											priority);
		}
	} else
	{
		if (pktIsTag)
		{
			/*
				CASE 3: Packet is tagged and Tx packet does not need tag.
						- We would need to remove VLAN tag
			*/
			_rtl8651_fwdEngineStripVlanTag(pktHdr);
		} else
		{
			/*
				CASE 4: Packet is not tagged and Tx packet does not need tag.
						- We don't need to do anything
			*/
		}
	}
}

int32 rtl8651_getSourceLinkID(void * pkthdr, int32 *linkID)
{
	struct rtl_pktHdr * pkthdrPtr = (struct rtl_pktHdr *)pkthdr;
	struct rtl_mBuf *mbufPtr;
	uint8 *m_data;
	int32 local_val;
	struct vlan_entry *ventry;
	//int32 compare;
	//struct rtl_mBuf *txMbuf;

	rtlglue_drvMutexLock();	/* Lock resource */

	local_val= FAILED;
	ventry = lr_get_vlan_byidx(pkthdrPtr->ph_vlanIdx);
	mbufPtr = pkthdrPtr->ph_mbuf;
	m_data = mbufPtr->m_data;

	uint32 sourcelinkId = 0;	/* 0: default broadcast. */
	uint32 sourcememport = 0;
	uint32 sourceway = 0;
	local_val = lr_ext_fdb_lookup(ventry->fid,(ether_addr_t *)(m_data + 6),&sourcememport,&sourcelinkId,&sourceway,FDB_STATIC|FDB_DYNAMIC);
	if ((sourcememport & (1 << 6)) && local_val == LR_SUCCESS)
	{
		*linkID = sourcelinkId;
	}		
	else
	{
		local_val = LR_FAILED;
	}
	
	rtlglue_drvMutexUnlock();/* Unlock resource */	
	return local_val;
	
	
}

int32 rtl8651_fwdEngineInput(void * pkthdr)
{
	struct rtl_pktHdr * pkthdrPtr = (struct rtl_pktHdr *)pkthdr;
	struct rtl_mBuf *mbufPtr;
	uint8 *m_data;
	int32 local_val;
	struct vlan_entry *ventry;

	rtlglue_drvMutexLock();	/* Lock resource */

	local_val= FAILED;
	ventry = lr_get_vlan_byidx(pkthdrPtr->ph_vlanIdx);
	mbufPtr = pkthdrPtr->ph_mbuf;
	m_data = mbufPtr->m_data;

	uint32 sourcelinkId = 0;	/* 0: default broadcast. */
	uint32 sourcememport = 0;
	uint32 sourceway = 0;
	lr_ext_fdb_lookup(ventry->fid,(ether_addr_t *)(m_data + 6),&sourcememport,&sourcelinkId,&sourceway,FDB_STATIC|FDB_DYNAMIC);

	if ((m_data[0] & 0x01) == 1)    /*multicast package*/
	{
		_rtl8651_fwdEngineExtDevBcast(	pkthdrPtr,
												ventry,
												(0xffff),
												sourcelinkId,
												pkthdrPtr->ph_priority,
												0);
	}
	else
	{
		uint32 linkId = 0;	/* 0: default broadcast. */
		uint32 memport;
		uint32 way;
		if (lr_ext_fdb_lookup(ventry->fid,(ether_addr_t *)m_data,&memport,&linkId,&way,FDB_STATIC|FDB_DYNAMIC) == LR_SUCCESS)
		{
			if (memport > (1 << (RTL8651_MAC_NUMBER -1)))
			{
				if (linkId > 0)
				{
					_rtl8651_fwdEngineHWExtDevUcast(pkthdrPtr, linkId);
				}
				else
					_rtl8651_fwdEngineExtDevBcast(	pkthdrPtr,
												ventry,
												(0xffff),
												sourcelinkId,
												pkthdrPtr->ph_priority,
												1);
			}			
		}
		else{
			/*unkonow unicast package*/
			_rtl8651_fwdEngineExtDevBcast(	pkthdrPtr,
												ventry,
												(0xffff),
												sourcelinkId,
												pkthdrPtr->ph_priority,
												1);
			}
		local_val = SUCCESS;
		goto out;
	}


out:
	rtlglue_drvMutexUnlock();/* Unlock resource */	
	return local_val;

}

int32 rtl8651_fwdEngineExtUnicat(void * pkthdr)
{
	struct rtl_pktHdr * pkthdrPtr = (struct rtl_pktHdr *)pkthdr;
	struct rtl_mBuf *mbufPtr;
	uint8 *m_data;
	int32 local_val;
	struct vlan_entry *ventry;


	rtlglue_drvMutexLock();	/* Lock resource */

	local_val= FAILED;
	ventry = lr_get_vlan_byidx(pkthdrPtr->ph_vlanIdx);
	mbufPtr = pkthdrPtr->ph_mbuf;
	m_data = mbufPtr->m_data;

	uint32 sourcelinkId = 0;	/* 0: default broadcast. */
	uint32 sourcememport = 0;
	uint32 sourceway = 0;
	lr_ext_fdb_lookup(ventry->fid,(ether_addr_t *)(m_data + 6),&sourcememport,&sourcelinkId,&sourceway,FDB_STATIC|FDB_DYNAMIC);

	uint32 linkId = 0;	/* 0: default broadcast. */
	uint32 memport;
	uint32 way;

	if (lr_ext_fdb_lookup(ventry->fid,(ether_addr_t *)m_data,&memport,&linkId,&way,FDB_STATIC|FDB_DYNAMIC) == LR_SUCCESS)
	{
		if (memport > (1 << (RTL8651_MAC_NUMBER -1)))
		{
			if (linkId > 0 && sourcelinkId != linkId)
			{
				_rtl8651_fwdEngineHWExtDevUcast(pkthdrPtr, linkId);
				local_val = SUCCESS;
				goto out;
			}
		}			
	}


out:
	rtlglue_drvMutexUnlock();/* Unlock resource */	
	return local_val;

}

__IRAM_EXTDEV static int32 _rtl8651_fwdEngineHWExtDevUcast(	struct rtl_pktHdr *pktHdr,
																	uint32 txLinkID)
{
	_rtl8651_extDevice_t *extDev;
	//rtlglue_printf("_rtl8651_fwdEngineHWExtDevUcast\n");

	if (	(txLinkID <= 0) ||
		(_RTL8651_EXTDEV_LINKID2IDX(txLinkID) >= _RTL8651_EXTDEV_DEVCOUNT))
	{

		mBuf_freeMbufChain(pktHdr->ph_mbuf);
		return FAILED;
	}

	/* get entry */
	extDev = &(rtl8651_extDevList[_RTL8651_EXTDEV_LINKID2IDX(txLinkID)]);

	if (extDev->extDevice == NULL)
	{
		mBuf_freeMbufChain(pktHdr->ph_mbuf);
		goto out;
	}


	rtlglue_extDeviceSend(pktHdr, extDev->extDevice);



out:
	return SUCCESS;
}

static int32 _rtl8651_fwdEngineExtDevBridge(	uint8 *data,
												struct rtl_pktHdr* pktHdr,
												uint32 linkID,
												struct vlan_entry *ventry)
{
	if (data[0] & 0x1)
	{
		/* L2 broadcast : to other Extension devices in same VLAN */

		if (ventry->valid)
		{
			uint8 priority = 0;
			if (VLAN_TAGGED(pktHdr->ph_mbuf->m_data))
			{
				priority = VLAN_PRIORITY(pktHdr->ph_mbuf->m_data);
			}
			_rtl8651_fwdEngineExtDevBcast(	pktHdr,
											ventry,
											0xffffffff,
											linkID,
											priority,
											FALSE);
		}

		/* pktHdr still exist : return 0 */
		return 0;

	} else if (memcmp(data, &(ventry->mac), sizeof(ether_addr_t)) != 0)
	{
		/* DMAC != Gateway MAC : L2 forwarding */

		/* unicast, DA lookup */
		uint32 memport;
		uint32 link_id;
		uint32 way;

		if (lr_ext_fdb_lookup(ventry->fid, (ether_addr_t*)data, &memport, &link_id,&way,FDB_DYNAMIC) == LR_SUCCESS)
		{
			if  (link_id > 0)
			{
				/* linkId>0 means DA is another WLAN station. */
				if (link_id == linkID)
				{	/* Source LinkID == Destination LinkID : filter it */
					mBuf_freeMbufChain(pktHdr->ph_mbuf);
					return 1;
				}


				_rtl8651_fwdEngineHWExtDevUcast(pktHdr, link_id);
				/* pktHdr sent : return 1 */
				return 1;
			}else
			{
				/* This host would at PHYSICAL port */
				assert((memport & peripheralExtPortMask) == 0);
			}
		}else
		{
			/*	It would be Unknown DMAC broadcast, we need to
				do VLAN broadcast for extension devices			*/

			uint8 priority = 0;

			if (VLAN_TAGGED(pktHdr->ph_mbuf->m_data))
			{
				priority = VLAN_PRIORITY(pktHdr->ph_mbuf->m_data);
			}
			_rtl8651_fwdEngineExtDevBcast(	pktHdr,
											ventry,
											0xffffffff,
											linkID,
											priority,
											FALSE);
		}
	}
	return 0;	/*pkt still needs to be sent to switch port */
}

static int32 _rtl8651_fwdEngineExtDevBcast(	struct rtl_pktHdr *pktHdr,
												struct vlan_entry *ventry,
												uint32 txPortFilterMask,
												uint32 incomingLinkID,
												uint8 priority,
												uint8 freeOrgPkt)
{
	_rtl8651_extDevice_t *extDev;

	uint32 memberPortMask = 0;
	uint32 txPortMask = 0;
	uint32 untagMemberPortMask = 0;
	int32 idx;
	uint16 vid;
	int32 pktIsTagged = FALSE, pktTagIsChecked = FALSE;
	
	/* get VLAN member Port */
	{
		if (ventry)
		{
			vid = ventry->vid;
			memberPortMask = ventry->mbr;
			untagMemberPortMask = ventry->untagSet;
		} else
		{
			/*
				ALL VLAN processes (checking / filtering / tag process) would be ignored.
			*/

			vid = 0;	/* Indicate that we would ignore VLAN checking */
			memberPortMask = 0xffffffff;
			untagMemberPortMask = VLAN_TAGGED(pktHdr->ph_mbuf->m_data)?0:0xffffffff;
		}
	}

	/* The actual tx-port is VLAN member port mask filtered by txPortFilterMask */
	txPortMask = memberPortMask & txPortFilterMask;

	if ( freeOrgPkt == TRUE )
	{
		struct rtl_mBuf *txMbuf;
		uint32 txCnt;

		/*
			Original Packet would be freed
		*/
		txCnt = 0;
		for ( idx = 0, extDev = &(rtl8651_extDevList[0]) ; idx < rtl8651_extDevCnt ; idx ++, extDev ++ )
		{

			/* TX extension device VLAN filtering */
#ifdef RTL865XB_DCUT_SWVLAN
			if (	(pktHdr->ph_property == PH_PROPER_DRVFWD) &&
				(pktHdr->ph_fwd_property & PH_FWD_PROPER_SWVLAN) )
			{
			} else
#endif /* RTL865XB_DCUT_SWVLAN */
			{
				if (	(vid > 0) &&
					(VLAN_MEMDEV_IDX_CHECK(idx, vid, rtl8651_vlanMemberDevMask) == 0))
				{
					continue;
				}
			}

			if (	(extDev->linkID != incomingLinkID) &&
				(extDev->portMask & txPortMask)	)
			{
				txCnt ++;
			}
		}
		/* STEP 2: actually TX to extension devices */
		if (txCnt == 0)
		{
			/* We have no any extension device to TX, so free original packet directly. */
			mBuf_freeMbufChain(pktHdr->ph_mbuf);
		} else
		{
			/* We have some extension devices to TX. */

			pktIsTagged = VLAN_TAGGED(pktHdr->ph_mbuf->m_data)?TRUE:FALSE;

			for ( idx = 0, extDev = &(rtl8651_extDevList[0]) ; ((txCnt > 0) && (idx < rtl8651_extDevCnt)) ; idx ++, extDev ++ )
			{

				/* TX extension device VLAN filtering */
#ifdef RTL865XB_DCUT_SWVLAN
				if (	(pktHdr->ph_property == PH_PROPER_DRVFWD) &&
					(pktHdr->ph_fwd_property & PH_FWD_PROPER_SWVLAN) )
				{
				} else
#endif /* RTL865XB_DCUT_SWVLAN */
				{
					if (	(vid > 0) &&
						(VLAN_MEMDEV_IDX_CHECK(idx, vid, rtl8651_vlanMemberDevMask) == 0))
					{
						continue;
					}
				}

				if (	(extDev->linkID != incomingLinkID) &&
					(extDev->portMask & txPortMask))
				{
					/* get packet to send */
					if (txCnt > 1)
					{
						txMbuf = mBuf_dupPacket(pktHdr->ph_mbuf, MBUF_DONTWAIT);
					} else
					{
						txMbuf = pktHdr->ph_mbuf;
					}

					/* TX to extension device */
					if ( txMbuf )
					{

						if (	(vid == 0	/* No vlan information : We ignore VLAN filtering and UNTAG set checking */) ||
							((pktIsTagged == FALSE) && (extDev->portMask & untagMemberPortMask)))
						{
							/* general case : don't do anything */
						} else
						{
							_rtl8651_fwdEngineVlanProcess(	pktIsTagged,
															((extDev->portMask & untagMemberPortMask) == 0),
															txMbuf->m_pkthdr,
															vid,
															priority);
						}

						/* the duplicated mbuf/packet would always be freed in the glue function */
						rtlglue_extDeviceSend(txMbuf->m_pkthdr, extDev->extDevice);

					}

					/* TX complete : decrease remaining TX count*/
					txCnt --;
				}
			}
		}
	} else
	{
		struct rtl_mBuf *newMbuf;

		/*
			Original Packet is keeped
		*/
		for ( idx = 0, extDev = &(rtl8651_extDevList[0]) ; idx < rtl8651_extDevCnt ; idx ++, extDev ++ )
		{
#if 0		
#if defined(RE865X_STP_BPDU_TXRX)
			if (extDev->portStat != RTL8651_PORTSTA_FORWARDING)  //not forwarding
			{
				continue;
			}
		
#endif
#endif
			/* TX extension device VLAN filtering */
#ifdef RTL865XB_DCUT_SWVLAN
			if (	(pktHdr->ph_property == PH_PROPER_DRVFWD) &&
				(pktHdr->ph_fwd_property & PH_FWD_PROPER_SWVLAN) )
			{
			} else
#endif /* RTL865XB_DCUT_SWVLAN */
			{
				if (	(vid > 0) &&
					(VLAN_MEMDEV_IDX_CHECK(idx, vid, rtl8651_vlanMemberDevMask) == 0))
				{
					continue;
				}
			}

			if (	(extDev->linkID != incomingLinkID) &&
				(extDev->portMask & txPortMask /* 1. extDev->portMask != 0, entry exist 2. txPortMask !=0, 3. need tx to this linkID */)	)
			{
				if (pktTagIsChecked == FALSE)
				{
					pktIsTagged = VLAN_TAGGED(pktHdr->ph_mbuf->m_data)?TRUE:FALSE;
				}

				newMbuf = mBuf_dupPacket(pktHdr->ph_mbuf, MBUF_DONTWAIT);

				if (newMbuf)
				{

					if (	(vid == 0	/* No vlan information : We ignore VLAN filtering and UNTAG set checking */) ||
						((pktIsTagged == FALSE) && (extDev->portMask & untagMemberPortMask)))
					{
						/* general case : don't do anything */
					} else
					{
						_rtl8651_fwdEngineVlanProcess(	pktIsTagged,
														((extDev->portMask & untagMemberPortMask) == 0),
														newMbuf->m_pkthdr,
														vid,
														priority);
					}

					/* the duplicated mbuf/packet would always be freed in the glue function */
					rtlglue_extDeviceSend(newMbuf->m_pkthdr, extDev->extDevice);


				}
			}
		}
	}

	return SUCCESS;
}

int32 rtl8651_fwdEngineOutput(void * pkthdr, uint32 vid)
{
	struct rtl_pktHdr * pkthdrPtr = (struct rtl_pktHdr *)pkthdr;
	struct rtl_mBuf *mbufPtr;
	uint8 *m_data;
	int32 local_val;
	struct vlan_entry *ventry;
	uint32 sourcememport,sourcelinkId,sourceway;

	rtlglue_drvMutexLock();	/* Lock resource */

	local_val= FAILED;
	ventry = lr_get_vlan(vid);
	mbufPtr = pkthdrPtr->ph_mbuf;
	m_data = mbufPtr->m_data;

	if (m_data[0] & 0x01) //multicast
	{
		_rtl8651_fwdEngineExtDevBcast(	pkthdrPtr,
												ventry,
												(0xffff),
												0,
												pkthdrPtr->ph_priority,
												0);
	}else
	{
		sourcememport = 0;
		sourcelinkId = 0;
		sourceway = 0;
		if (lr_ext_fdb_lookup(ventry->fid,(ether_addr_t *)m_data,&sourcememport,&sourcelinkId,&sourceway,FDB_STATIC|FDB_DYNAMIC)
			 == LR_SUCCESS)
		{
			if (sourcememport > (1 << (RTL8651_MAC_NUMBER -1)))
			{
				if (sourcelinkId > 0)
				{
					_rtl8651_fwdEngineHWExtDevUcast(pkthdrPtr, sourcelinkId);
					local_val = SUCCESS;
					goto out;
				}
				else {
					 	_rtl8651_fwdEngineExtDevBcast(	pkthdrPtr,
												ventry,
												(0xffff),
												0,
												pkthdrPtr->ph_priority,
												0);
					 }
				
			}
			
		}
		else{
			 _rtl8651_fwdEngineExtDevBcast(	pkthdrPtr,
												ventry,
												(0xffff),
												0,
												pkthdrPtr->ph_priority,
												0);
			 }
	}
	
out:

	rtlglue_drvMutexUnlock();/* Unlock resource */	
	return local_val;
	
}

int32 rtl865x_bridge_rxProcess(void *pkthdr)
{
	struct rtl_pktHdr * pkthdrPtr = (struct rtl_pktHdr *)pkthdr;
	uint32 rxPort = pkthdrPtr->ph_portlist;
	pkthdrPtr->ph_extPortList &= PKTHDR_EXTPORTMASK_ALL;	/* ignore TTL-1 bits. */
	if (rxPort >= 7)
	{
		if (pkthdrPtr->ph_extPortList == 0){
			return FAILED;
			}
		else if ((pkthdrPtr->ph_extPortList & PKTHDR_EXTPORTMASK_CPU) == 0){
			pkthdrPtr->ph_portlist = extPortMaskToPortNum[pkthdrPtr->ph_extPortList]+RTL8651_PORT_NUMBER-1;
			return FAILED;
			}
		else
			pkthdrPtr->ph_portlist = pkthdrPtr->ph_srcExtPortNum + RTL8651_PORT_NUMBER - 1;		
	}
	return SUCCESS;
	
}
#endif

/*
	Time-update function for L2 Forwarding Engine.
*/
void _rtl8651_layer2fwd_timeUpdate(void)
{
#ifdef _RTL8651_L2ENG_EXTDEV_MACLEARNING_CACHE
	/* Periodically flush SMAC learning cache */
	_rtl8651_extDevMacLearningCache_flush();
#endif
}


#ifdef _RTL8651_L2ENG_EXTDEV_MACLEARNING_CACHE

/*
@func void | rtl8651_timeUpdate | Timer for Table Drvier.
@parm uint32 | secPassed | How many seconds passed.
@comm
If table driver is used, this API should be called periodically. It will update some tables in the Table Driver.
*/
void rtl8651_LRtimeUpdate(uint32 dummy)
{
//	RTL_DEBUG(RTL_MSG_EXTDEV,"enter LR time update \n");
	_rtl8651_layer2fwd_timeUpdate();
	
}

#endif



