/////////////////////////////////////////////////////////////////
////
//// This file is to be included only by rtl8651_tblDrvLocal.h
//// This file exists only to split lengthy driver definitions to several organized header files
////
////  !!!Only  put Layer 4 driver specific 
////              1) local data types, 2) #define, and 3)macros 
////        in this file
////
//// Leave all "externs" and functions prototypes to rtl8651_tblDrvlocal.h 
//// If the API or datatype is to be exported outside the driver,
//// Please put it in rtl8651_layer2.h or rtl8651_tblDrv.h 
////
/////////////////////////////////////////////////////////////////

#ifdef RTL8651_TBLDRV_LOCAL_H   //can only be included by rtl8651_tblDrvLocal.h once
#ifndef RTL86561_LAYER4_LOCAL_H
#define RTL86561_LAYER4_LOCAL_H

/* collection of global macro definition */
#include "rtl8651_config.h"

//Forward declarations
struct ip;
struct rtl_pktHdr;


#define L4_N_LINK_TCP_DATA 2


typedef struct rtl8651_tblDrv_global_s {
	uint32 icmpTimeout;
	uint32 icmpFastTimeout;	/* chenyl: this is for Acked ICMP query. */
	uint32 udpTimeout;
	uint32 tcpLongTimeout;
	uint32 tcpMediumTimeout;
	uint32 tcpFastTimeout;
	uint32 tcpFinTimeout;  /* Louis note that it is for Hash2 double-FINed connections only. */
	uint32 triggerPortTimeout; /*hyking: Dasan need to control age timeout for trigger connection*/
	uint16 l4PortRangeStart, l4PortRangeEnd; /* unit: RTL8651_TCPUDPTBL_SIZE */
	uint16 l4NaptFindEmptyAsicRetry;	
} rtl8651_tblDrv_global_t;

typedef struct rtl8651_tblDrv_naptServerPortEntry_s {
	ipaddr_t localIp;
	ipaddr_t globalIp;
	uint16 localPort, globalPort;
	uint16 endLocalPort, endGlobalPort;
	uint32 asicTablePos;
	uint32 dsid;
	uint32 	tcp:1, //Entry for TCP server
			udp:1, //Entry for UDP server
			toAsic:1; //Entry configured to ASIC and asicTablePos is valid when toAsic==1
	SLIST_ENTRY(rtl8651_tblDrv_naptServerPortEntry_s) nextServerPort;
} rtl8651_tblDrv_naptServerPortEntry_t;

/* ALG callBack */
struct rtl8651_tblDrv_naptTcpUdpFlowEntry_s;
typedef int32 (*alg_funcptr_t)(	struct rtl_pktHdr *,
								struct ip*,
								struct rtl8651_tblDrv_naptTcpUdpFlowEntry_s *);

typedef struct rtl8651_tblDrv_algEntry_s {
	uint16 startPort, endPort;		/* range of layer 4 port number */
	uint16 isTcp:1, 				/* TCP or UDP based */
		   isClient:1,				/* support ALG client or not */
		   isServer:1,				/* support ALG server or not */
		   isNat:1,	       		/*support nat alg*/
		   isNapt:1,	       		/*support napt alg*/
		   isPortingBouncing:1, 	/*support port bouncing alg*/
		   toAsic:1,				/* be written to ASIC ALG table, or be merged into ACL table */
		   fwEngAdd:1,			/* added by the forwarding engine or not */
		   isDynamic:1;			/* dynamic or static */

	/* time to live (in second) */
	/* Note: this filed is valid until the "isDynamic" bit is set */
	int32 liveTime;
	
	/* callback functions dealing with inbound or outbound ALG operation  */
	alg_funcptr_t alg_outboundClientcb;
	alg_funcptr_t alg_outboundServercb;
	alg_funcptr_t alg_inboundClientcb;
 	alg_funcptr_t alg_inboundServercb;

	/* pointer to the companion which has the same port range but opposite TCP/UDP flag */
	struct rtl8651_tblDrv_algEntry_s *companion;
	
	SLIST_ENTRY(rtl8651_tblDrv_algEntry_s) nextAlgEntry;
} rtl8651_tblDrv_algEntry_t;


/* software use */
 /* used to save changes to ACK/sequence numbers */
struct l4ack_data_record				  
{
	uint32    ack_old;
	uint32    ack_new;
	int32     delta;
	int32     active;
};
#define L4_N_LINK_TCP_DATA 2

/* for hashing */
#define NAPT_HASH1  1		// Hash algorithm for index (5-tuple [Int,Rem])
#define NAPT_HASH2  2		// Hash algorithm for index (3-tuple [Int,   ])
#define NAPT_EHASH1  3		// Hash algorithm for index (5-tuple [Ext,Rem])

/* for connectionType */
#define	NAPT_TYPE_NORMAL      0  //This connection is a normal TCP/UDP conenction.
#define NAPT_TYPE_SERVERPORT  1  //This connection is for server port.
                                 //  Note that we don't monitor connection states (SYN/ACK/FIN)
#define NAPT_TYPE_ALG_CONNECTION 3  //This connection is ALG control channel.

typedef struct rtl8651_tblDrv_naptTcpUdpFlowEntry_s {
	ipaddr_t 	insideLocalIpAddr;	//Internal IP
	ipaddr_t 	insideGlobalIpAddr;//External IP
	ipaddr_t 	dstIpAddr;			//Destination IP
	uint16 	insideLocalPort;		//Internal port
	uint16 	insideGlobalPort;	//External port
	uint16 	dstPort;				//Destination port
		
	uint16	alive:1;			//If not alive, this entry has been timed-out. 
	uint16 	tcp:1;				//Connection is TCP
	uint16	hashing:2;			//Type of hashing algorithm used for outbound flow. (ie.NAPT_XXX_HASHING above)
	uint16	tcpFlag:3; 			//Connection's TCP state
	uint16	quiet:1;			//Don't send SYN/FIN/RST segments to software. supported by 8651B ASIC
	uint16	fromDrv:1;			//Whether this entry is generated by driver. Aging by driver (To asic as static)
	                            //Driver means: Forwarding engine. fromDrv==FALSE means from Protocol Stack.
	uint16	col1:1;				// Used only when reading directly from ASIC.
	uint16	col2:1;				// Used only when reading directly from ASIC.
	uint16	isStatic:1;			// Used only when reading directly from ASIC.
	uint16	asicSnapshot:1; 	//Entry is an ASIC snapshot. It really isn't in driver table.
	                            //TRUE means the content of this instance is mirrored from ASIC (maybe different to instance in driver table)
/* Louis commented asicAutoLearnt. It is no use anymore. */
//	uint16	asicAutoLearnt:1;	//Entry was auto learnt by ASIC. Set only by _rtl8651_getNaptEntry() when read directly from ASIC. Useless for software
	uint16	pureSoftware:1;		/* This connection is always handled by software, ex: policy route. NEVER swap to ASIC. */
	uint16	interfaceRoute:1;	/* This connection' dest is interface route, only inbound entry can be ASIC-accelerated. */
	uint16	newlyAddedHash2Udp:1;	/* This connection is newly-added HASH2 UDP, and should not be ASIC-accelerated until PPS>threshold. */
	uint16	holdForCdrouter:1;	/* This connection is newly-added, and we want it stay in software (for CDRouter) until PPS>threshold. */
#ifndef RTL865XB_URL_FILTER
	uint16 	urlFiltered:1;		//For TCP entries only. This flow has been filtered or not
#endif
	uint16	connectionType:2;	//The connection type, possible value:
	uint16	toProtocolStack:1;	/* This connection is for gw <---> remote public. We must trap all packets which match this entry */
	uint16	dosEnCount:1;		/* Check if this flow is conunted in DoS Connection count control system */
	uint16	dosFromInternal:1;	/* Check if this flow is from internal or external interface */

	//uint16	reserved:1;
	/* cchuang added, but Louis commented */
	//uint16	acl_flag:1;			//1: relative to ACL rule
	uint32 	age;				//lifetime remains. in uints of seconds.
	int16 	outboundTblIdx;		//entry index used for outbound flow
	int16   	inboundTblIdx;		//entry index used for inbound flow
	uint32	pps; 		//pkt rcvd per second
	uint16	createTimeStamp; 	//system uptime when connection created.
	uint8	outListType:4; 		//outbound list number, eg. NAPT_ASIC_CACHED,
	uint8	inListType:4;		//inbound list number, eg. NAPT_ASIC_CACHED,
	uint16	selEIdx;			//Nexthop Table Index (hash1)
	                			//inbouind flow (hash2)
	int8	inExtIpIdx;			/* HASH2 only: IP index for inbound entry */
	int8	outExtIpIdx;		/* HASH2 only: IP index for outbound entry */
	int8	offset;				/*Offset for L4 port translation*/

	/***********************************************************/
	uint8	tcpStateINdex:4; // tcp ack array index			
	uint8	tcpAckModified:1; // tcp ack number to modify
	uint8	tcpFtpLastLineCRLFTermed:1; // for ftp alg use
	uint8	natlink:1; // for nat link only
	uint8	h245tunnel:1; // for h225 link only
	uint8	portbouncingSrcFlow:1;	/* For Port Bouncing ALG -- source to extension device's flow */
	uint8	portbouncingDstFlow:1;	/* For Port Bouncing ALG -- extension device to destination's flow */

	/* ALG callBack functions binded with NAPT flow */
	alg_funcptr_t alg_client_in;
	alg_funcptr_t alg_client_out;
	alg_funcptr_t alg_server_in;
	alg_funcptr_t alg_server_out;

	 /* used to save changes to ACK/sequence numbers */
	struct l4ack_data_record ack[L4_N_LINK_TCP_DATA]; /* ack number */
	/***********************************************************/

	/*default redirect ACL rule information*/
	_rtl8651_tblDrvPolicy_t* defRedirAcl;
	
	/* Cache routing information */
	void			*out_rt_t; 
	void			*in_rt_t;
	void 		*out_macInfo_t;
	void 		*in_macInfo_t;
	uint8		dsid;
        uint8           unnumber;

#ifdef RTL865XB_WEB_CONTENT_HDR_FILTER
	uint32	expectWan2LanSeq;
	int32	httpContentType;
	SLIST_HEAD(, _rtl8651_tblDrv_contentFilter_s) contentFilterHead;
	SLIST_HEAD(, _rtl8651_tblDrv_httpHdrFilter_s) httpHdrFilterHead;
#endif
	
	SLIST_ENTRY(rtl8651_tblDrv_naptTcpUdpFlowEntry_s) nextSameAclEntry; //next entry which matchs the same default redirect ACL rule 
	
	//MUST be continuous 3 fields AND at the END of structure, _rtl8651_delNaptConnection() relies on this... 
	SLIST_ENTRY(rtl8651_tblDrv_naptTcpUdpFlowEntry_s)  nextOut;	//Next outbound entry in chain
	SLIST_ENTRY(rtl8651_tblDrv_naptTcpUdpFlowEntry_s)  nextIn;	//Next inbound entry in chain
	CTAILQ_ENTRY(rtl8651_tblDrv_naptTcpUdpFlowEntry_s)  next;   //link pointer to free list or inuselist
} rtl8651_tblDrv_naptTcpUdpFlowEntry_t;

#define NAPT_ASIC_CACHED_OUT	0	// asic cache 
#define NAPT_ASIC_CACHED_IN		1	// asic cache 

#define NAPT_ALG_OUT			2	// ALG outbound list
#define NAPT_ALG_IN				3	// ALG inbound list

#define NAPT_CANDIDATE_OUT      4	// Candidate Out
#define NAPT_CANDIDATE_IN       5	// Candidate In

#define NAPT_TOTAL_LISTS		8


// FIXME: should be faded out
// function name is changed
#define _rtl8651_addAlgCtrlConnection _rtl8651_addNaptAlgConnection 
#define _rtl8651_delAlgCtrlConnection _rtl8651_delNaptAlgConnection 
#define _rtl8651_getInboundAlgCtrlFlow _rtl8651_getInboundAlgConnection 
#define _rtl8651_getOutboundAlgCtrlFlow _rtl8651_getOutboundAlgConnection 

//cfliu: expand the SLIT_HEAD macro since source insight can't parse it. ugly, I know.
//SLIST_HEAD(naptEntryListHead, rtl8651_tblDrv_naptTcpUdpFlowEntry_s);
struct naptEntryListHead {
	struct rtl8651_tblDrv_naptTcpUdpFlowEntry_s *slh_first;	/* first element */	
};


typedef struct rtl8651DrvNaptLine_s {
	uint32 lastUsedOffset; /* The last used offset for this index line. unit: RTL8651_TCPUDPTBL_SIZE */
	struct naptEntryListHead list[NAPT_TOTAL_LISTS];
} rtl8651DrvNaptLine_t;  /*Each line is one-to-one mapping with an ASIC NAPT line*/

#if 0
typedef struct {
	uint16 outbound_conns; //number of table entries in 'list' which uses hetrogeneous ID selection algorithm
	uint16 inbound_refCnt; //number of inbound flows which relies on this icmp napt line's collision bit keep set.
	CTAILQ_HEAD(_IcmpNaptLine, rtl8651_tblDrv_naptTcpUdpFlowEntry_s) list; //List of driver table entries hashed on this icmp napt line
} rtl8651DrvIcmpNaptLine_t;  //Each line is one-to-one mapping with an ASIC ICMP NAPT line
#endif

typedef struct rtl8651_tblDrv_naptIcmpFlowEntry_s {
	ipaddr_t insideLocalIpAddr;
	ipaddr_t insideGlobalIpAddr;
	ipaddr_t dstIpAddr;
	uint16 insideLocalId;
	uint16 insideGlobalId;
	uint32 age;//Seconds as unit
	uint16 count;//Number of unanswered query using this translation entry
	//When canAsic is 0 (Unable to forward by ASIC), this index point to the entry position that fill collsion bit for 
	// backward traffic trap to CPU.
	uint32 	staticEntry:1,
			protoDel:1, //Whether protocol stack deletes this entry
			alive:1, //Whether entry alive or not
			toAsic:1,
			fromAsic:1,//Whether this entry is read from ASIC, means insideGlobalIpAddr, dstIpAddr and dstPort unknown
			fromDrv:1,//Whether this entry is generated by driver. Aging by driver (To asic as static)
			canAsic:1;//Whether this translation entry feasible to fill ASIC entry. If not, 

	/* cached informations */
	uint8 dsid;
	uint8 unnumber;
	//CTAILQ_ENTRY(rtl8651_tblDrv_naptTcpUdpFlowEntry_s)  nextEntry;  //link pointer to next entry on same hash line
	//CTAILQ_ENTRY(rtl8651_tblDrv_naptTcpUdpFlowEntry_s)  next;   //link pointer to free list or inuselist
	struct rtl8651_tblDrv_naptIcmpFlowEntry_s * next;
} rtl8651_tblDrv_naptIcmpFlowEntry_t;

typedef struct rtl8651_tblDrv_serverPortAsicArrangementEntry_s {
	uint16 valid:1;
	rtl8651_tblDrv_naptServerPortEntry_t *servPort_t;
} rtl8651_tblDrv_serverPortAsicArrangementEntry_t;

typedef struct rtl8651_tblDrv_algAsicArrangementEntry_s {
	uint16 port;
	uint16 valid:1;
} rtl8651_tblDrv_algAsicArrangementEntry_t;



#define _RTL8651_URLSTRBUFLEN 128

#define RTL865XB_URL_FILTER	/* For URL Filter function on 865xB (or later) platform : Need to be turned OFF on 865x platform */

/* for further 'per-packet' information filtering */
typedef struct urlPktFiltering_s {
	/* rule type of this filter entry */
	uint32 rule_type;

	/* filter for source IP address range */
	ipaddr_t	sip_start;
	ipaddr_t	sip_end;

	/* filter for source MAC address */
	ether_addr_t smac;

	/* data structure */
	SLIST_ENTRY(urlPktFiltering_s) nextUse;			/* used in urlfiltering linked list */
	SLIST_ENTRY(urlPktFiltering_s) next;			/* used in Inuse/free list*/
} urlPktFiltering_t;

#ifdef RTL865XB_WEB_CONTENT_HDR_FILTER
#define CONTENT_TYPE_UNKNOWN		0x0
#define CONTENT_TYPE_TEXT			0x1
#define CONTENT_TYPE_NONTEXT		0x2	/* This is different from "CONTENT_TYPE_UNKNOWN". We know this content type is not text! */

typedef struct _rtl8651_tblDrv_contentFilter_s {
	int32	partialTBLindex;
	int32	kmpIntState;	/* KMP intermediate state */
	SLIST_ENTRY(_rtl8651_tblDrv_contentFilter_s) nextContentFilter;
	SLIST_ENTRY(_rtl8651_tblDrv_contentFilter_s) next;	/* used in Inuse/free list*/
} _rtl8651_tblDrv_contentFilter_t;

typedef struct _rtl8651_tblDrv_httpHdrFilter_s {
	int32	partialTBLindex;
	int32	kmpIntState;	/* KMP intermediate state */
	SLIST_ENTRY(_rtl8651_tblDrv_httpHdrFilter_s) nextHttpHdrFilter;
	SLIST_ENTRY(_rtl8651_tblDrv_httpHdrFilter_s) next;	/* used in Inuse/free list*/
} _rtl8651_tblDrv_httpHdrFilter_t;

#endif


typedef void (*urlFiltering_CallBackFunc_t)(uint32 sessionId, struct rtl_pktHdr *pkt, struct ip *iphdr, const char *urlFiltered, const char *pathFiltered);	/* callBack function to process blocked-url request */

/* for pattern match filtering */
typedef struct urlFiltering_s {

	int32	urlFilterCount;
#ifdef RTL865XB_WEB_CONTENT_HDR_FILTER
	int32	contentFilterCount;			/* Because content filter process is different from url filter, create a new variable for recording content filter count seperately. */
	uint16	contentTypeJmpTbl[256];					/* Jump Table for string: "\r\nContent-Type: " */
	uint16	textTypeJmpTbl[256];					/* Jump Table for string: "text" */
	int32	httpHdrFilterCount;
#endif
	uint16 	urlHdrJmpTbl[256]; 						/* Jump Table for string: "\r\n\r\n" */
	uint16 	urlHostJmpTbl[256]; 						/* Jump Table for string: "\r\nHost: " */
	uint16	urlGetJmpTbl[256];						/* Jump Table for string: "GET \" */
	uint16	urlGet1JmpTbl[256];						/* Jump Table for string: "GET " */
	uint16	urlhttpJmpTbl[256];						/* Jump Table for string: "http://" */
	uint16	pathGetJmpTbl[256];						/* Jump Table for string: "GET /" */

	int8		**urlFilterDB;
	int8		**pathFilterDB;
#ifdef RTL865XB_WEB_CONTENT_HDR_FILTER
	int8		**contentFilterDB;
	int8		**httpHdrFilterDB;
#endif

	uint16	**urlFilterJmpTbl;
	uint16	**pathFilterJmpTbl;
	int32	*urlFilterStrLen;
	int32	*pathFilterStrLen;
#ifdef RTL865XB_WEB_CONTENT_HDR_FILTER
	int32	*contentFilterStrLen;
	int32	*httpHdrFilterStrLen;
#endif
	uint32	*sessionId;
	uint8	*urlExactlyMatch;
	uint8	*pathExactlyMatch;
	int8		urlString[_RTL8651_URLSTRBUFLEN];
#ifdef RTL865XB_URLFILTER_LOGMOREINFO
	int8		log_pathString[_RTL8651_URLSTRBUFLEN];
	int8		log_urlFilterString[_RTL8651_URLSTRBUFLEN];
	int8		log_pathFilterString[_RTL8651_URLSTRBUFLEN];
#endif

#ifdef RTL865XB_URLFILTER_UNKNOWNURLTYPE_SUPPORT
	uint8	*ruleType;
#endif
#ifdef RTL865XB_URLFILTER_ACTIONTYPE_SUPPORT
	uint8	*actionType;
#endif

	urlFiltering_CallBackFunc_t callBackFunc;	/* callBack function to process blocked-url request */

	SLIST_HEAD(, urlPktFiltering_s) pktFilter[256];
} urlFiltering_t;

/* idle timeout */
typedef struct _rtl8651_sessionHangUp_s {
	uint32 last_received;	/* last receiving time */
	uint32 last_transmit;	/* last transmission time */
	uint32 idletime_limit;	/* idle timeout */

	/*
		call-back function when timeout => if its NULL, it means this entry is empty:
	*/
	int32 (*p_callBack)(uint32);

	/*
		Record session ID for ALL kinds of interfaces:
		This is the internal control ID instead of actual ID gotten by PPP applications.
	*/
	uint32 sessionID;
	/* for PPP interfaces: PPPoE / PPTP / L2TP, point to its instance */
//	rtl8651_tblDrv_pppTable_t *ppp_t;
} _rtl8651_sessionHangUp_t;

/* =======================================================================
			Advance Routing : Policy / demand route
    ======================================================================= */ 
/* Advance routing type */
enum _rtl8651_advRtType_e
{
	RTL8651_ADVRT_TYPE_POLICYRT = 0x01,		/* policy route */
	RTL8651_ADVRT_TYPE_DEMANDRT,			/* demand route */
};

/* Advance routing process type */
enum _rtl8651_advRtProcType_e
{
	RTL8651_ADVRT_PROCTYPE_PKTINFO = 0x01,	/* process type is packet's info (ex. data path packet advance routing lookup) */
	RTL8651_ADVRT_PROCTYPE_CTRLINFO,		/* process type is control data structure info (ex. control path advance routing entry lookup/addition/deletion) */
};

/* for Policy route : RTL8651_ADVRT_TYPE_POLICYRT */
#define RTL8651_DPOLICYRT_EXT_AGE		3600	/* For External function call: age set to 3600 sec */
#define RTL8651_DPOLICYRT_INT_AGE		3		/* For Internal function call: age set to 3 sec */

#define RTL8651_POLICYRT_PORT_LBOUND_DEFAULT	32768	/* default lower bound for policy route forged port number */
#define RTL8651_POLICYRT_PORT_UBOUND_DEFAULT	65500	/* default upper bound for policy route forged port number */

#define RTL8651_POLICYRT_ID_LBOUND_DEFAULT		32768	/* default lower bound for policy route forged id number */
#define RTL8651_POLICYRT_ID_UBOUND_DEFAULT		65500	/* default upper bound for policy route forged id number */

#define RTL8651_POLICYRT_CACHESIZE				64		/* cache size of policy route: must be power of 2 (for hash) */
#define RTL8651_POLICYRT_CACHEAGE					5		/* cache age of policy route */

/* data structure */
typedef struct _rtl8651_tblDrvAdvRoute_s
{
	uint32 advRtType;

	/* Rule information */
	union
	{
		rtl8651_tblDrvPolicyRoute_t _policyRule;
		rtl8651_tblDrvDemandRoute_t _demandRule;
	} _un_rule;

	#define advRt_policyRule	_un_rule._policyRule
	#define advRt_demandRule _un_rule._demandRule

	/* Additional information for advance route */
	union
	{
		/* For policy route */
		struct
		{
			void *_rtEntry;				/* Corresponding Normal Host route entry */
			uint8 _rtGenByPolicyRt;		/* If this _rtEntry generated by Policy Route module */
			/*
				[ IP Address to add to Corresponding Normal Host route entry ]

				We record this because we can NOT trust entry of _rtEntry, it might be changed by other modules.
				And we just record it here instead of get it from advRt_policyRule because we would get this in
				data-path. So cache it here would speed up performance.
			*/
			ipaddr_t _rtIpAddr;
		} _policyRtInfo;
		/* For demand route */
		struct
		{
			uint8 _isActive;
		} _demandRtInfo;
	} _un_info;

	#define advRt_policy_rtEntry			_un_info._policyRtInfo._rtEntry
	#define advRt_policy_rtGenByPolicyRt	_un_info._policyRtInfo._rtGenByPolicyRt
	#define advRt_policy_rtIpAddr		_un_info._policyRtInfo._rtIpAddr
	#define advRt_demand_isActive		_un_info._demandRtInfo._isActive

	/* =========== for dynamic entry =========== */
	/*
		chenyl (2006/2/7):
			We use fullAge to record the full age time value because different entries have different ages in advance route
			usage.
	*/
	uint32 fullAge;	/* full age time for this dynamic advance route entry */
	uint32 age;		/* current age time for this dynamic advance route entry */

	uint16 aclProperty;		/*for default-redirect ACL rule*/

	/* =========== for data-structure maintenance =========== */
	SLIST_ENTRY(_rtl8651_tblDrvAdvRoute_s) next;			/* used in Inuse/free list */

} _rtl8651_tblDrvAdvRoute_t;
/*==============for aclProperty================*/
#define ASREDIRECTACL		0x0001	/*1: This advRt entry has been converted to default redirect ACL*/


typedef struct _rtl8651_tblDrvAdvRouteLookUpInfo_s
{
	ipaddr_t	srcIp;			/* source IP						--Always exist when lookup */
	ipaddr_t	dstIp;			/* destination IP					--Always exist when lookup */
	uint32	ipProto;			/* IP protocol						--Always exist when lookup */
	int32	srcPort;			/* source Port of TCP/UDP			--Exist only when TCP/UDP non-fragment-remaining packet (Or it would be -1) */
	int32	dstPort;			/* destination Port of TCP/UDP		--Exist only when TCP/UDP non-fragment-remaining packet (Or it would be -1) */
} _rtl8651_tblDrvAdvRouteLookUpInfo_t;

#define FIVE_ITEM_EASYHASH(item1,item2,item3,item4,item5,hashTblSize)		(((uint32)(item1) + (uint32)(item2) + (uint32)(item3) + (uint32)(item4) + (uint32)(item5)) & ((hashTblSize) - 1))

typedef struct _rtl8651_tblDrvPolicyRouteCache_s
{
	uint32 age;
	_rtl8651_tblDrvAdvRouteLookUpInfo_t lookupInfo;
	_rtl8651_tblDrvAdvRoute_t *advRt_p;
} _rtl8651_tblDrvPolicyRouteCache_t;

/* utility */
#define BOUND_INCREASE(number, addend, lowerBound, upperBound) \
	do {\
			(number) += (addend); \
			if ((number) > (upperBound)) \
			{ \
				(number) = (lowerBound); \
			} \
	} while(0);

/*
 * Macro defined for 4-way hash
 * For example:
 *   int orgi_idx, loop_idx, i;
 *
 *   orig_idx = HASH1( isTcp, IntIp, IntPort, ExtIp, ExtPort );
 *   for( i = 0; i < 4; i++ )
 *   {
 *       loop_idx = WRAPIN_4WAY( orig_idx, i );
 *
 *       ... blah blah, your code is here ...
 *   }
 *
 * Another example:
 *   int idx, i;
 *
 *   idx = HASH1( isTcp, IntIp, IntPort, ExtIp, ExtPort );
 *   for( i = 0; i < 4; i++ )
 *   {
 *       idx = WRAPIN_4WAY( idx, 1 );
 *
 *       ... blah blah, your code is here ...
 *   }
 *
 */
#define WRAPIN_4WAY( idx, inc ) ( (idx&~0x0003) | ((idx+inc)&0x0003) )


#endif /*RTL86561_LAYER4_LOCAL_H*/
#endif /*RTL8651_TBLDRV_LOCAL_H*/
