@echo off
REM
REM	mkimg.bat - batch file to integrate all binary files into a ap/gw image. 
REM	The generated image could be put into flash memory from the beginning.
REM

if %1!==! goto show_help
if "%1"=="gw" goto label_gw
if "%1"=="ap" goto label_ap
if "%1"=="ap-no" goto label_ap-no
if "%1"=="gw-no" goto label_gw-no
if "%1"=="8m" goto label_8m
if "%1"=="8m-no" goto label_8m-no
if "%1"=="pocket" goto label_pocket
if "%1"=="pocket-no" goto label_pocket-no

:show_help
echo.
echo %0 option. where "option" could be: 
echo    "gw"       (Gateway image)
echo    "gw-no"    (Gateway image without boot code and hw-setting)
echo    "8m"       (Gateway 8m image)
echo    "8m-no"    (Gateway 8m image without boot code and hw-setting)
echo    "ap"       (Gateway ap image)
echo    "ap-no"    (Gateway ap image without boot code and hw-setting)
echo    "pocket"       (Gateway pocket image)
echo    "pocket-no"    (Gateway pocket image without boot code and hw-setting)
goto success


:label_gw
set boot=..\..\image\boot.16m
set linux=..\..\image\linux-gw.bin
set root=..\..\image\root-gw.bin
set config=..\..\config\config-gw-96c.txt
set web_file=web-files-gw
set out_file=rtl8196c-gw.bin
set no_hw=
set cvcfg=cvcfg-gw
set platform=gw
goto process

:label_gw-no
set boot=
set linux=..\..\image\linux-gw.bin
set root=..\..\image\root-gw.bin
set config=..\..\config\config-gw-96c.txt
set web_file=web-files-gw
set out_file=rtl8196c-gw.bin
set no_hw=-no_hw
set cvcfg=cvcfg-gw
set platform=gw
goto process

:label_8m
set boot=..\..\image\boot.8m
set linux=..\..\image\linux-8m.bin
set root=..\..\image\root-8m.bin
set config=..\..\config\config-gw-96c.txt
set web_file=
set out_file=rtl8196c-8m.bin
set no_hw=
set cvcfg=cvcfg-gw
set platform=gw
goto process-8m

:label_8m-no
set boot=
set linux=..\..\image\linux-8m.bin
set root=..\..\image\root-8m.bin
set config=..\..\config\config-gw-96c.txt
set web_file=
set out_file=rtl8196c-8m.bin
set no_hw=-no_hw
set cvcfg=cvcfg-gw
set platform=gw
goto process-8m

:label_ap
set boot=..\..\image\boot.8m
set linux=..\..\image\linux-ap.bin
set root=..\..\image\root-ap.bin
set config=..\..\config\config-ap-96c.txt
set web_file=
set out_file=rtl8196c-ap-8m.bin
set no_hw=
set cvcfg=cvcfg-ap
set platform=ap
goto process-8m

:label_ap-no
set boot=
set linux=..\..\image\linux-ap.bin
set root=..\..\image\root-ap.bin
set config=..\..\config\config-ap-96c.txt
set web_file=
set out_file=rtl8196c-ap-8m.bin
set no_hw=-no_hw
set cvcfg=cvcfg-ap
set platform=ap
goto process-8m

:label_pocket
set boot=..\..\image\boot.16m
set linux=..\..\image\linux-pocket.bin
set root=..\..\image\root-pocket.bin
set config=..\..\config\config-gw-96c.txt
set web_file=web-files-gw
set out_file=rtl8196c-pocket.bin
set no_hw=
set cvcfg=cvcfg-gw
set platform=gw
goto process

:label_pocket-no
set boot=
set linux=..\..\image\linux-pocket.bin
set root=..\..\image\root-pocket.bin
set config=..\..\config\config-gw-96c.txt
set web_file=web-files-gw
set out_file=rtl8196c-pocket.bin
set no_hw=-no_hw
set cvcfg=cvcfg-gw
set platform=gw
goto process

:process
REM	Convert configuration data to binary
%cvcfg% -r %no_hw% %config% config.bin

REM	Compress web pages into binary
compweb %platform% %web_file% webpages.bin

REM Merge all binary files
mgbin -o %out_file% %boot% config.bin webpages.bin %linux% %root%
echo.
goto success

:process-8m
REM	Convert configuration data to binary
%cvcfg% -r %no_hw% %config% config.bin

REM Merge all binary files
mgbin -o %out_file% %boot% config.bin %linux% %root%
echo.
goto success

:success

:end