/* Shared library add-on to iptables to add MARK target support. */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>

#include <iptables.h>
//#include <linux/netfilter_ipv4/ip_tables.h>
/* For 64bit kernel / 32bit userspace */
//#include "../include/linux/netfilter_ipv4/ipt_SPAP.h"
//#include "ipt_SPAP.h"

#define SPAP_NUM 8

struct ipt_spap_target_info {
#ifdef KERNEL_64_USERSPACE_32
	unsigned long long mark;
#else
	unsigned long mark;
#endif
};

typedef struct info_que {
	unsigned long mark;
	unsigned long src_ip;
	unsigned short trig_port;
	struct info_que *next;	
} Info_Que;


/* Function which prints out usage message. */
static void
help(void)
{
	printf(
"SPAP target options:\n"
"--queue\n");
}
#if 1
static struct option opts[] = {
	{ "queue", 1, 0, '1' },
	{ 0 }
};
#endif
/* Initialize the target. */
static void
init(struct ipt_entry_target *t, unsigned int *nfcache)
{
}

static void
final_check(unsigned int flags)
{
	if (!flags)
		exit_error(PARAMETER_PROBLEM,
		           "SPAP target: --queue");
}

/* Function which parses command options; returns true if it
   ate an option */
static int
parse(int c, char **argv, int invert, unsigned int *flags,
	 const struct ipt_entry *entry,
	 struct ipt_entry_target **target)
{
	struct ipt_spap_target_info *spapinfo
		= (struct ipt_spap_target_info *)(*target)->data;
	
	*flags = 1;
	return 1;
}

/* Prints out the targinfo. */
static void
print(const struct ipt_ip *ip,
	 const struct ipt_entry_target *target,
	 int numeric)
{
	printf("SPAP target\n");
}

/* Saves the union ipt_targinfo in parsable form to stdout. */
static void
save(const struct ipt_ip *ip, const struct ipt_entry_target *target)
{
	printf("set SPAP\n");
}


static
struct iptables_target spap_target = {
	.next		= NULL,
	.name		= "SPAP",
	//.revision	= 0,
	.version	= NETFILTER_VERSION,//IPTABLES_VERSION,
	.size		= IPT_ALIGN(sizeof(struct ipt_spap_target_info)),
	.userspacesize	= IPT_ALIGN(sizeof(struct ipt_spap_target_info)),
	.help		= &help,
	.init		= &init,
	.parse		= &parse,
	.final_check	= &final_check,
	.print		= &print,
	.save		= &save,
	.extra_opts	= opts
};

void _init(void)
{
	register_target(&spap_target);
}
