/*
 * sync_list.c -- DHCP server client list sync with CSMAN config *
 * AMIT Apr 2008
 */
#ifndef	__SYNC_LIST_H__
#define	__SYNC_LIST_H__

#include <sys/socket.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <ctype.h>
#include <netdb.h>

#include <netinet/ether.h>
#include "static_leases.h"

#include "dhcpd.h"
#include "options.h"
#include "files.h"
#include "common.h"
#include "leases.h"

#include "csid/csid_dhcp.h"
#include "csman.h"


typedef struct client_list
{	
	unsigned char macaddr[16];
	unsigned int  yiaddr;	/* network order */
	unsigned int  expires;	/* host order */
}CLI_LIST_T;

int sync_list(void);


#endif//__SYNC_LIST_H__
