#include "sync_list.h"

int read_cs_list(void)
{
	int csman_fd;
	int clr_cnt=0;
	unsigned int cur_cli_cnt=0, max_cli_cnt=0;
	
	unsigned char macaddr[16],zero_mac[16];
	unsigned int ipaddr,expires;
	//dhcp client list status area
	unsigned int CSID_CLI_IP=CSID_S_DHCP_SVR_CLILIST_IP;
	unsigned int CSID_CLI_HOSTNAME=CSID_S_DHCP_SVR_CLILIST_HOSTNAME;
	unsigned int CSID_CLI_MAC=CSID_S_DHCP_SVR_CLILIST_MAC;
	unsigned int CSID_CLI_LEASETIME=CSID_S_DHCP_SVR_CLILIST_LEASETIME;
	//dhcp client list config area
	unsigned int CSID_CLI_MAXLEASE=CSID_C_DHCP_SVR_MAXLEASE;

	unsigned int i;

	csman_fd=open_csman(NULL, 0);
	if( csman_fd <0 ){
		perror("could not open Csman");
		return 0;	
	}

	read_csman(csman_fd, CSID_CLI_MAXLEASE, &max_cli_cnt, sizeof(unsigned int), CSM_R_ZERO);

	//LOG(LOG_INFO,"max_cli=%d\n",max_cli_cnt);
	
	for(i=0;i<max_cli_cnt;i++)
	{
		read_csman(csman_fd, CSID_CLI_IP+i, &ipaddr,sizeof(ipaddr), CSM_R_ZERO);
		if(ipaddr!=0)
		{	cur_cli_cnt++;	}
	}
	

	memset(zero_mac, 0x00, sizeof(zero_mac));
	for(i=0;i<cur_cli_cnt;i++)
	{
		//initial variable
		memset(macaddr, 0x00, sizeof(macaddr) );
		ipaddr = 0;
		//get data
		if(	(read_csman(csman_fd, CSID_CLI_MAC+i, macaddr, 6, 0) <0 ) && \
			(read_csman(csman_fd, CSID_CLI_IP+i,  &ipaddr, 4, 0) <0 ) )
		{	continue;	}	
	
		if((memcmp(zero_mac, macaddr, sizeof(zero_mac)) == 0)&&(ipaddr!=0)) 
		{
			clear_lease(macaddr,ipaddr);
			clr_cnt++;
			//LOG(LOG_INFO,"release ip=%x\n",ipaddr);
		}		
		else
		{
			//LOG(LOG_INFO,"mac=%02x:%02x:%02x:%02x:%02x:%02x,ip=%x\n",\
					macaddr[0],macaddr[1],macaddr[2],macaddr[3],macaddr[4],macaddr[5],\
					ipaddr);
		}
	}


	close_csman(csman_fd);
	return clr_cnt;
}


int sync_list(void)
{
	int clr_cnt;
	
	clr_cnt=read_cs_list();

	//LOG(LOG_INFO,"clr_cnt=%d\n",clr_cnt);
	return 0;
}
