/* vi: set sw=4 ts=4: */
/*
 * Licensed under the GPL v2 or later, see the file LICENSE in this tarball.
 */
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/wait.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <sys/socket.h>
#include <unistd.h>
#include <getopt.h>
#include <time.h>

#include "dhcpd.h"
#include "leases.h"
#include "libbb_udhcp.h"

#include "csid/csid_dhcp.h"
#include "csman.h"


#define REMAINING 0
#define ABSOLUTE 1


#ifndef IN_BUSYBOX
static void ATTRIBUTE_NORETURN show_usage(void)
{
	printf(
"Usage: dumpleases -f <file> -[r|a]\n\n"
"  -f, --file=FILENAME             Leases file to load\n"
"  -r, --remaining                 Interepret lease times as time remaing\n"
"  -a, --absolute                  Interepret lease times as expire time\n");
	exit(0);
}
#else
#define show_usage bb_show_usage
#endif


#ifdef IN_BUSYBOX
int dumpleases_main(int argc, char *argv[])
#else
int main(int argc, char *argv[])
#endif
{
	FILE *fp;
	int i, c, mode = REMAINING;
	long expires;
    long temp_expires;//horowitz added for initial csid
	const char *file = LEASES_FILE;
	struct dhcpOfferedAddr lease;
    struct dhcpOfferedAddr temp_lease;//horowitz added for initial csid
	struct in_addr addr;
	
	int csman_fd;
	unsigned int lease_cnt=0;
	unsigned char mac[256];
	
	unsigned int CSID_CLI_IP=CSID_S_DHCP_SVR_CLILIST_IP;
	unsigned int CSID_CLI_HOSTNAME=CSID_S_DHCP_SVR_CLILIST_HOSTNAME;
	unsigned int CSID_CLI_MAC=CSID_S_DHCP_SVR_CLILIST_MAC;
	unsigned int CSID_CLI_LEASETIME=CSID_S_DHCP_SVR_CLILIST_LEASETIME;

	static const struct option options[] = {
		{"absolute", 0, 0, 'a'},
		{"remaining", 0, 0, 'r'},
		{"file", 1, 0, 'f'},
		{0, 0, 0, 0}
	};

	while (1) {
		int option_index = 0;
		c = getopt_long(argc, argv, "arf:", options, &option_index);
		if (c == -1) break;

		switch (c) {
		case 'a': mode = ABSOLUTE; break;
		case 'r': mode = REMAINING; break;
		case 'f':
			file = optarg;
			break;
		default:
			show_usage();
		}
	}

	fp = xfopen(file, "r");

	csman_fd=open_csman(NULL, 0);
	if( csman_fd <0 ){
		perror("could not open Csman");
		return 0;	
	}



//***  initial(clear) all csid to zero  ***
        int j,k,count=0;
              for(j=1;j<= 255;j++){
                  for(k=0;k<6;k++){
                      temp_lease.chaddr[k]=0;
                  }
                  temp_lease.yiaddr=0;
                  strcpy(temp_lease.hostname,"");
                  temp_expires=0;
                  write_csman(csman_fd, (unsigned int)(CSID_CLI_MAC+j), (const void *)temp_lease.chaddr, 6, CSM_W_RMID);
                  write_csman(csman_fd, (unsigned int)(CSID_CLI_IP+j), (const void *)&temp_lease.yiaddr, 4, CSM_W_RMID);
                  write_csman(csman_fd, (unsigned int)(CSID_CLI_HOSTNAME+j), (const void *)temp_lease.hostname, strlen(temp_lease.hostname)+1, CSM_W_RMID);
                  write_csman(csman_fd, (unsigned int)(CSID_CLI_LEASETIME+j), (const void *)&temp_expires, sizeof(temp_expires), CSM_W_RMID);
                  count++;
                }
              printf("initial loops = %d \n",count);
//***  end initial/clear, horowitz added  ***

	printf("Mac Address       IP-Address      HOSTNAME    Expires %s\n", mode == REMAINING ? "in" : "at");  
	/*     "00:00:00:00:00:00 255.255.255.255 Wed Jun 30 21:49:08 1993" */
	lease_cnt=0;
	while (fread(&lease, sizeof(lease), 1, fp)) {
		for (i = 0; i < 6; i++) {
			printf("%02x", lease.chaddr[i]);
			if (i != 5) printf(":");
		}
		/* add by ahon */
		sprintf(mac,"%02x:%02x:%02x:%02x:%02x:%02x",lease.chaddr[0],lease.chaddr[1],lease.chaddr[2],lease.chaddr[3],lease.chaddr[4],lease.chaddr[5]);
		/* end */

		addr.s_addr = lease.yiaddr;
		printf(" %-15s", inet_ntoa(addr));
		printf(" %s", lease.hostname);		
		expires = ntohl(lease.expires);
		printf(" ");
		
		if( lease.hostname == NULL ) continue;
		
		if (mode == REMAINING) {
			if (!expires){ 
				printf("expired\n");
			 } 
      	else if(strcmp(mac,"00:00:00:00:00:00")) { // compare if mac is not zero, write to csid for UI show leases				
				write_csman(csman_fd, (unsigned int)(CSID_CLI_MAC+lease_cnt), (const void *)lease.chaddr, 6, 0);
				write_csman(csman_fd, (unsigned int)(CSID_CLI_IP+lease_cnt), (const void *)&addr, 4, 0);
				write_csman(csman_fd, (unsigned int)(CSID_CLI_HOSTNAME+lease_cnt), (const void *)lease.hostname, strlen(lease.hostname)+1, 0);
				write_csman(csman_fd, (unsigned int)(CSID_CLI_LEASETIME+lease_cnt), (const void *)&expires, sizeof(expires), 0);				 
						
				lease_cnt++;
				
				if (expires > 60*60*24) {
					printf("%ld days, ", expires / (60*60*24));
					expires %= 60*60*24;
				}
				if (expires > 60*60) {
					printf("%ld hours, ", expires / (60*60));
					expires %= 60*60;
				}
				if (expires > 60) {
					printf("%ld minutes, ", expires / 60);
					expires %= 60;
				}
				printf("%ld seconds\n", expires);
			}printf("\n");//for print each lease normally, when reget lease. see udhcpd-action lease.
		} else printf("%s", ctime(&expires));
	}

//***  write zero lease for record endless lease in CSID, thus UI can see where to end print leases  ***
	for(i=0;i<6;i++){
		lease.chaddr[i]=0;
	}
	addr.s_addr=0;
	strcpy(lease.hostname,"");
	expires=0;	
	
	write_csman(csman_fd, CSID_CLI_MAC+lease_cnt, (const void *)lease.chaddr, 6, 0);
	write_csman(csman_fd, CSID_CLI_IP+lease_cnt, (const void *)&addr, 4, 0);
	write_csman(csman_fd, CSID_CLI_HOSTNAME+lease_cnt, (const void *)lease.hostname, strlen(lease.hostname)+1, 0);
	write_csman(csman_fd, CSID_CLI_LEASETIME+lease_cnt, (const void *)&expires, sizeof(expires), 0);
	
    printf("lease count is %d now \n",lease_cnt);
//***  end write zero lease  ***
	
	close_csman(csman_fd);			
	
	fclose(fp);	
	return 0;
}
