/* Wireless Client list & Wired Client list */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "csman.h"
#include "csid/csid_wlanap.h"
#include "csid/csid_dhcp.h"

#define MAC_LEN			6
#define	ENTRY_NUM		256

unsigned char zmac[MAC_LEN]={0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
unsigned char fmac[MAC_LEN]={0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

/* 
 * Store the wlan client mac address.
 * Because wlan client would leave from AP, but be recognized of wired client.
 */
void add_one_wlan_mac (int csmfd, unsigned char *mac)
{
	int i;
	unsigned char gmac[MAC_LEN];

	// Insert to our defined CSID
	for (i=0; i<ENTRY_NUM; i++) {
		if(read_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+i), gmac, sizeof(gmac), CSM_R_ZERO) < 0)
			break;

		if (!memcmp(gmac, zmac, MAC_LEN)) {
			// zero mac, last one! add it!
			//printf("%s %d ---- insert[%d]: %02x:%02x:%02x:%02x:%02x:%02x\n", 
			//		__FILE__, __LINE__, i, mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]);
			write_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+i), mac, MAC_LEN, 0);
			
			// The last record is 00-00-00-00-00-00
			write_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+i+1), zmac, MAC_LEN, 0);
			break;
		} else if (!memcmp(mac, gmac, MAC_LEN)) {
			// Match! It's already in the csid, discard.
			//printf("%s %d ---- Match![%d] %02x:%02x:%02x:%02x:%02x:%02x\n", 
			//		__FILE__, __LINE__, i,gmac[0],gmac[1],gmac[2],gmac[3],gmac[4],gmac[5]);
			break;
		}
	}

	// Full!
	if (i == ENTRY_NUM) {
		// discard this one.
		return;
	}
}

/* 
	Get the whole wlan client mac from CSID_S_WLANAP_CLILIST_MAC 
	and write it into CSID_S_DHCP_SVR_CLILIST_WLAN.
*/
void merge_wlan_mac (int csmfd)
{
	int j;
	unsigned char wmac[MAC_LEN];

	/* add to CSID_S_DHCP_SVR_CLILIST_WLAN */
	for(j=0; j<ENTRY_NUM; j++) {
		if(read_csman(csmfd, CSID_S_WLANAP_CLILIST_MAC+j, wmac, sizeof(wmac), CSM_R_ZERO) < 0) {
			break;
		} 
		
		// zero mac, last one!
		if (!memcmp(wmac, zmac, MAC_LEN))
			break;

		add_one_wlan_mac (csmfd, wmac);
	}
}

/*
	Let
			MAC0 MAC1 FF:FF:FF:FF:FF:FF MAC2 MAC3
	bubble sort to
			MAC0 MAC1 MAC2 MAC3 FF:FF:FF:FF:FF:FF 00:00:00:00:00:00
									j-1					j
	delete j-1 and j items
			MAC0 MAC1 MAC2 MAC3

	i:smac
	0 1 2 3 4 5 ... ENTRY_NUM
		 i-->
		 |j-->
*/
void update_wlan_mac (int csmfd)
{
	int i, j;
	unsigned char smac[MAC_LEN], emac[MAC_LEN];

	for (i=0; i<ENTRY_NUM; i++) {
		if(read_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+i), smac, sizeof(smac), CSM_R_ZERO) >= 0) {
			if (!memcmp(smac, zmac, MAC_LEN)) {
				// zero mac, last one!
				break;
			} else if (!memcmp(smac, fmac, MAC_LEN)) {
				// FF:FF:FF:FF:FF:FF fmac, must shift the following items.
				for (j=(i+1); j<ENTRY_NUM; j++) {
					if(read_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+j), emac, sizeof(emac), CSM_R_ZERO) >= 0) {
					//printf("%s %d ----[%d] %02x:%02x:%02x:%02x:%02x:%02x\n", 
					//		__FILE__, __LINE__, j, emac[0],emac[1],emac[2],emac[3],emac[4],emac[5]);
						if (!memcmp(smac, zmac, MAC_LEN)) {
							// zero mac, last one! delete it!
							write_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+j), zmac, sizeof(zmac), CSM_W_RMID);
							// FF:FF:FF:FF:FF:FF is the last two.
							write_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+j-1), zmac, sizeof(zmac), CSM_W_RMID);
							break;
						}

						// move items
						write_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+j-1), emac, sizeof(emac), 0);
						write_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+j), fmac, sizeof(fmac), 0);
					} else {
						break;
					}
				} // for j
			}
		}
	} // for i
}

int main (void)
{
	unsigned int i, j=0, csmfd;
	unsigned char wired[MAC_LEN], wlan[MAC_LEN];
	int num=0;// num=0: wired, num=1: wireless

	/* get the latest wlan client mac, and store them in CSID_S_WLANAP_CLILIST_MAC. */
	system("wcli_list");	

	csmfd = open_csman(NULL,0);

	/* Add WLAN mac address to CSID_S_DHCP_SVR_CLILIST_WLAN. */
	merge_wlan_mac (csmfd);

	/* Set all dhcp clients to be wired, and check the wireless later. */
	num = 0; // wired
	for(i=0; i<ENTRY_NUM; i++) {
		if( read_csman(csmfd, CSID_S_DHCP_SVR_CLILIST_MAC+i, wired, sizeof(wired), CSM_R_ZERO) >= 0) {
			write_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_TYPE+i), &num, sizeof(num), 0);
		} else {
			break;
		}

		if (!memcmp(wired, zmac, MAC_LEN)) {
			//printf("%s %d ----[%d] %02x:%02x:%02x:%02x:%02x:%02x\n",
			//		__FILE__, __LINE__, i, zmac[0],zmac[1],zmac[2],zmac[3],zmac[4],zmac[5]);
			break;
		}
	}
	

	num = 1; // wireless
	for(i=0; i<ENTRY_NUM; i++) {
		if(read_csman(csmfd, CSID_S_DHCP_SVR_CLILIST_WLAN+i, wlan, sizeof(wlan), CSM_R_ZERO) < 0) {
			//printf("%s %d ---- [%d] %02x:%02x:%02x:%02x:%02x:%02x\n",
			//		__FILE__, __LINE__, i, wlan[0],wlan[1],wlan[2],wlan[3],wlan[4],wlan[5]);
			break;
		}

		// last one
		if (!memcmp(wlan, zmac, MAC_LEN)) {
			//printf("%s %d ---- [%d] last one\n", __FILE__, __LINE__, i);
			break;
		}

		//printf("%s %d ---- [%d] %02x:%02x:%02x:%02x:%02x:%02x\n", 
		//		__FILE__, __LINE__, i,wlan[0],wlan[1],wlan[2],wlan[3],wlan[4],wlan[5]);
		for (j=0; j<ENTRY_NUM; j++) {
			if(read_csman(csmfd, CSID_S_DHCP_SVR_CLILIST_MAC+j, wired, sizeof(wired), CSM_R_ZERO) < 0) {
				// Not found, means wlan client is disappear, delete it!
				// We set it to be FF:FF:FF:FF:FF:FF
				//printf("%s %d ---- delete: [%d] %02x:%02x:%02x:%02x:%02x:%02x\n", 
				//		__FILE__, __LINE__, j, wired[0],wired[1],wired[2],wired[3],wired[4],wired[5]);
				write_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_WLAN+i), fmac, sizeof(fmac), 0);
				break;
			}

			// last one
			if (!memcmp(wired, zmac, MAC_LEN)) {
				//printf("%s %d ---- [%d] last one\n", __FILE__, __LINE__, j);
				break;
			}

			if ( !memcmp(wlan, wired, MAC_LEN) ) {
				// Found it, it's wireless!
				//printf("%s %d ---- wlan: [%d] %02x:%02x:%02x:%02x:%02x:%02x\n", 
				//		__FILE__, __LINE__, j, wlan[0],wlan[1],wlan[2],wlan[3],wlan[4],wlan[5]);
				write_csman(csmfd, (CSID_S_DHCP_SVR_CLILIST_TYPE+j), &num, sizeof(num), 0);
				break;
			}
		}
	}

	/* Update our WLAN mac address structure. */
	/* Wuming , It shouldn't be happened */
	//update_wlan_mac (csmfd);

	close_csman(csmfd);
	return 0;
}

