/*
 * @file Member ID Definition of Group xDSL Router Function.
 *
 * Moderator: Eric Chen
 * Group ID: 0x00410000/0x80410000
 */

#ifndef _CSID_XDSL_H
#define _CSID_XDSL_H

#include "csid_gid.h"

#define _CFG_XDSL(x)        (CSID_GIDC_XDSL|(x))		//0x00410000
#define _STA_XDSL(x)        (CSID_GIDS_XDSL|(x))		//0x80410000


#define	ATM_QOS_UBR		0x0
#define ATM_QOS_CBR		0x1
#define ATM_QOS_VBR		0x2
#define ATM_QOS_GFR		0x3

#define	ATM_ENCAPSULATION_LLC	0x0
#define	ATM_ENCAPSULATION_VCMUX	0x1

#define T1_413			0x0
#define	G_LITE			0x1
#define	G_DMT			0x2
#define	ADSL2			0x3
#define	ADSL2PLUS		0x4
#define	MULTIMODE		0x5

#define	ANNEX_A			0x0
#define	ANNEX_I			0x1
#define	ANNEX_AL		0x2
#define	ANNEX_M			0x3
#define	ANNEX_AIJLM		0x4

/* Configuration Items */ 

#define CSID_C_XDSL_SUPPORT			_CFG_XDSL(0x0001)	//T=u32, D=0, xDSL modem support(default disable) 
#define CSID_C_XDSL_MODE			_CFG_XDSL(0x0002)	//T=u32, D=5, 0=T1.413,1=G.lite,2=G.dmt,3=ADSL,4=ADSL2+,5=Multimode
#define CSID_C_XDSL_TYPE			_CFG_XDSL(0x0003)	//T=u32, D=2, 0=A,1=I,2=A/L,3=M,4=A/I/J/L/M
#define CSID_C_XDSL_PASSWORD		_CFG_XDSL(0x0004)	//T=str, xDSL modem login password
#define CSID_C_XDSL_CPE_MACADDR		_CFG_XDSL(0x0005)	//T=mac, xDSL modem MAC address
#define CSID_C_XDSL_FW_VER			_CFG_XDSL(0x0006)	//T=str, xDSL FW version

/* PVC gap	*/
#define PVC_GAP	0x10
#define CSID_C_XDSL_PVC_BASE			_CFG_XDSL(0x0101)	
/* PVC0	*/
#define CSID_C_XDSL_PVC0_ACTIVE			_CFG_XDSL(0x0101)	//T=u8, D=1, 0:disable,1:enable
#define CSID_C_XDSL_PVC0_VPI			_CFG_XDSL(0x0102)	//T=u8, 0~255
#define CSID_C_XDSL_PVC0_VCI			_CFG_XDSL(0x0103)	//T=u16, 1~65535
#define CSID_C_XDSL_PVC0_ENCAPSULATION	_CFG_XDSL(0x0104)	//T=u8,	0=LLC,1=VC
#define CSID_C_XDSL_PVC0_ATM_QOSTYPE	_CFG_XDSL(0x0105)	//T=u8, D=0, 0=UBR, 1=CBR, 2=VBR, 3=GFR
#define CSID_C_XDSL_PVC0_ATM_QOS_PCR	_CFG_XDSL(0x0106)	//T=u8, D=0, 
#define CSID_C_XDSL_PVC0_ATM_QOS_SCR	_CFG_XDSL(0x0107)	//T=u8, D=0, 
#define CSID_C_XDSL_PVC0_ATM_QOS_MBS	_CFG_XDSL(0x0108)	//T=u8, D=0, 
/* PVC1	*/
#define CSID_C_XDSL_PVC1_ACTIVE			_CFG_XDSL(0x0111)	//T=u8, D=1, 0:disable,1:enable
#define CSID_C_XDSL_PVC1_VPI			_CFG_XDSL(0x0112)	//T=u8, 0~255
#define CSID_C_XDSL_PVC1_VCI			_CFG_XDSL(0x0113)	//T=u16, 1~65535
#define CSID_C_XDSL_PVC1_ENCAPSULATION	_CFG_XDSL(0x0114)	//T=u8,	0=LLC,1=VC
#define CSID_C_XDSL_PVC1_ATM_QOSTYPE	_CFG_XDSL(0x0115)	//T=u8, D=0, 0=UBR, 1=CBR, 2=VBR, 3=GFR
#define CSID_C_XDSL_PVC1_ATM_QOS_PCR	_CFG_XDSL(0x0116)	//T=u8, D=0, 
#define CSID_C_XDSL_PVC1_ATM_QOS_SCR	_CFG_XDSL(0x0117)	//T=u8, D=0, 
#define CSID_C_XDSL_PVC1_ATM_QOS_MBS	_CFG_XDSL(0x0118)	//T=u8, D=0, 


/* Status Items */

#define CSID_S_XDSL_ALTERED			_STA_XDSL(0x0001)	//T=u32, setting is altered

#define CSID_S_XDSL_LINESTATE		_STA_XDSL(0x0011)	//T=u8, 0=OFFLINE, 1:Wait for init, 2:Init, 3:ONLINE
#define CSID_S_XDSL_MODULATION		_STA_XDSL(0x0012)	//T=u8, 0=T1.413,1=G.lite,2=G.dmt,3=ADSL2,4=ADSL2+,5=Multimode
#define CSID_S_XDSL_SNR_UP			_STA_XDSL(0x0013)	//T=str, SNR up, if ADSL is down, value=N/A
#define CSID_S_XDSL_SNR_DOWN		_STA_XDSL(0x0014)	//T=str, SNR down, if ADSL is down, value=N/A
#define CSID_S_XDSL_ATTEN_UP		_STA_XDSL(0x0015)	//T=str, ATTEN up, if ADSL is down, value=N/A
#define CSID_S_XDSL_ATTEN_DOWN		_STA_XDSL(0x0016)	//T=str, ATTEN down, if ADSL is down, value=N/A
#define CSID_S_XDSL_DATARATE_UP		_STA_XDSL(0x0017)	//T=str, DATARATE up, if ADSL is down, value=N/A
#define CSID_S_XDSL_DATARATE_DOWN	_STA_XDSL(0x0018)	//T=str, DATARATE down, if ADSL is down, value=N/A
#define CSID_S_XDSL_PASSWORD		_STA_XDSL(0x0019)	//T=str, xDSL modem current password
#define CSID_S_XDSL_CPE_MACADDR		_STA_XDSL(0x001A)	//T=mac, xDSL modem MAC address
#define CSID_S_XDSL_FW_VER			_STA_XDSL(0x001B)	//T=str, xDSL FW version
#define CSID_S_XDSL_CUR_MODE_SETTING	_STA_XDSL(0x001C)	//T=u8, 0=T1.413,1=G.lite,2=G.dmt,3=ADSL2,4=ADSL2+,5=Multimode
#define CSID_S_XDSL_CUR_TYPE_SETTING	_STA_XDSL(0x001D)	//T=u8, 0=A,1=I,2=A/L,3=M,4=A/I/J/L/M

#define CSID_S_XDSL_PVC_LINK_STATUS		_STA_XDSL(0x0100)	//T=u8, PVC BASE index, 0=disconnect,1=connected
#define CSID_S_XDSL_PVC0_LINK_STATUS	_STA_XDSL(0x0100)	//T=u8, PVC0 link status, 0=disconnect,1=connected
#define CSID_S_XDSL_PVC1_LINK_STATUS	_STA_XDSL(0x0101)	//T=u8, PVC1 link status, 0=disconnnect,1=connected

#define CSID_S_XDSL_TX_FRAME		_STA_XDSL(0x0030)	//T=u32, TX traffic
#define CSID_S_XDSL_RX_FRAME		_STA_XDSL(0x0031)	//T=u32, RX traffic

#endif //ifndef _CSID_XDSL_H
