/*
 * @file Member ID Definition of Group Wireless APClient. 
 *
 *
 * Moderator: GeorgeWang
 * Group ID: 0x00320000/0x80320000
 */
 
#ifndef _CSID_WLANAPCLI_H
#define _CSID_WLANAPCLI_H

#include "csid_gid.h"

#define _CFG_WLANAPCLI(x)		(CSID_GIDC_WLANAPCLI|(x))
#define _STA_WLANAPCLI(x)		(CSID_GIDS_WLANAPCLI|(x))

#define WLANAPCLI_AUTH_OPEN			    	0
#define WLANAPCLI_AUTH_SHARED			    1
#define WLANAPCLI_AUTH_WEPAUTO				2
#define WLANAPCLI_AUTH_WPAPSK			    3
#define WLANAPCLI_AUTH_WPA		      		4
#define WLANAPCLI_AUTH_WPA2PSK				5
#define WLANAPCLI_AUTH_WPA2			    	6
#define WLANAPCLI_AUTH_WPAPSKWPA2PSK	    7
#define WLANAPCLI_AUTH_WPAWPA2				8

#define WLANAPCLI_ENCRYPT_NONE		    	0
#define WLANAPCLI_ENCRYPT_WEP		    	1
#define WLANAPCLI_ENCRYPT_TKIP		    	2
#define WLANAPCLI_ENCRYPT_AES		    	3
#define WLANAPCLI_ENCRYPT_TKIPAES	       	4

#define WLANAPCLI_WMODE_BG_MIXED	        0
#define WLANAPCLI_WMODE_B_ONLY		    	1
#define WLANAPCLI_WMODE_A_ONLY		    	2
#define WLANAPCLI_WMODE_G_ONLY		    	4
#define WLANAPCLI_WMODE_N_ONLY		    	6
#define WLANAPCLI_WMODE_GN_MIXED	        7
#define WLANAPCLI_WMODE_AN_MIXED	        8
#define WLANAPCLI_WMODE_BGN_MIXED	        9
#define WLANAPCLI_WMODE_UNKNOWN	        	10

#define WLANAPCLI_AREACODE_1_11	        	0
#define WLANAPCLI_AREACODE_1_13	        	1
#define WLANAPCLI_AREACODE_10_11	        2
#define WLANAPCLI_AREACODE_10_13	        3
#define WLANAPCLI_AREACODE_14             	4
#define WLANAPCLI_AREACODE_1_14	        	5
#define WLANAPCLI_AREACODE_3_9	        	6
#define WLANAPCLI_AREACODE_5_13	        	7

#define WLANAPCLI_KEYTYPE_HEX	        	0
#define WLANAPCLI_KEYTYPE_ASCII	        	1

#define WLANAPCLI_POWERSAVE_DISABLE       	0
#define WLANAPCLI_POWERSAVE_NORMAL        	1
#define WLANAPCLI_POWERSAVE_MAX           	2

#define WLANAPCLI_STATUS_DISCONNECT       	0
#define WLANAPCLI_STATUS_CONNECT	        1

#define WLANAPCLI_WPS_MODE_PIN     			1
#define WLANAPCLI_WPS_MODE_PBC     			2

/* Configuration Items */

#define CSID_C_WLANAPCLI_ENABLE				_CFG_WLANAPCLI(0x0001)	//T=u8, D=1, Enable/Disable wireless client function
#define CSID_C_WLANAPCLI_CHANNEL			_CFG_WLANAPCLI(0x0002)	//T=u8, D=6, channel
#define CSID_C_WLANAPCLI_AREACODE			_CFG_WLANAPCLI(0x0003)	//T=u8,	D=5, ,area code, Ex: 0:ch 1-11, 1:ch 1-13, Refer to Ralink  
#define CSID_C_WLANAPCLI_SSID				_CFG_WLANAPCLI(0x0004)	//T=str, D="default", ssid
#define CSID_C_WLANAPCLI_TXRATE				_CFG_WLANAPCLI(0x0005)	//T=u16, TX rate
#define CSID_C_WLANAPCLI_FRAGTHRESHOLD    	_CFG_WLANAPCLI(0x0006)	//T=u16, D=2346, Fragmentation Threshold
#define CSID_C_WLANAPCLI_RTSCTSTHRESHOLD  	_CFG_WLANAPCLI(0x0007)	//T=u16, D=2347, CTS/RTS Threshold
#define CSID_C_WLANAPCLI_WIRLESSMODE  		_CFG_WLANAPCLI(0x0008)	//T=u8, D=9, wireless mode
#define CSID_C_WLANAPCLI_POWERSAVE      	_CFG_WLANAPCLI(0x0009)	//T=u8, power save mode
#define CSID_C_WLANAPCLI_BGPROTECT    		_CFG_WLANAPCLI(0x000a)	//T=u8, D=0, B/G protection
#define CSID_C_WLANAPCLI_TXBURST    		_CFG_WLANAPCLI(0x000b)	//T=u8, D=1, tx burst
#define CSID_C_WLANAPCLI_PKTAGGREGATE 		_CFG_WLANAPCLI(0x000c)	//T=u8, D=1, PktAggregate capable
#define CSID_C_WLANAPCLI_AUTHMODE   		_CFG_WLANAPCLI(0x000d)	//T=u8, authentication type
#define CSID_C_WLANAPCLI_ENCRYPTYPE   		_CFG_WLANAPCLI(0x000e)	//T=u8, Encryp Type
#define CSID_C_WLANAPCLI_IEEE8021X   		_CFG_WLANAPCLI(0x000f)	//T=u8, enable/disable 802_1x
#define CSID_C_WLANAPCLI_DEFKEYID   		_CFG_WLANAPCLI(0x0010)	//T=u8, D=1, default wep key id
#define CSID_C_WLANAPCLI_KEY0TYPE   		_CFG_WLANAPCLI(0x0011)	//T=u8, D=0, wep key 0 type
#define CSID_C_WLANAPCLI_KEY0		   		_CFG_WLANAPCLI(0x0012)	//T=str, wep key 0 value
#define CSID_C_WLANAPCLI_KEY1TYPE   		_CFG_WLANAPCLI(0x0013)	//T=u8, D=0, wep key 1 type
#define CSID_C_WLANAPCLI_KEY1				_CFG_WLANAPCLI(0x0014)	//T=str, wep key 1 value
#define CSID_C_WLANAPCLI_KEY2TYPE   		_CFG_WLANAPCLI(0x0015)	//T=u8, D=0, wep key 2 type
#define CSID_C_WLANAPCLI_KEY2	 			_CFG_WLANAPCLI(0x0016)	//T=str, wep key 2 value
#define CSID_C_WLANAPCLI_KEY3TYPE   		_CFG_WLANAPCLI(0x0017)	//T=u8, D=0, wep key 3 type
#define CSID_C_WLANAPCLI_KEY3	  			_CFG_WLANAPCLI(0x0018)	//T=str, wep key 3 value
#define CSID_C_WLANAPCLI_WPAPSK	   			_CFG_WLANAPCLI(0x0019)	//T=str, wpa psk value
#define CSID_C_WLANAPCLI_WMM_ENABLE   	 	_CFG_WLANAPCLI(0x001a)	//T=u32, Wmm enable/disable

/* WPS Client */
#define CSID_C_WLANAPCLI_WPS_ENABLE        	_CFG_WLANAPCLI(0xa000) //T=u8, D=0, enable/disable wps function
#define CSID_C_WLANAPCLI_WPS_CONFSTATUS    	_CFG_WLANAPCLI(0xa100) //T=u8, D=1, Set WPS Client Simple Config State,  Un-Configured/Configured
#define CSID_C_WLANAPCLI_WPS_MODE          	_CFG_WLANAPCLI(0xa200) //T=u8, D=1, configured metheds, PIN/PBC
#define CSID_C_WLANAPCLI_WPS_TRIGGER        _CFG_WLANAPCLI(0xa300) //T=u8, WPS, Trigger Client to do simple config.
#define CSID_C_WLANAPCLI_WPS_STATUS         _CFG_WLANAPCLI(0xa301) //T=u8, D=0 ,WPS configured status

/* Sacn AP */
#define CSID_S_WLANAPCLI_AP_SSID			_STA_WLANAPCLI(0x1000) //T=str, Scan AP SSID
#define CSID_S_WLANAPCLI_AP_ENCRYP			_STA_WLANAPCLI(0x2000) //T=u8, AP Encryption type
#define CSID_S_WLANAPCLI_AP_QUALITY			_STA_WLANAPCLI(0x3000) //T=str, AP QUALITY
#define CSID_S_WLANAPCLI_AP_AUTHMODE		_STA_WLANAPCLI(0x4000) //T=u8, AP authentication type
#define CSID_S_WLANAPCLI_AP_MAC                   _STA_WLANAPCLI(0x5000) //T=str, Scan AP MAC Address
#define CSID_S_WLANAPCLI_AP_CHANNEL               _STA_WLANAPCLI(0x6000) //T=str, Scan AP Channel
#define CSID_S_WLANAPCLI_AP_EXTCHANNEL               _STA_WLANAPCLI(0x7000) //T=str, Scan AP Extension Channel
#define CSID_S_WLANAPCLI_AP_WIRELESSMODE  		_STA_WLANAPCLI(0x8000)	//T=str, Scan AP wireless mode

/* Status Items */

#define CSID_S_WLANAPCLI_ALTERED			_STA_WLANAPCLI(0x0002) //T=u8, ui altered
#define CSID_S_WLANAPCLI_STATUS				_STA_WLANAPCLI(0x0003) //T=u8, connect status
#define CSID_S_WLANAPCLI_WPS_ALTERED      	_STA_WLANAPCLI(0x0004) //T=u8, WPS, ui altered
#define CSID_S_WLANAPCLI_AUTHMODE               _STA_WLANAPCLI(0x0005)  //T=str, authentication type
#define CSID_S_WLANAPCLI_ENCRYPTYPE             _STA_WLANAPCLI(0x0006)  //T=str, Encryp Type
#define CSID_S_WLANAPCLI_DEFKEYID               _STA_WLANAPCLI(0x0007)  //T=str, D=1, default wep key id
#define CSID_S_WLANAPCLI_KEY0TYPE               _STA_WLANAPCLI(0x0008)  //T=str, D=0, wep key 0 type
#define CSID_S_WLANAPCLI_KEY1TYPE               _STA_WLANAPCLI(0x0009)  //T=str, D=0, wep key 1 type
#define CSID_S_WLANAPCLI_KEY2TYPE               _STA_WLANAPCLI(0x000a)  //T=str, D=0, wep key 2 type
#define CSID_S_WLANAPCLI_KEY3TYPE               _STA_WLANAPCLI(0x000b)  //T=str, D=0, wep key 3 type

#endif
