/*
 * @file Member ID Definition of Group Wireless AP. 
 *
 * Moderator: GeorgeWang
 * Group ID: 0x00190000/0x80190000
 */
 
#ifndef _CSID_WLANAP_H
#define _CSID_WLANAP_H

#include "csid_gid.h"

#define _CFG_WLANAP(x)		(CSID_GIDC_WLANAP|(x))
#define _STA_WLANAP(x)		(CSID_GIDS_WLANAP|(x))

#define WLANAP_AUTH_OPEN			0
#define WLANAP_AUTH_SHARED			1
#define WLANAP_AUTH_WEPAUTO			2
#define WLANAP_AUTH_WPAPSK			3
#define WLANAP_AUTH_WPA				4
#define WLANAP_AUTH_WPA2PSK			5
#define WLANAP_AUTH_WPA2			6
#define WLANAP_AUTH_WPAPSKWPA2PSK	        7
#define WLANAP_AUTH_WPAWPA2			8

#define WLANAP_ENCRYPT_NONE		0
#define WLANAP_ENCRYPT_WEP		1
#define WLANAP_ENCRYPT_TKIP		2
#define WLANAP_ENCRYPT_AES		3
#define WLANAP_ENCRYPT_TKIPAES	        4

#define WLANAP_WMODE_BG_MIXED	        0
#define WLANAP_WMODE_B_ONLY		1
#define WLANAP_WMODE_A_ONLY		2
#define WLANAP_WMODE_G_ONLY		4
#define WLANAP_WMODE_N_ONLY		6
#define WLANAP_WMODE_GN_MIXED	        7
#define WLANAP_WMODE_AN_MIXED	        8
#define WLANAP_WMODE_BGN_MIXED	        9
#define WLANAP_WMODE_UNKNOWN	        10

#define WLANAP_AREACODE_1_11		0
#define WLANAP_AREACODE_1_13		1
#define WLANAP_AREACODE_10_11		2
#define WLANAP_AREACODE_10_13		3
#define WLANAP_AREACODE_14		4
#define WLANAP_AREACODE_1_14		5
#define WLANAP_AREACODE_3_9		6
#define WLANAP_AREACODE_5_13		7

#define WLANAP_KEYTYPE_HEX		0
#define WLANAP_KEYTYPE_ASCII		1

#define WLANAP_WPS_CONFMODE_DISABLE     0 
#define WLANAP_WPS_CONFMODE_ENROLEE     1
#define WLANAP_WPS_CONFMODE_PROXY       2
#define WLANAP_WPS_CONFMODE_REGISTRAR   4

#define WLANAP_WPS_CONFSTATUS_UNCONFIGURED 1
#define WLANAP_WPS_CONFSTATUS_CONFIGURED 2

#define WLANAP_WPS_MODE_PIN		1
#define WLANAP_WPS_MODE_PBC		2	

#define WLANAP_WPS_STATUS_NOUSED	0
#define WLANAP_WPS_STATUS_IDLE		1
#define WLANAP_WPS_STATUS_PROCESSFAIL 2
#define WLANAP_WPS_STATUS_STARTPROCESS 3
#define WLANAP_WPS_STATUS_RECVEAPOLSTART 4
#define WLANAP_WPS_STATUS_SENDEAPREQID 5
#define WLANAP_WPS_STATUS_RECVEAPRSPID 6
#define WLANAP_WPS_STATUS_RECVWRGVENDORID 7
#define WLANAP_WPS_STATUS_RECVWRGVENDORTYPE 8
#define WLANAP_WPS_STATUS_SENDEAPREQSTART 9
#define WLANAP_WPS_STATUS_SENDM1 10
#define WLANAP_WPS_STATUS_RECVM1 11
#define WLANAP_WPS_STATUS_SENDM2 12
#define WLANAP_WPS_STATUS_RECVM2 13
#define WLANAP_WPS_STATUS_RECVM2D 14
#define WLANAP_WPS_STATUS_SENDM3 15
#define WLANAP_WPS_STATUS_RECVM3 16
#define WLANAP_WPS_STATUS_SENDM4 17
#define WLANAP_WPS_STATUS_RECVM4 18
#define WLANAP_WPS_STATUS_SENDM5 19
#define WLANAP_WPS_STATUS_RECVM5 20
#define WLANAP_WPS_STATUS_SENDM6 21
#define WLANAP_WPS_STATUS_RECVM6 22
#define WLANAP_WPS_STATUS_SENDM7 23
#define WLANAP_WPS_STATUS_RECVM7 24
#define WLANAP_WPS_STATUS_SENDM8 25
#define WLANAP_WPS_STATUS_RECVM8 26
#define WLANAP_WPS_STATUS_PROCEAPRSPACK 27
#define WLANAP_WPS_STATUS_PROCEAPREQDONE 28
#define WLANAP_WPS_STATUS_PROCEAPRSPDONE 29
#define WLANAP_WPS_STATUS_SENDEAPFAIL 30
#define WLANAP_WPS_STATUS_ERRHASHFAIL 31
#define WLANAP_WPS_STATUS_ERRHMACFAIL 32
#define WLANAP_WPS_STATUS_ERRDEVPWDAUTHFAIL 33
#define WLANAP_WPS_STATUS_CONFIGURED 34

#define WLANAP_ATE_CMODE_NORMAL 0
#define WLANAP_ATE_CMODE_CONTTX 1
#define WLANAP_ATE_CMODE_CONTRX 2
#define WLANAP_ATE_CMODE_TXCARRIER 3

#define WLANAP_ATE_WMODE_B_ONLY		0
#define WLANAP_ATE_WMODE_G_ONLY		1
#define WLANAP_ATE_WMODE_BGN_MIXED	        2
#define WLANAP_ATE_WMODE_N_ONLY		3

#define WLANAP_ATE_DATERATE_1M 0
#define WLANAP_ATE_DATERATE_2M 1
#define WLANAP_ATE_DATERATE_55M 2
#define WLANAP_ATE_DATERATE_11M 3
#define WLANAP_ATE_DATERATE_6M 4
#define WLANAP_ATE_DATERATE_9M 5
#define WLANAP_ATE_DATERATE_12M 6
#define WLANAP_ATE_DATERATE_18M 7
#define WLANAP_ATE_DATERATE_24M 8
#define WLANAP_ATE_DATERATE_36M 9
#define WLANAP_ATE_DATERATE_48M 10
#define WLANAP_ATE_DATERATE_54M 11
#define WLANAP_ATE_DATERATE_MCS0 12
#define WLANAP_ATE_DATERATE_MCS1 13
#define WLANAP_ATE_DATERATE_MCS2 14
#define WLANAP_ATE_DATERATE_MCS3 15
#define WLANAP_ATE_DATERATE_MCS4 16
#define WLANAP_ATE_DATERATE_MCS5 17
#define WLANAP_ATE_DATERATE_MCS6 18
#define WLANAP_ATE_DATERATE_MCS7 19
#define WLANAP_ATE_DATERATE_MCS8 20
#define WLANAP_ATE_DATERATE_MCS9 21
#define WLANAP_ATE_DATERATE_MCS10 22
#define WLANAP_ATE_DATERATE_MCS11 23
#define WLANAP_ATE_DATERATE_MCS12 24 
#define WLANAP_ATE_DATERATE_MCS13 25
#define WLANAP_ATE_DATERATE_MCS14 26
#define WLANAP_ATE_DATERATE_MCS15 27

#define WLANAP_ATE_BW20 0
#define WLANAP_ATE_BW40 1

#define WLANAP_PSMODE_DO_NOTHING	0
#define WLANAP_PSMODE_AUTO			1		// power adator in ? high : low
#define WLANAP_PSMODE_HIGH			2		// High Power
#define WLANAP_PSMODE_LOW			3		// Low Power

/* Configuration Items */

#define CSID_C_WLANAP_ENABLE			_CFG_WLANAP(0x0001)	//T=u8, D=1, Enable/Disable wireless function
#define CSID_C_WLANAP_BSSIDNUM			_CFG_WLANAP(0x0002)	//T=u8, D=1, Number of BSSID
#define CSID_C_APSWITCH_ENABLE			_CFG_WLANAP(0x0003) //T=u8, apswitch enable.
#define CSID_C_WLANAP_PSMODE			_CFG_WLANAP(0x0004) //T=u32, D=0, WLANAP Power Saving Mode,

/*Basic Setting */
//define total 256 Multiple AP id
#define CSID_C_WLANAP_APID_ENABLE		_CFG_WLANAP(0x0100)	//T=u8, D=1, Enable/Disable a specific AP in Multi-BSSID function.
#define CSID_C_WLANAP_CHANNEL			_CFG_WLANAP(0x0200)	//T=u8, D=6, channel
#define CSID_C_WLANAP_AREACODE			_CFG_WLANAP(0x0300)	//T=u8,	D=5, ,area code, Ex: 0:ch 1-11, 1:ch 1-13, Refer to Ralink  
#define CSID_C_WLANAP_SSID			_CFG_WLANAP(0x0400)	//T=str, D="default", ssid
#define CSID_C_WLANAP_BASICRATE			_CFG_WLANAP(0x0500)	//T=u16, D=15, basic rate
#define CSID_C_WLANAP_SUPPORTRATE		_CFG_WLANAP(0x0600)	//T=u16, D=0xFFF, support rate
#define CSID_C_WLANAP_FRAGTHRESHOLD		_CFG_WLANAP(0x0700)	//T=u16, D=2346, Fragmentation Threshold
#define CSID_C_WLANAP_RTSCTSTHRESHOLD   	_CFG_WLANAP(0x0800)	//T=u16, D=2347, CTS/RTS Threshold
#define CSID_C_WLANAP_BEACONINTERVAL		_CFG_WLANAP(0x0900)	//T=u16, D=100, beacon interval
#define CSID_C_WLANAP_DTIMINTERVAL  		_CFG_WLANAP(0x0a00)	//T=u16, D=1, DTIM interval
#define CSID_C_WLANAP_TXPREAMPLE  		_CFG_WLANAP(0x0b00)	//T=u8, D=0, tx preamble 
#define CSID_C_WLANAP_WIRLESSMODE  		_CFG_WLANAP(0x0c00)	//T=u8, D=9, wireless mode
#define CSID_C_WLANAP_TXPOWER      		_CFG_WLANAP(0x0d00)	//T=u8, D=100, tx power level
#define CSID_C_WLANAP_HIDESSID     		_CFG_WLANAP(0x0e00)	//T=u8, D=0, hiden ssid
#define CSID_C_WLANAP_BGPROTECT    		_CFG_WLANAP(0x0f00)	//T=u8, D=0, B/G protection
#define CSID_C_WLANAP_SHORTSLOT    		_CFG_WLANAP(0x1000)	//T=u8, D=1, short slot
#define CSID_C_WLANAP_TXBURST    		_CFG_WLANAP(0x1100)	//T=u8, D=1, tx burst
#define CSID_C_WLANAP_PKTAGGREGATE 		_CFG_WLANAP(0x1200)	//T=u8, D=1, PktAggregate capable
#define CSID_C_WLANAP_AUTHMODE   		_CFG_WLANAP(0x1300)	//T=u8, D=0, authentication type
#define CSID_C_WLANAP_ENCRYPTYPE   		_CFG_WLANAP(0x1400)	//T=u8, D=0, Encryp Type
#define CSID_C_WLANAP_IEEE8021X   		_CFG_WLANAP(0x1500)	//T=u8, D=0, enable/disable 802_1x
#define CSID_C_WLANAP_DEFKEYID   		_CFG_WLANAP(0x1600)	//T=u8, D=1, default wep key id
#define CSID_C_WLANAP_KEY0TYPE   		_CFG_WLANAP(0x1700)	//T=u8, D=0, wep key 0 type
#define CSID_C_WLANAP_KEY0		   		_CFG_WLANAP(0x1800)	//T=str, D="1234567890", wep key 0 value
#define CSID_C_WLANAP_KEY1TYPE   		_CFG_WLANAP(0x1900)	//T=u8, D=0, wep key 1 type
#define CSID_C_WLANAP_KEY1		  		_CFG_WLANAP(0x1a00)	//T=str, D="1234567890", wep key 1 value
#define CSID_C_WLANAP_KEY2TYPE   		_CFG_WLANAP(0x1b00)	//T=u8, D=0, wep key 2 type
#define CSID_C_WLANAP_KEY2				_CFG_WLANAP(0x1c00)	//T=str, D="1234567890", wep key 2 value
#define CSID_C_WLANAP_KEY3TYPE   		_CFG_WLANAP(0x1d00)	//T=u8, D=0, wep key 3 type
#define CSID_C_WLANAP_KEY3		   		_CFG_WLANAP(0x1e00)	//T=str, D="1234567890", wep key 3 value
#define CSID_C_WLANAP_WPAPSK	   		_CFG_WLANAP(0x1f00)	//T=str, D="1234567890", wpa psk value
#define CSID_C_WLANAP_REKEYINTERVAL		_CFG_WLANAP(0x2000)	//T=u32, D=0, wpa rekey interval
#define CSID_C_WLANAP_IAPP_DISABLE		_CFG_WLANAP(0x2100)	//T=u8, D=0, IAPP
#define CSID_C_WLANAP_WIFI_SPECIFIC		_CFG_WLANAP(0x2101)	//T=u8, D=0, WiFi test only
#define CSID_C_WLANAP_MACCLONE			_CFG_WLANAP(0x2102)	//T=u8, D=0, MAC clone
#define CSID_C_WLANAP_NPROTECTION		_CFG_WLANAP(0x2103)	//T=u8, D=0, 11n protection
#define CSID_C_WLANAP_ACCESS			_CFG_WLANAP(0x2104)	//T=u8, D=0, 11n guess access
#define CSID_C_WLANAP_EXPIRETIME		_CFG_WLANAP(0x2105)	//T=u8, D=0, Client expire time, in seconds,
#define CSID_C_WLANAP_MIMO_TR_MODE     	_CFG_WLANAP(0x2106) //T=u32, D=0, 1: 1T2R, 2: 2T4R, 3: 2T2R, 4: 1T1R
#define CSID_C_WLANAP_CARRIERDETECT	_CFG_WLANAP(0x2206) //T=u8, D=1, Japan=1 others:0 
#define CSID_C_WLANAP_FIXEDTXMODE       _CFG_WLANAP(0x2207) //T=str, D=HT, 11b only:CCK, 11g only & 11b/g mixed:OFDM,11g/n mixed & 11b/g/n mixed & 11n only:HT
#define CSID_C_WLANAP_EXTCHANNEL		_CFG_WLANAP(0x2300)	//T=u8, D=7, Extension channel

/*Radius Setting */
#define CSID_C_WLANAP_RADIUS_SRVIP	   	_CFG_WLANAP(0x3000)	//T=ipv4, radius server ip
#define CSID_C_WLANAP_RADIUS_SRVPORT   		_CFG_WLANAP(0x3800)	//T=u16, D=1812, radius server port
#define CSID_C_WLANAP_RADIUS_SRVKEY   		_CFG_WLANAP(0x4000)	//T=str, radius server share key
// define total support 8 radius server

/*WDS Setting */
#define CSID_C_WLANAP_WDSENABLE   		_CFG_WLANAP(0x5000)	//T=u8, D=0, enable/disable wds function
#define CSID_C_WLANAP_WDSMACLIST		_CFG_WLANAP(0x5001) //T=str, the collection of all ap mac address, 
#define CSID_C_WLANAP_WDSENCRYP   		_CFG_WLANAP(0x5100)	//T=u8, wds encryption type
#define CSID_C_WLANAP_WDSKEY    		_CFG_WLANAP(0x5200)	//T=str, wds encryption key
#define CSID_C_WLANAP_WDSAP     		_CFG_WLANAP(0x5800)	//T=mac, wds ap mac address
// define total support 8 wds ap

/*WMM Setting */
#define CSID_C_WLANAP_WMMENABLE    		_CFG_WLANAP(0x6000)	//T=u8, D=0, enable/disable WMM
#define CSID_C_WLANAP_APAIFSN     		_CFG_WLANAP(0x6100)	//T=u32, APAifsn
#define CSID_C_WLANAP_APCWMIN    		_CFG_WLANAP(0x6200)	//T=u32, APCwmin
#define CSID_C_WLANAP_APCWMAX    		_CFG_WLANAP(0x6300)	//T=u32, APCwmax
#define CSID_C_WLANAP_APACM    			_CFG_WLANAP(0x6400)	//T=u32, APACM
#define CSID_C_WLANAP_APTXOP    		_CFG_WLANAP(0x6500)	//T=u32, APTxop
#define CSID_C_WLANAP_BSSAIFSN     		_CFG_WLANAP(0x6600)	//T=u32, BSSAifsn
#define CSID_C_WLANAP_BSSCWMIN    		_CFG_WLANAP(0x6700)	//T=u32, BSSCwmin
#define CSID_C_WLANAP_BSSCWMAX    		_CFG_WLANAP(0x6800)	//T=u32, BSSCwmax
#define CSID_C_WLANAP_BSSACM    		_CFG_WLANAP(0x6900)	//T=u32, BSSACM
#define CSID_C_WLANAP_BSSTXOP    		_CFG_WLANAP(0x6a00)	//T=u32, BSSTxop
#define CSID_C_WLANAP_ACKPOLICY    		_CFG_WLANAP(0x6b00)	//T=u32, AckPolicy
#define CSID_C_WLANAP_WMMCAPABLE    		_CFG_WLANAP(0x6c00)	//T=u32, WmmCapable
#define CSID_C_WLANAP_DLSCAPABLE    		_CFG_WLANAP(0x6d00)	//T=u32, DlsCapable
#define CSID_C_WLANAP_APSDCAPABLE    		_CFG_WLANAP(0x6e00)	//T=u32, ApsdCapable

/*HT parameter Setting */
#define CSID_C_WLANAP_HT_HTC    		_CFG_WLANAP(0x8000)	//T=u8, HT_HTC
#define CSID_C_WLANAP_HT_RDG    		_CFG_WLANAP(0x8100)	//T=u8, D=1, HT_RDG
#define CSID_C_WLANAP_HT_EXTCHA    		_CFG_WLANAP(0x8200)	//T=u8, HT_EXTCHA
#define CSID_C_WLANAP_HT_LINKADAPT 		_CFG_WLANAP(0x8300)	//T=u8, HT_LinkAdapt
#define CSID_C_WLANAP_HT_OPMODE    		_CFG_WLANAP(0x8400)	//T=u8, HT_OpMode
#define CSID_C_WLANAP_HT_MPDUDENSITY		_CFG_WLANAP(0x8500)	//T=u8, D=5, HT_MpduDensity
#define CSID_C_WLANAP_HT_BW     		_CFG_WLANAP(0x8600)	//T=u8, D=1, HT_BW
#define CSID_C_WLANAP_HT_AUTOBA    		_CFG_WLANAP(0x8700)	//T=u8, D=1, HT_AutoBA
#define CSID_C_WLANAP_HT_AMSDU    		_CFG_WLANAP(0x8800)	//T=u8, HT_AMSDU
#define CSID_C_WLANAP_HT_BAWINSZ   		_CFG_WLANAP(0x8900)	//T=u8, D=64, HT_BAWinSize
#define CSID_C_WLANAP_HT_GI    			_CFG_WLANAP(0x8a00)	//T=u8, D=1, HT_GI
#define CSID_C_WLANAP_HT_STBC    		_CFG_WLANAP(0x8b00)	//T=u8, D=1, HT_STBC
#define CSID_C_WLANAP_HT_MCS    		_CFG_WLANAP(0x8c00)	//T=u8, D=3, HT_MCS
#define CSID_C_WLANAP_HT_BLOCKRELAY 	_CFG_WLANAP(0x8d00)	//T=u8, D=0, Block Relay
#define CSID_C_WLANAP_HT_TXSTREAM 	_CFG_WLANAP(0x8e00)	//T=u8, D=1, Tx Stream
#define CSID_C_WLANAP_HT_RXSTREAM 	_CFG_WLANAP(0x8f00)	//T=u8, D=1, Rx Stream

/*WPS Setting */
#define CSID_C_WLANAP_WPS_ENABLE   		_CFG_WLANAP(0xa000)	//T=u8, D=0, enable/disable wps function
#define CSID_C_WLANAP_WPS_AP_PINCODE	_CFG_WLANAP(0xa001) //T=str,WPS AP's PIN Code
#define CSID_C_WLANAP_WPS_CONFMODE		_CFG_WLANAP(0xa100) //T=u8, Set WPS function, Enrollee, Proxy, Registrar. bitwise
#define CSID_C_WLANAP_WPS_CONFSTATUS	_CFG_WLANAP(0xa200) //T=u8, D=1, Set WPS AP Simple Config State, Un-Configured/Configured
#define CSID_C_WLANAP_WPS_MODE  		_CFG_WLANAP(0xa300) //T=u8, D=1, configured metheds, PIN/PBC  
#define CSID_C_WLANAP_ATE_ENABLE		_CFG_WLANAP(0xa301) //T=u8, D=0,0:ATE diable,1:ATE enable

/* Status Items */
#define CSID_S_WLANAP_HOMECOM_ALTERED	_STA_WLANAP(0x0001) //T=u8, homecom wlan altered.
#define CSID_S_WLANAP_ALTERED			_STA_WLANAP(0x0002) //T=u8, ui altered
#define CSID_S_WLANAP_ATE_START			_STA_WLANAP(0x0003) //T=u32, D=0,0:stop,1:start, ate start

//For MutiSSID
//#define CSID_C_WLANAP_SSID_LIST			_CFG_WLANAP(0x0006) //T=str, D="AP1;AP2;AP3;AP4", MutiBSSID
#define CSID_S_WLANAP_AUTHMODE_LIST		_STA_WLANAP(0x0007) //T=str, D="OPEN;OPEN;OPEN;OPEN", Authentication
#define CSID_S_WLANAP_ENCRYPTYPE_LIST	_STA_WLANAP(0x0008) //T=str, D="NONE;NONE;NONE;NONE", Encryption mathod
//#define CSID_C_WLANAP_WPAPSK_LIST		_CFG_WLANAP(0x0009) //T=str, D="NONE;NONE;NONE;NONE", list of WPA PSK value
#define CSID_S_WLANAP_DEFKEYID_LIST		_STA_WLANAP(0x000A) //T=str, D="1;1;1;1", list of default wep key id
#define CSID_S_WLANAP_KEY0TYPE_LIST     _STA_WLANAP(0x000B) //T=str, D="0;0;0;0", list of wep key0 type 
//#define CSID_C_WLANAP_KEY0_LIST        	_CFG_WLANAP(0x000C) //T=str, D="NONE;NONE;NONE;NONE", list of key0 value
#define CSID_S_WLANAP_KEY1TYPE_LIST		_STA_WLANAP(0x000D) //T=str, D="0;0;0;0", list of wep key1 type         
//#define CSID_C_WLANAP_KEY1_LIST			_CFG_WLANAP(0x000E) //T=str, D="NONE;NONE;NONE;NONE", list of key1 value
#define CSID_S_WLANAP_KEY2TYPE_LIST		_STA_WLANAP(0x000F) //T=str, D="0;0;0;0", list of wep key2 type
//#define CSID_C_WLANAP_KEY2_LIST			_CFG_WLANAP(0x0011) //T=str, D="NONE;NONE;NONE;NONE", list of key2 value
#define CSID_S_WLANAP_KEY3TYPE_LIST		_STA_WLANAP(0x0012) //T=str, D="0;0;0;0", list of wep key3 type
//#define CSID_C_WLANAP_KEY3_LIST			_CFG_WLANAP(0x0013) //T=str, D="NONE;NONE;NONE;NONE", list of key3 value
#define CSID_S_WLANAP_IEEE8021X_LIST	_STA_WLANAP(0x0014) //T=str, D="0;0;0;0", list of whether enabling 8021X function in mutissid
#define CSID_S_WLANAP_HIDESSID_LIST		_STA_WLANAP(0x0015) //T=str, D="0;0;0;0", list of whether enabling HIDESSID. 
#define CSID_S_WLANAP_RADIUS_SRVIP_LIST		_STA_WLANAP(0x0016)	//T=str, list of radius server ip 			 
#define CSID_S_WLANAP_RADIUS_SRVPORT_LIST	_STA_WLANAP(0x0017)	//T=str, list of radius port
#define CSID_S_WLANAP_RADIUS_SRVKEY_LIST	_STA_WLANAP(0x0018) //T=str, list of radius key

// WPS Status 
#define CSID_S_WLANAP_WPS_ENROLLEE_PINCODE	_STA_WLANAP(0x0100) //T=str, WPS, Enrollee's PIN Code
#define CSID_S_WLANAP_WPS_TRIGGER			_STA_WLANAP(0x0101) //T=u8, WPS, Trigger AP to do simple config.
#define CSID_S_WLANAP_WPS_ALTERED			_STA_WLANAP(0x0102) //T=u8, WPS, ui altered
#define CSID_S_WLANAP_WPS_STATUS			_STA_WLANAP(0x0103) //T=u8, D=0 ,WPS configured status
#define CSID_S_WLANAP_WPS_AP_PINCODE		_STA_WLANAP(0x0104) //T=str, WPS AP's PIN Code
#define CSID_S_WLANAP_WPS_AP_PUSH			_STA_WLANAP(0x0105) //T=u8, WPS, Push Button Enable/Disable
#define CSID_S_WLANAP_WPS_ACTION_INTERVAL	_STA_WLANAP(0x0106)	//T=u32, D=30,WPS Action Time Interval

#define CSID_S_WLANAP_WPS_DEF_AUTHMODE		_STA_WLANAP(0x0110) //T=u32, Default WPS AuthMode
#define CSID_S_WLANAP_WPS_DEF_ENCRYPTYPE	_STA_WLANAP(0x0111) //T=u32, Default WPS ENCRYPTYPE
#define CSID_S_WLANAP_WPS_DEF_WPAPSK		_STA_WLANAP(0x0112) //T=str, Default WPS WPAPSK

#define CSID_S_WLANAP_WPS_WSC_MANUFACTURE	_STA_WLANAP(0x0113) //T=str, D="Amit" , WSC UPnP Manufacture
#define CSID_S_WLANAP_WPS_WSC_MODEL_NAME	_STA_WLANAP(0x0114) //T=str, D="3G Router" , WSC UPnP Model Name
#define CSID_S_WLANAP_WPS_WSC_DEVICE_NAME	_STA_WLANAP(0x0115) //T=str, D="WBR-0001" , WSC UPnP Device Name 
#define CSID_S_WLANAP_WPS_WSC_MODEL_NUMBER	_STA_WLANAP(0x0116) //T=str, D="WBR-0001" , WSC UPnP Model Numer



/* Wireless Client-List, 256 items are reserved */
#define CSID_S_WLANAP_CLILIST_MAC			_STA_WLANAP(0x1000)	//T=mac, The MAC of the Client in Client List

/* Ralink ATE Command */
#define CSID_S_WLANAP_ATE_DATARATE	_STA_WLANAP(0x2000) //T=u32, D=11,Date rate		
#define CSID_S_WLANAP_ATE_CERTIFICATIONMODE _STA_WLANAP(0x2100) //T=u32, D=0,0:Normal,1:Cont.Tx,2:Cont. Rx,3:Tx carrier
#define CSID_S_WLANAP_ATE_CHANNEL _STA_WLANAP(0x2200) //T=u32, D=6, channel
#define CSID_S_WLANAP_ATE_WIRELESSMODE _STA_WLANAP(0x2300) //T=u32,D=1,0:b only,1:g only,2:bgn mixed,3:n only,wireless mode
#define CSID_S_WLANAP_ATE_TXPOWER	_STA_WLANAP(0x2400) //T=u32, tx power level(0.5dBm/unit)
#define CSID_S_WLANAP_ATE_BW _STA_WLANAP(0x2500) //T=u32,D=0,0:20MHz,1:40MHz, BandWidth
#define CSID_S_WLANAP_ATE_Antenna	_STA_WLANAP(0x2600) //T=u32, D=1, 1:A, 2:B, 3:AB Antenna


/* H/W settings, MUST in P section. */
#define CSID_S_WLANAP_WLAN0_REG_DOMAIN		_STA_WLANAP(0x9001)	//T=u32, D=1, FCC=1,IC=2,ETSI=3,SPAIN=4,FRANCE=5,MKK=6 
#define CSID_S_WLANAP_RF_TYPE				_STA_WLANAP(0x9002)	//T=u32, D=0, RF
#define CSID_S_WLANAP_LED_TYPE				_STA_WLANAP(0x9003)	//T=u32, D=0, LED
#define CSID_S_WLANAP_WLAN0_11N_LOFDMPWD    _STA_WLANAP(0x9004)	//T=u32, D=0, OFDM diff
#define CSID_S_WLANAP_WLAN0_RX_Antenna      _STA_WLANAP(0x9005) //T=u32, D=0, RX antenna
#define CSID_S_WLANAP_WLAN0_11N_THER_RFIC   _STA_WLANAP(0x9006)	//T=u32, D=0, no used
#define CSID_S_WLANAP_WLAN0_11N_XCAP	    _STA_WLANAP(0x9007)	//T=u32, D=0, xcap
#define CSID_S_WLANAP_WLAN0_11N_AntCdiff    _STA_WLANAP(0x9008) //T=u32, D=0, AntCdiff
#define CSID_S_WLANAP_WLAN0_TX_Antenna		_STA_WLANAP(0x9009)	//T=u32, D=0, TX antenna
#define CSID_S_WLANAP_WLAN0_Channel			_STA_WLANAP(0x900a) //T=u32, D=0, channel
#define CSID_S_WLANAP_WLAN0_DataRate		_STA_WLANAP(0x900b) //T=u32, D=0, DataRate
#define CSID_S_WLANAP_WLAN0_Bandwith		_STA_WLANAP(0x900c) //T=u32, D=0, Bandwith
#define CSID_S_WLANAP_WLAN0_GI				_STA_WLANAP(0x900d) //T=u32, D=0, GI
#define CSID_S_WLANAP_Packet_Count			_STA_WLANAP(0x900e) //T=u32, D=0, Packet Count
#define CSID_S_WLANAP_Packet_Length			_STA_WLANAP(0x900f) //T=u32, D=0, Packet Length
#define CSID_S_WLANAP_RX_OK					_STA_WLANAP(0x9010) //T=u32, D=0, RX OK
#define CSID_S_WLANAP_RX_Error				_STA_WLANAP(0x9011) //T=u32, D=0, RX Error
#define CSID_S_WLANAP_TX_Count				_STA_WLANAP(0x9012) //T=u32, D=0, TX Count
#define CSID_S_WLANAP_A_Rssi              	_STA_WLANAP(0x9013) //T=u32, D=0, A rssi
#define CSID_S_WLANAP_B_Rssi              	_STA_WLANAP(0x9014) //T=u32, D=0, B rssi
#define CSID_S_WLANAP_C_Rssi              	_STA_WLANAP(0x9015) //T=u32, D=0, C rssi
#define CSID_S_WLANAP_D_Rssi              	_STA_WLANAP(0x9016) //T=u32, D=0, D rssi
#define CSID_S_WLANAP_WLAN0_11N_LOFDMPWDA	_STA_WLANAP(0x9017) //T=u32, D=0, OFDM A diff for RTL8192SE
#define CSID_S_WLANAP_WLAN0_11N_LOFDMPWDB	_STA_WLANAP(0x9018) //T=u32, D=0, OFDM B diff for RTL8192SE
#define CSID_S_WLANAP_WLAN0_HW_11N_THER		_STA_WLANAP(0x9019) //T=u32, D=0, Thermal TSSI for RTL8192SE
#define CSID_S_WLANAP_WLAN0_11N_AntBdiff	_STA_WLANAP(0x901a) //T=u32, D=0, AntBdiff for RTL8192SE
#define CSID_S_WLANAP_TX_POWER_CCK			_STA_WLANAP(0x9100)	//T=u32, D=0, 11b 255 entries
#define CSID_S_WLANAP_TX_POWER_OFDM         _STA_WLANAP(0x9200)	//T=u32, D=0, 11g 255 entries
#define CSID_S_WLANAP_TX_POWER_MCSA         _STA_WLANAP(0x9300) //T=u32, D=0, 11n Antenna A 255 entries
#define CSID_S_WLANAP_TX_POWER_MCSC         _STA_WLANAP(0x9400) //T=u32, D=0, 11n Antenna C 255 entries
#define CSID_S_WLANAP_TX_POWER_MCSA_1S		_STA_WLANAP(0x9500) //T=u32, D=0, 11n Antenna A 255 entries for RTL8192SE
#define CSID_S_WLANAP_TX_POWER_MCSB_1S		_STA_WLANAP(0x9600) //T=u32, D=0, 11n Antenna B 255 entries for RTL8192SE
#define CSID_S_WLANAP_TX_POWER_MCSA_2S		_STA_WLANAP(0x9700) //T=u32, D=0, 11n Antenna A 255 entries for RTL8192SE
#define CSID_S_WLANAP_TX_POWER_MCSB_2S		_STA_WLANAP(0x9800) //T=u32, D=0, 11n Antenna B 255 entries for RTL8192SE



#endif
