/*
 * @file Member ID Definition of Group WiBro
 *
 * Moderator: Jon
 * Group ID: 0x00350000/0x80350000
 */

#ifndef _CSID_WIBRO_H
#define _CSID_WIBRO_H

#include "csid_gid.h"

#define _CFG_WIBRO(x)					(CSID_GIDC_WIBRO|(x))
#define _STA_WIBRO(x)					(CSID_GIDS_WIBRO|(x))

/* Extra Definitions */
#define WIBRO_CNT_TYPE_ONDEMAND			0x00
#define WIBRO_CNT_TYPE_AUTORECONNECT	0x01
#define WIBRO_CNT_TYPE_MANUAL			0x02

#define WIBRO_CNT_STATUS_DISCONNECT		0x00
#define WIBRO_CNT_STATUS_CONNECTING		0x01
#define WIBRO_CNT_STATUS_CONNECT		0x02
#define WIBRO_CNT_STATUS_DISCONNECTING	0x03
#define WIBRO_CNT_STATUS_LEASEFAIL      0x04
#define WIBRO_CNT_STATUS_WAIT_TRAFFIC	0x05


#define WIBRO_MODEM_STATUS_DISCONNECT		0x00
#define WIBRO_MODEM_STATUS_CONNECTING		0x01
#define WIBRO_MODEM_STATUS_CONNECT			0x02
#define WIBRO_MODEM_STATUS_DISCONNECTING	0x03
#define WIBRO_MODEM_STATUS_IDLE				0x04
#define WIBRO_MODEM_STATUS_AUTH				0x05
#define WIBRO_MODEM_STATUS_INIT         	0x06


#define WIBRO_MODEM_STATUS_SIM_ERROR    	0x81
#define WIBRO_MODEM_STATUS_PIN_ERROR		0x82
#define WIBRO_MODEM_STATUS_LOCK_ERROR   	0x83
#define WIBRO_MODEM_STATUS_AUTH_ERROR   	0x84

#define WIBRO_HOTPLUG_STATUS_NOCARD			0x00
#define WIBRO_HOTPLUG_STATUS_INSERTING		0x01
#define WIBRO_HOTPLUG_STATUS_INSERTED       0x02


/* Configuration Items */
#define CSID_C_WIBRO_HOSTNAME           _CFG_WIBRO(0x5002)   //T=str, Client's Host Name
#define CSID_C_WIBRO_IF_IP              _CFG_WIBRO(0x5004)   //T=ipv4, static interface ip
#define CSID_C_WIBRO_IF_NM              _CFG_WIBRO(0x5005)   //T=ipv4, static interface netmask
#define CSID_C_WIBRO_IF_GW              _CFG_WIBRO(0x5006)   //T=ipv4, static interface gateway
#define CSID_C_WIBRO_IF_PRIDNS          _CFG_WIBRO(0x5007)   //T=ipv4, static interface Primary DNS
#define CSID_C_WIBRO_IF_SECDNS          _CFG_WIBRO(0x5008)   //T=ipv4, static interface Second DNS 
#define CSID_C_WIBRO_MTU                _CFG_WIBRO(0x5009)   //T=u32, MTU
#define CSID_C_WIBRO_CNT_TYPE           _CFG_WIBRO(0x500a)   //T=u32, Connect Type
#define CSID_C_WIBRO_CHGTTL             _CFG_WIBRO(0x500b)   //T=u8, Enable/Disable , Change the TTL value
#define CSID_C_WIBRO_AUTOBKP            _CFG_WIBRO(0x500c)   //T=u8, Enable/Disable , Auto Backup
#define CSID_C_WIBRO_IDLETIME           _CFG_WIBRO(0x500d)   //T=u16, D=600, max idle time
#define CSID_C_WIBRO_NAT_DISABLE        _CFG_WIBRO(0x500f)   //T=u32, Dynamic IP wantype NAT disable
#define CSID_C_WIBRO_PIN                _CFG_WIBRO(0x5010)   //T=str, PIN

/* Status Items */
#define CSID_S_WIBRO_PID                _STA_WIBRO(0x5001)   //T=u16, The PID of DHCP Client 
#define CSID_S_WIBRO_IF_IP              _STA_WIBRO(0x5002)   //T=ipv4, dynamic interface ip  
#define CSID_S_WIBRO_IF_NM              _STA_WIBRO(0x5003)   //T=ipv4, dynamic interface netmask
#define CSID_S_WIBRO_IF_GW              _STA_WIBRO(0x5004)   //T=ipv4, dynamic interface gateway
#define CSID_S_WIBRO_IF_PRIDNS          _STA_WIBRO(0x5005)   //T=ipv4, dynamic interface Primary DNS
#define CSID_S_WIBRO_IF_SECDNS          _STA_WIBRO(0x5006)   //T=ipv4, dynamic interface Second DNS 
#define CSID_S_WIBRO_CNT_STATUS         _STA_WIBRO(0x5007)   //T=u32, connect status
#define CSID_S_WIBRO_ALTERED            _STA_WIBRO(0x5008)   //T=u32, ui altered
#define CSID_S_WIBRO_LEASE_TIME         _STA_WIBRO(0x5009)   //T=u32, uptime + leasetime
#define CSID_S_WIBRO_CNT_TIME           _STA_WIBRO(0x500a)   //T=u32, connect time
#define CSID_S_WIBRO_PKTIN_NUM          _STA_WIBRO(0x500b)   //T=u32, number of packet input
#define CSID_S_WIBRO_PKTOUT_NUM         _STA_WIBRO(0x500c)   //T=u32, number of packet output
#define CSID_S_WIBRO_MODEM_STATUS       _STA_WIBRO(0x500d)   //T=u32, modem status
#define CSID_S_WIBRO_MODEM_ALTERED      _STA_WIBRO(0x500e)   //T=u32, modem altered
#define CSID_S_WIBRO_HOTPLUG_STATUS		_STA_WIBRO(0x500f)	 //T=u32, hotplug status

#endif //ifndef _CSID_WIBRO_H
