/*
 * @file Member ID Definition of Group VPN.
 *
 * Moderator: Tim_Hung
 * Group ID: 0x00700000/0x80700000
 */

#ifndef _CSID_VPN_H
#define _CSID_VPN_H

#include "csid_gid.h"

#define _CFG_VPN(x)       (CSID_GIDC_VPN|(x))
#define _STA_VPN(x)       (CSID_GIDS_VPN|(x))

/* Extra Definitions */

//Enable/Disable Switch
#define	IPSEC_DISABLE		0
#define IPSEC_Embedded		1
#define IPSEC_PASSTHROUGH	2

//Tunnel Command
#define IPSEC_CMD_NOOP			0
#define IPSEC_CMD_CONNECT			1
#define IPSEC_CMD_DISCONNECT		2

//Key Exchange Method
#define	IPSEC_METHOD_IKE		0
#define IPSEC_METHOD_MK			1 //Manual Keying

//Encapsulation Protocol
#define IPSEC_AH_TUN				1 //AH Tunnel
#define IPSEC_AH_TRANS			2 //AH Transport
#define IPSEC_ESP_TUN				3 //ESP Tunnel
#define IPSEC_ESP_TRANS			4 //ESP Transport
#define	IPSEC_ESP_AH_TUN			5 //ESP+AH Tunnel
#define IPSEC_ESP_AH_TRANS		6 //ESP+AH Transport

//PFS Group
#define IPSEC_PFS_DISABLE			0
#define IPSEC_PFS_GROUP1			1
#define IPSEC_PFS_GROUP2			2
#define IPSEC_PFS_GROUP5			3	
#define IPSEC_PFS_AS_PHASE1		4 //Same as Phase1
	
//ID
#define IPSEC_ID_IPV4				0
#define IPSEC_ID_FQDN				1
#define IPSEC_ID_USER_FQDN		2 //USER@FQDN
#define IPSEC_ID_KEY_ID			3

//Encryption Algorithm
#define IPSEC_ENC_DES				1
#define IPSEC_ENC_3DES			2
#define IPSEC_ENC_AES				3
#define IPSEC_ENC_NULL			4

//Authenticate Algorithm
#define IPSEC_AUTH_ANY			0 //Only use in phase 1 proposal
#define IPSEC_AUTH_MD5			1
#define IPSEC_AUTH_SHA1			2
#define IPSEC_AUTH_NONE			3 //use for ESP without AH

//Phase 1 DHGroup
#define IPSEC_P1_GROUP_ANY		0 //Only use in phase 1 proposal
#define IPSEC_P1_GROUP1			1
#define IPSEC_P1_GROUP2			2
#define IPSEC_P1_GROUP5			3

//XAUTH
#define IPSEC_XAUTH_DISABLE		0
#define IPSEC_XAUTH_SERV			1
#define IPSEC_XAUTH_CLI			2

//Tunnel Status
#define IPSEC_S_DISCONNECT	0
#define IPSEC_S_WAIT			1 //Wait for traffic
#define IPSEC_S_CONNECTING	2
#define IPSEC_S_CONNECTED		3

#define VPN_RULE_CSID_GAP             0x10 

#define CSID_S_IPSEC_ALTERED							_STA_VPN(0x0002) //T=u32, vpn setting altered
/* Configuration Items */
//0x0001~0x03FF
#define CSID_C_IPSEC_TYPE								_CFG_VPN(0x0010) //T=u32, D=0,Ipsec Type
#define CSID_C_IPSEC_EMBEDDED_EN						_CFG_VPN(0x0020) //T=u32, D=1,Embedded ,0:Disable,1:Enable
#define CSID_C_IPSEC_PASSTHROUGH_EN						_CFG_VPN(0x0030) //T=u32, D=0,Passthrough,0:Disable,1:Enable
#define CSID_C_IPSEC_MAX_TUNNELS						_CFG_VPN(0x0040) //T=u32, D=5,Max number of Tunnel
#define CSID_C_IPSEC_NETBIOS							_CFG_VPN(0x0050) //T=u32, D=0,Netbios over ipsec,0:Disable,1:Enable
#define CSID_C_IPSEC_SSDP								_CFG_VPN(0x0060) //T=u32, D=0,SSDP over ipsec,0:Disable,1:Enable

/*Basic Setting */

//Tunnel Setting 0x0800~0x0FFF
#define CSID_C_IPSEC_TUN_NAME							_CFG_VPN(0x0100) //T=str, D=0,IKE Tunnel name
#define CSID_C_IPSEC_TUN_EN								_CFG_VPN(0x0200) //T=u32, D=0,IKE Tunnel ,0:Disable,1:Enable
#define CSID_C_IPSEC_TUN_KEY_METHOD						_CFG_VPN(0x0300) //T=u32, D=0,IKE KEY Method 

#define CSID_C_IPSEC_TUN_IKE_L_SUBNET					_CFG_VPN(0x0400) //T=ipv4,IKE Local Subnet
#define CSID_C_IPSEC_TUN_IKE_L_MASK						_CFG_VPN(0x0500) //T=ipv4,IKE Local Netmask
#define CSID_C_IPSEC_TUN_IKE_R_SUBNET					_CFG_VPN(0x0600) //T=ipv4,IKE Remote Subnet
#define CSID_C_IPSEC_TUN_IKE_R_MASK						_CFG_VPN(0x0700) //T=ipv4,IKE Remote Netmask
#define CSID_C_IPSEC_TUN_IKE_R_GATEWAY					_CFG_VPN(0x0800) //T=ipv4,IKE Remote Gateway

#define CSID_C_IPSEC_TUN_MK_L_SUBNET                    _CFG_VPN(0x0900) //T=ipv4,MANUAL Local Subnet
#define CSID_C_IPSEC_TUN_MK_L_MASK                      _CFG_VPN(0x0A00) //T=ipv4,MANUAL Local Netmask
#define CSID_C_IPSEC_TUN_MK_R_SUBNET                    _CFG_VPN(0x0B00) //T=ipv4,MANUAL Remote Subnet
#define CSID_C_IPSEC_TUN_MK_R_MASK                      _CFG_VPN(0x0C00) //T=ipv4,MANUAL Remote Netmask
#define CSID_C_IPSEC_TUN_MK_R_GATEWAY                   _CFG_VPN(0x0D00) //T=ipv4,MANUAL Remote Gateway


//XAUTH Server 0x0400~0x07FF
#define CSID_C_IPSEC_XAUTH_SRV_USER                     _CFG_VPN(0x2000) //T=str, D=0,Xauth server user name
#define CSID_C_IPSEC_XAUTH_SRV_PASS                     _CFG_VPN(0x3000) //T=str, D=0,Xauth server password

//Manual Keying Setting 0x1000~0x17FFF
#define CSID_C_IPSEC_TUN_MK_CMD                         _CFG_VPN(0x3100) //T=u32, D=0,MANUAL Tunnel Mode,0:Tunnel mode,1:Transport mode
#define CSID_C_IPSEC_TUN_MK_INBOUND_SPI 				_CFG_VPN(0x4100) //T=str, D=0,Inbound spi value
#define CSID_C_IPSEC_TUN_MK_OUTBOUND_SPI				_CFG_VPN(0x4200) //T=str, D=0,Outbound spi value
#define CSID_C_IPSEC_TUN_MK_ENC_ALG						_CFG_VPN(0x4300) //T=u32, D=0,Encryption Algorithm,0:none; 1:DES; 2:3DES
#define CSID_C_IPSEC_TUN_MK_ENC_KEY1					_CFG_VPN(0x4400) //T=str, D=0,Encryption key1 value
#define CSID_C_IPSEC_TUN_MK_ENC_KEY2					_CFG_VPN(0x4500) //T=str, D=0,Encryption key2 value
#define CSID_C_IPSEC_TUN_MK_ENC_KEY3					_CFG_VPN(0x4600) //T=str, D=0,Encryption key3 value
#define CSID_C_IPSEC_TUN_MK_AUTH_ALG					_CFG_VPN(0x4700) //T=u32, D=0,Authenticate Algorithm,0:none; 1:MD5; 2:SHA1
#define CSID_C_IPSEC_TUN_MK_AUTH_KEY					_CFG_VPN(0x4800) //T=str, D=0,Authenticate key value
#define CSID_C_IPSEC_TUN_MK_ENCAP						_CFG_VPN(0x4900) //T=u32, D=5,Encapsulation Protocol,1:AH_TUNNEL,2:AH_TRANSPORT,3:ESP_TUNNEL																				,4:ESP_TRANSPORT,5:ESP_TUNNEL_WITH_AUTH,6:ESP_TRANSPORT_WITH_AUTH;
//IKE  0x1800~0x1FFF
#define CSID_C_IPSEC_TUN_IKE_CMD						_CFG_VPN(0x4A00) //T=u32, D=0,IKE Tunnel Mode,0:Tunnel mode,1:Transport mode
#define CSID_C_IPSEC_TUN_IKE_ENCAP						_CFG_VPN(0x5000) //T=u32, D=1,Encapsulation Protocol,0:AH,1:ESP,2:AH+ESP
#define CSID_C_IPSEC_TUN_IKE_AGGR						_CFG_VPN(0x5100) //T=u32, D=0,Aggressive Mode,0:Disable,1:Enable
#define CSID_C_IPSEC_TUN_IKE_PRESHARE_KEY				_CFG_VPN(0x5200) //T=str, D=0,preshare key
#define CSID_C_IPSEC_TUN_IKE_PFS_GROUP					_CFG_VPN(0x5300) //T=u32, D=0,PFS Group,0:disable,1:Group 1,2:Group 2,3:Group 5,4:Same as Phase1
#define CSID_C_IPSEC_TUN_IKE_R_ID_VALUE					_CFG_VPN(0x5400) //T=str, D=0,Remote ID value
#define CSID_C_IPSEC_TUN_IKE_R_ID_TYPE					_CFG_VPN(0x5500) //T=u32, D=0,Remote ID type,0:Username,1:FQDN,2:UserFQDN,3:Key_ID
#define CSID_C_IPSEC_TUN_IKE_L_ID_TYPE					_CFG_VPN(0x5600) //T=u32, D=0,Local ID type,0:Username,1:FQDN,2:UserFQDN,3:Key_ID
#define CSID_C_IPSEC_TUN_IKE_L_ID_VALUE					_CFG_VPN(0x5700) //T=str, D=0,Local ID value
#define CSID_C_IPSEC_TUN_IKE_KEEP_ALIVE_EN				_CFG_VPN(0x5800) //T=u32, D=0,Keep Alive En,0:Disable,1:Enable
#define CSID_C_IPSEC_TUN_IKE_KEEP_ALIVE_IP				_CFG_VPN(0x5900) //T=ipv4,D=0,Keep Alive IP
#define CSID_C_IPSEC_TUN_IKE_KEEP_ALIVE_TIME			_CFG_VPN(0x5A00) //T=u32, D=0,Keep Alive Time
#define CSID_C_IPSEC_TUN_IKE_XAUTH						_CFG_VPN(0x5B00) //T=u32, D=0,IKE Xauth,0:XAUTH_NONEN,1:XAUTH_SERVER,2:XAUTH_CLIENT
#define CSID_C_IPSEC_TUN_IKE_XAUTH_C_USER				_CFG_VPN(0x5C00) //T=str, D=0,Xauth Client user name
#define CSID_C_IPSEC_TUN_IKE_XAUTH_C_PASS				_CFG_VPN(0x5D00) //T=str, D=0,Xauth Client password

//IKE Phase1 Proposa1 0x2000~0x3FFF
#define CSID_C_IPSEC_TUN_IKE_P1_KEYLIFE_SEC				_CFG_VPN(0x6000) //T=str, D=0,Phase1 key life Time(Sec),0:default
#define CSID_C_IPSEC_TUN_IKE_P1_KEYLIFE_BYTE			_CFG_VPN(0x6100) //T=str, D=0,Phase1 key life Time(Byte),0:default
#define CSID_C_IPSEC_TUN_IKE_P1_PROP_EN					_CFG_VPN(0x6200) //T=u32, D=0,Phase1 Proposal,0:Disable,1:Enable
#define CSID_C_IPSEC_TUN_IKE_P1_PROP_1_EN				_CFG_VPN(0x6300) //T=u32, D=0,Proposal(1),0:Disable,1:Enable
#define CSID_C_IPSEC_TUN_IKE_P1_PROP_1_ENC				_CFG_VPN(0x6400) //T=u32, D=0,Proposal(1) Encryption,0:none,1:DES,2:3DES,3:AES-128,4:AES-192,5:AES-256
#define CSID_C_IPSEC_TUN_IKE_P1_PROP_1_AUTH				_CFG_VPN(0x6500) //T=u32, D=0,Proposal(1) Authentication,0:none,1:MD5, 2:SHA1
#define CSID_C_IPSEC_TUN_IKE_P1_PROP_1_GROUP			_CFG_VPN(0x6600) //T=u32, D=0,Proposal(1) Group,0:none,1:Group1,2:Group2,3:Group5
#define CSID_C_IPSEC_TUN_IKE_P1_PROP_2_EN				_CFG_VPN(0x6700) //T=u32, D=0,Proposal(2),0:Disable,1:Enable
#define CSID_C_IPSEC_TUN_IKE_P1_PROP_2_ENC				_CFG_VPN(0x6800) //T=u32, D=0,Proposal(2) Encryption,0:none,1:DES,2:3DES,3:AES-128,4:AES-192,5:AES-256
#define CSID_C_IPSEC_TUN_IKE_P1_PROP_2_AUTH				_CFG_VPN(0x6900) //T=u32, D=0,Proposal(2) Authentication,0:none,1:MD5, 2:SHA1
#define CSID_C_IPSEC_TUN_IKE_P1_PROP_2_GROUP			_CFG_VPN(0x6A00) //T=u32, D=0,Proposal(2) Group,0:none,1:Group1,2:Group2,3:Group5

//IKE Phase2 Proposal 0x4000~0x5FFF
#define CSID_C_IPSEC_TUN_IKE_P2_KEYLIFE_SEC				_CFG_VPN(0x7000) //T=str, D=0,Phase2 key life Time(Sec),0:default
#define CSID_C_IPSEC_TUN_IKE_P2_KEYLIFE_BYTE			_CFG_VPN(0x7100) //T=str, D=0,Phase2 key life Time(Byte),0:default
#define CSID_C_IPSEC_TUN_IKE_P2_PROP_EN					_CFG_VPN(0x7200) //T=u32, D=0,Phase2 Proposal,0:Disable,1:Enable
#define CSID_C_IPSEC_TUN_IKE_P2_PROP_1_EN				_CFG_VPN(0x7300) //T=u32, D=0,Proposal(1),0:Disable,1:Enable
#define CSID_C_IPSEC_TUN_IKE_P2_PROP_1_ENC				_CFG_VPN(0x7400) //T=u32, D=0,Proposal(1) Encryption,0:none,1:DES,2:3DES,3:AES-128,4:AES-192,5:AES-256,6:Null
#define CSID_C_IPSEC_TUN_IKE_P2_PROP_1_AUTH				_CFG_VPN(0x7500) //T=u32, D=0,Proposal(1) Authentication,0:none,1:MD5, 2:SHA1,3:None
#define CSID_C_IPSEC_TUN_IKE_P2_PROP_2_EN				_CFG_VPN(0x7600) //T=u32, D=0, Proposal(2),0:Disable,1:Enable
#define CSID_C_IPSEC_TUN_IKE_P2_PROP_2_ENC				_CFG_VPN(0x7700) //T=u32, D=0,Proposa(2) Encryption,0:none,1:DES,2:3DES,3:AES-128,4:AES-192,5:AES-256,6:Null
#define CSID_C_IPSEC_TUN_IKE_P2_PROP_2_AUTH				_CFG_VPN(0x7800) //T=u32, D=0,Proposa(2) Authentication,0:none,1:MD5, 2:SHA1,3:None


//VPN Dynamic IP Setting 0x6000~0x7FFF
#define CSID_C_IPSEC_DYNA_EN							_CFG_VPN(0x8000) //T=u32, D=0,VPN,0:Disable,1:Enable  
#define CSID_C_IPSEC_DYNA_TUN_NAME						_CFG_VPN(0x8100) //T=str, D=0,Tunnel Name
#define CSID_C_IPSEC_DYNA_TUN_L_SUBNET					_CFG_VPN(0x8200) //T=ipv4,D=0,Local Subnet
#define CSID_C_IPSEC_DYNA_TUN_L_MASK					_CFG_VPN(0x8300) //T=ipv4,D=0,Local Netmask
#define CSID_C_IPSEC_DYNA_TUN_ENCAP						_CFG_VPN(0x8400) //T=u32, D=1,Encapsulation Protocol,0:AH,1:ESP,2:AH+ESP

//IKE 0x8000~0x9FFF
#define CSID_C_IPSEC_DYNA_TUN_IKE_PRESHARE_KEY			_CFG_VPN(0x8500) //T=str, D=0,Preshare key
#define CSID_C_IPSEC_DYNA_TUN_IKE_PFS_GROUP				_CFG_VPN(0x8600) //T=u32, D=0,PFS Group,0:disable,1:Group 1,2:Group 2,3:Group 5,4:Same as Phase1
#define CSID_C_IPSEC_DYNA_TUN_IKE_R_ID_VALUE			_CFG_VPN(0x8700) //T=str, D=0,Remote ID value
#define CSID_C_IPSEC_DYNA_TUN_IKE_R_ID_TYPE				_CFG_VPN(0x8800) //T=ipv4,D=0,Remote ID Type,0:Username,1:FQDN,2:UserFQDN,3:Key_ID
#define CSID_C_IPSEC_DYNA_TUN_IKE_L_ID_TYPE				_CFG_VPN(0x8900) //T=ipv4,D=0,Local ID Type,0:Username,1:FQDN,2:UserFQDN,3:Key_ID
#define CSID_C_IPSEC_DYNA_TUN_IKE_L_ID_VALUE			_CFG_VPN(0x8A00) //T=str, D=0,Local ID value
#define CSID_C_IPSEC_DYNA_TUN_IKE_XAUTH					_CFG_VPN(0x8B00) //T=u32, D=0,IKE Xauth,0:XAUTH_NONE,1:XAUTH_SERVER,2:XAUTH_CLIENT

//IKE Phase1 Proposal	0xA000~0xBFFF
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_KEYLIFE_SEC		_CFG_VPN(0x9000) //T=u32, D=0,Phase1 key life Time(Sec),0:default
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_KEYLIFE_BYTE		_CFG_VPN(0x9100) //T=u32, D=0,Phase1 Key life Time(Byte),0:default
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_PROP_EN			_CFG_VPN(0x9200) //T=u32, D=0,Phase1 Proposal,0:Disable,1:Enable
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_PROP_1_EN			_CFG_VPN(0x9300) //T=u32, D=0,Proposal(1),0:Disable,1:Enable
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_PROP_1_ENC			_CFG_VPN(0x9400) //T=u32, D=0,Proposal(1) Encryption,0:none,1:DES,2:3DES,3:AES-128,4:AES-192,5:AES-256,6:Null
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_PROP_1_AUTH		_CFG_VPN(0x9500) //T=u32, D=0,Proposal(1) Authentication,0:none,1:MD5, 2:SHA1,3:None
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_PROP_1_GROUP		_CFG_VPN(0x9600) //T=u32, D=0,Proposal(1) Group,0:none,1:Group1,2:Group2,3:Group5
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_PROP_2_EN			_CFG_VPN(0x9700) //T=u32, D=0,Proposal(2),0:Disable,1:Enable
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_PROP_2_ENC			_CFG_VPN(0x9800) //T=u32, D=0,Proposal(2) Encryption,0:none,1:DES,2:3DES,3:AES-128,4:AES-192,5:AES-256,6:Null
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_PROP_2_AUTH		_CFG_VPN(0x9900) //T=u32, D=0,Proposal(2) Authentication,0:none,1:MD5, 2:SHA1,3:None
#define CSID_C_IPSEC_DYNA_TUN_IKE_P1_PROP_2_GROUP		_CFG_VPN(0x9A00) //T=u32, D=0,Proposal(2) Group,0:none,1:Group1,2:Group2,3:Group5

//IKE Phase2 proposal	0xAA00~0xBFFF
#define CSID_C_IPSEC_DYNA_TUN_IKE_P2_KEYLIFE_SEC		_CFG_VPN(0xA000) //T=u32, D=0,Phase2 key life Time(Sec),0:default
#define CSID_C_IPSEC_DYNA_TUN_IKE_P2_KEYLIFE_BYTE		_CFG_VPN(0xA100) //T=u32, D=0,Phase2 key life Time(Byte),0:default
#define CSID_C_IPSEC_DYNA_TUN_IKE_P2_PROP_EN			_CFG_VPN(0xA200) //T=u32, D=0,Phase2 Proposal,0:Disable,1:Enable
#define CSID_C_IPSEC_DYNA_TUN_IKE_P2_PROP_1_EN			_CFG_VPN(0xA300) //T=u32, D=0,Proposal(1),0:Disable,1:Enable
#define CSID_C_IPSEC_DYNA_TUN_IKE_P2_PROP_1_ENC			_CFG_VPN(0xA400) //T=u32, D=0,Proposal(1) Encryption,0:none,1:DES,2:3DES,3:AES-128,4:AES-192,5:AES-256,6:Null
#define CSID_C_IPSEC_DYNA_TUN_IKE_P2_PROP_1_AUTH		_CFG_VPN(0xA500) //T=u32, D=0,Proposal(1) Authentication,0:none,1:MD5, 2:SHA1,3.None
#define CSID_C_IPSEC_DYNA_TUN_IKE_P2_PROP_2_EN			_CFG_VPN(0xA600) //T=u32, D=0,Proposal(2),0:Disable,1:Enable
#define CSID_C_IPSEC_DYNA_TUN_IKE_P2_PROP_2_ENC			_CFG_VPN(0xA700) //T=u32, D=0,Proposal(2) Encryption,0:none,1:DES,2:3DES,3:AES-128,4:AES-192,5:AES-256,6:Null
#define CSID_C_IPSEC_DYNA_TUN_IKE_P2_PROP_2_AUTH		_CFG_VPN(0xA800) //T=u32, D=0,Proposal(2) Authentication,0:none,1:MD5, 2:SHA1,3.None
//#define CSID_S_IPSEC_TUNNEL_ALTERED						_STA_VPN(0x0003) //T=u8, ui altered

#endif //ifndef _CSID_VPN_H






