/*
 * @file Member ID Definition of Group VoIP Phone Book
 *
 * Moderator: Terence Yang
 * Group ID: 0x002d0000/0x802d0000
 */

#ifndef _CSID_VOIPPB_H
#define _CSID_VOIPPB_H

#include "csid_gid.h"

#define _CFG_VOIPPB(x)		(CSID_GIDC_VOIPPB|(x))
#define _STA_VOIPPB(x)		(CSID_GIDS_VOIPPB|(x))

/* Extra Definitions */

#define SDDigit_None                0x00
#define SDDigit_1                   0x01
#define SDDigit_2                   0x02
#define SDDigit_3                   0x03
#define SDDigit_4                   0x04
#define SDDigit_5                   0x05
#define SDDigit_6                   0x06
#define SDDigit_7                   0x07
#define SDDigit_8                   0x08
#define SDDigit_9                   0x09
#define SDDigit_0                   0x0a

/* Configuration Items */

// Phone Book 
#define CSID_C_VOIPPB_SDDigit         _CFG_VOIPPB(0x0001)	//T=u8, SpeedDial Digit 
#define CSID_C_VOIPPB_PhoneURI_USER   _CFG_VOIPPB(0x0011)	//T=str, Phone URI 
#define CSID_C_VOIPPB_PhoneURI_ADDR   _CFG_VOIPPB(0x0021)	//T=ipv4
#define CSID_C_VOIPPB_PhoneURI_Note   _CFG_VOIPPB(0x0031)	//T=str, Note

/* Status Items */

/* Multisession Items (start fromn 0x2000) */

#endif //ifndef _CSID_VOIPPB_H
