/*
 * @file Member ID Definition of Group VoIP FXS port setting
 *
 * Moderator: Terence Yang
 * Group ID: 0x00280000/0x80280000
 */

#ifndef _CSID_VOIPFXS_H
#define _CSID_VOIPFXS_H

#include "csid_gid.h"

#define _CFG_VOIPFXS(x)		(CSID_GIDC_VOIPFXS|(x))
#define _STA_VOIPFXS(x)		(CSID_GIDS_VOIPFXS|(x))

/* Extra Definitions */

#define Display_Before_Ring         0x00
#define Display_After_Ring          0x01

#define ID_Type_Disabled            0x00 
#define ID_Type_DTMF                0x01
#define ID_Type_FSK_Bellcore        0x02
#define ID_Type_FSK_ETSI            0x03
#define ID_Type_Japan_CLIP          0x04
#define ID_Type_Japan_JCLIP         0x05
#define ID_Type_BT                  0x06
#define ID_Type_Brazil_DTMF         0x07

#define ID_Alert_No_Alert           0x00
#define ID_Alert_DTAS               0x01
#define ID_Alert_RPAS               0x02
#define ID_Alert_LR                 0x03
#define ID_Alert_LR-DTAS            0x04

#define DIAL_Both                   0x00
#define DIAL_DTMF                   0x01
#define DIAL_PULSE                  0x02

#define Ring_Imp_600ohm             0x00
#define Ring_Imp_900ohm             0x01
#define Ring_Imp_600ohm_1uF         0x02	//Japan (600ohm+1uF) 
#define Ring_Imp_900ohm_216uF       0x03	//900ohm+2.16uF
#define Ring_Imp_270ohm_120nF       0x04	//CTR21 (270ohm+750ohm||120nF)
#define Ring_Imp_220ohm_120uF       0x05	//Australia/New Zealand(220ohm+820ohm||120nF)
#define Ring_Imp_220ohm_115uF       0x06	//Slovakia/Slovenia/South Africa (220ohm+820ohm||115nF)
#define Ring_Imp_200ohm_100nF       0x07	//China (200ohm+600ohm||100nF)

/* Configuration Items */

// FXS Port Setting  
#define CSID_C_VOIPFXS_ID_Type         _CFG_VOIPFXS(0x0010)	//T=u8, D=3, Caller ID Type
#define CSID_C_VOIPFXS_ID_Type2        _CFG_VOIPFXS(0x0020)	//T=u8, D=3, Caller ID Type 2
#define CSID_C_VOIPFXS_ID_Power        _CFG_VOIPFXS(0x0030)	//T=u8, D=10, Caller ID Power Level   dbm. (0..20, default:10) 
#define CSID_C_VOIPFXS_ID_Display      _CFG_VOIPFXS(0x0040)	//T=u8, D=0, Caller ID Display
#define CSID_C_VOIPFXS_ID_Alert        _CFG_VOIPFXS(0x0050)	//T=u8, D=1, Caller ID Type 1 Alerting Signal
#define CSID_C_VOIPFXS_ID_Alert2       _CFG_VOIPFXS(0x0060)	//T=u8, D=1, Caller ID Type 2 Alerting Signal
#define CSID_C_VOIPFXS_ID_RepFlag      _CFG_VOIPFXS(0x0070)	//T=u8, D=0, Caller ID Replacement Flag  0:Dis 1:Enabl
#define CSID_C_VOIPFXS_ID_RepPre       _CFG_VOIPFXS(0x0080)	//T=str, Caller ID Replacement Prefix   Replace when caller id length greater than 7  
#define CSID_C_VOIPFXS_ID_RepStr       _CFG_VOIPFXS(0x0090)	//T=str, Caller ID Replacement String   

// Line 0 (FXS 0) 
#define CSID_C_VOIPFXS_DIAL            _CFG_VOIPFXS(0x0100)	//T=u8, D=1, Dial Method
#define CSID_C_VOIPFXS_Ring_Imp        _CFG_VOIPFXS(0x0110)	//T=u8, D=0, Ring Impedance
#define CSID_C_VOIPFXS_HFD_Upper       _CFG_VOIPFXS(0x0120)	//T=u16, D=600, Hook Flash Detect Upper Bound  msec. (100..3000) 
#define CSID_C_VOIPFXS_HFD_Lower       _CFG_VOIPFXS(0x0130)	//T=u16, D=100, Hook Flash Detect Lower Bound  msec. (100..3000) 
#define CSID_C_VOIPFXS_TX_Level        _CFG_VOIPFXS(0x0140)	//T=u8, D=6, Voice Tx Level   1 2 3 4 5 6 7 8 (default:6) 
#define CSID_C_VOIPFXS_RX_Level        _CFG_VOIPFXS(0x0140)	//T=u8, D=6, Voice Rx Level   1 2 3 4 5 6 7 8 (default:6) 

/* Status Items */

/* Multisession Items (start fromn 0x2000) */

#endif //ifndef _CSID_VOIPFXS_H
