/*
 * @file Member ID Definition of Group VoIP Call Service
 *
 * Moderator: Terence Yang
 * Group ID: 0x00270000/0x80270000
 */

#ifndef _CSID_VOIPCSERV_H
#define _CSID_VOIPCSERV_H

#include "csid_gid.h"

#define _CFG_VOIPCSERV(x)		(CSID_GIDC_VOIPCSERV|(x))
#define _STA_VOIPCSERV(x)		(CSID_GIDS_VOIPCSERV|(x))

/* Extra Definitions */


/* Configuration Items */

// Call Service
#define CSID_C_VOIPCSERV_WAIT            _CFG_VOIPCSERV(0x0001)	//T=u8, D=1, Call Waiting, 0:Disable 1:Enable
#define CSID_C_VOIPCSERV_WAIT_TO         _CFG_VOIPCSERV(0x0002)	//T=u8, D=30, Call Waiting Timeout (10..300, unlimit:300)
#define CSID_C_VOIPCSERV_REPEAT_TIME     _CFG_VOIPCSERV(0x0003)	//T=u16, D=1800, Call Repeat Activity Time (60..3600)

// Lines
// Line (FXS 0) 
#define CSID_C_VOIPCSERV_FXS_TRANS       _CFG_VOIPCSERV(0x0010)	//T=u8, D=1, Call Transfer Option, 0:Restricted 1:Allowed
#define CSID_C_VOIPCSERV_FXS_FOR         _CFG_VOIPCSERV(0x0020)	//T=u8, D=1, Call Forward Option, 0:Restricted 1:Allowed
#define CSID_C_VOIPCSERV_FXS_FOR_AUS     _CFG_VOIPCSERV(0x0030)	//T=str, Call Forward Always URI  SIP: @
#define CSID_C_VOIPCSERV_FXS_FOR_AIP     _CFG_VOIPCSERV(0x0040)	//T=ipv4, Call Forward Always URI
#define CSID_C_VOIPCSERV_FXS_FOR_BUS     _CFG_VOIPCSERV(0x0050)	//T=str, Call Forward on Busy URI  SIP: @
#define CSID_C_VOIPCSERV_FXS_FOR_BIP     _CFG_VOIPCSERV(0x0060)	//T=ipv4, Call Forward on Busy
#define CSID_C_VOIPCSERV_FXS_FOR_NUS     _CFG_VOIPCSERV(0x0070)	//T=str, Call Forward on NoAnswer URI  SIP: @
#define CSID_C_VOIPCSERV_FXS_FOR_NIP     _CFG_VOIPCSERV(0x0080)	//T=ipv4, Call Forward on NoAnswer
#define CSID_C_VOIPCSERV_FXS_FOR_NTO     _CFG_VOIPCSERV(0x0090)	//T=u8, D=30, Call Forward on NoAnswer Timeout (1..300)
#define CSID_C_VOIPCSERV_FXS_DND         _CFG_VOIPCSERV(0x00a0)	//T=u8, D=0, Do Not disturb, 0:Disable 1:Enable
#define CSID_C_VOIPCSERV_FXS_AutoAns     _CFG_VOIPCSERV(0x00b0)	//T=u8, D=0, Auto Answer, 0:Disable 1:Enable
#define CSID_C_VOIPCSERV_FXS_AutoAnsTO   _CFG_VOIPCSERV(0x00c0)	//T=u8, Auto Answer Timeout (10..300)
#define CSID_C_VOIPCSERV_FXS_Hot         _CFG_VOIPCSERV(0x00b0)	//T=u8, D=0, Hot Line, 0:Disable 1:Enable
#define CSID_C_VOIPCSERV_FXS_HotUS       _CFG_VOIPCSERV(0x00d0)	//T=str, Hot Line URI SIP:@
#define CSID_C_VOIPCSERV_FXS_HotIP       _CFG_VOIPCSERV(0x00e0)	//T=ipv4, Hot Line URI
#define CSID_C_VOIPCSERV_FXS_Anony       _CFG_VOIPCSERV(0x00f0)	//T=u8, D=0, Anonymous Call, 0:Disable 1:Enable
#define CSID_C_VOIPCSERV_FXS_RejAnony    _CFG_VOIPCSERV(0x0100)	//T=u8, D=0, Reject Anonymous Call Coming, 0:Disable 1:Enable

// Line (FXO 0) 
#define CSID_C_VOIPCSERV_FXO_TRANS       _CFG_VOIPCSERV(0x0210)	//T=u8, D=1, Call Transfer Option, 0:Restricted 1:Allowed
#define CSID_C_VOIPCSERV_FXO_FOR         _CFG_VOIPCSERV(0x0220)	//T=u8, D=1, Call Forward Option, 0:Restricted 1:Allowed
#define CSID_C_VOIPCSERV_FXO_FOR_AUS     _CFG_VOIPCSERV(0x0230)	//T=str, Call Forward Always URI  SIP: @
#define CSID_C_VOIPCSERV_FXO_FOR_AIP     _CFG_VOIPCSERV(0x0240)	//T=ipv4, Call Forward Always URI
#define CSID_C_VOIPCSERV_FXO_FOR_BUS     _CFG_VOIPCSERV(0x0250)	//T=str, Call Forward on Busy URI  SIP: @
#define CSID_C_VOIPCSERV_FXO_FOR_BIP     _CFG_VOIPCSERV(0x0260)	//T=ipv4, Call Forward on Busy
#define CSID_C_VOIPCSERV_FXO_FOR_NUS     _CFG_VOIPCSERV(0x0270)	//T=str, Call Forward on NoAnswer URI  SIP: @
#define CSID_C_VOIPCSERV_FXO_FOR_NIP     _CFG_VOIPCSERV(0x0280)	//T=ipv4, Call Forward on NoAnswer
#define CSID_C_VOIPCSERV_FXO_FOR_NTO     _CFG_VOIPCSERV(0x0290)	//T=u8, D=30, Call Forward on NoAnswer Timeout (1..300)
#define CSID_C_VOIPCSERV_FXO_DND         _CFG_VOIPCSERV(0x02a0)	//T=u8, D=0, Do Not disturb, 0:Disable 1:Enable
#define CSID_C_VOIPCSERV_FXO_AutoAns     _CFG_VOIPCSERV(0x02b0)	//T=u8, D=0, Auto Answer, 0:Disable 1:Enable
#define CSID_C_VOIPCSERV_FXO_AutoAnsTO   _CFG_VOIPCSERV(0x02c0)	//T=u8, Auto Answer Timeout (10..300)
#define CSID_C_VOIPCSERV_FXO_Hot         _CFG_VOIPCSERV(0x02b0)	//T=u8, D=0, Hot Line, 0:Disable 1:Enable
#define CSID_C_VOIPCSERV_FXO_HotUS       _CFG_VOIPCSERV(0x02d0)	//T=str, Hot Line URI SIP:@
#define CSID_C_VOIPCSERV_FXO_HotIP       _CFG_VOIPCSERV(0x02e0)	//T=ipv4, Hot Line URI
#define CSID_C_VOIPCSERV_FXO_Anony       _CFG_VOIPCSERV(0x02f0)	//T=u8, D=0, Anonymous Call, 0:Disable 1:Enable
#define CSID_C_VOIPCSERV_FXO_RejAnony    _CFG_VOIPCSERV(0x0300)	//T=u8, D=0, Reject Anonymous Call Coming, 0:Disable 1:Enable

/* Status Items */

/* Multisession Items (start fromn 0x2000) */

#endif //ifndef _CSID_VOIPCSERV_H
