/* vi: set sw=4 ts=4: */
/*
 * @file Member ID Definition of Group TR069.
 *
 * Moderator: WumingWu
 * Group ID: 0x00300000/0x80300000
 */
 
#ifndef _CSID_TR069_H
#define _CSID_TR069_H

#include "csid_gid.h"

#define _CFG_TR069(x)		(CSID_GIDC_TR069|(x))
#define _STA_TR069(x)		(CSID_GIDS_TR069|(x))

/* Configuration Items */
#define CSID_C_TR069_ENABLE				_CFG_TR069(0x0001)	//T=u32, D=0, Disable TR-069
#define CSID_C_TR069_BOOTSTRAP			_CFG_TR069(0x0002)  //T=u32, D=1, if EventCode equal to BOOTSTRAP
#define CSID_C_TR069_ACSURL				_CFG_TR069(0x0005)	//T=str, ACS's URL
#define CSID_C_TR069_ACSUSER			_CFG_TR069(0x0006)	//T=str, ACS's UserName
#define CSID_C_TR069_ACSPASSWORD		_CFG_TR069(0x0007)	//T=str, ACS's Password


#define CSID_C_TR069_CPEPORT			_CFG_TR069(0x0011)	//T=u32, D=8099 ,CPE Connection Request Port
#define CSID_C_TR069_CPEUSER			_CFG_TR069(0x0012)	//T=str, CPE Connection Request UserName
#define CSID_C_TR069_CPEPASSWORD		_CFG_TR069(0x0013)	//T=str, CPE Connection Request Password
#define CSID_C_TR069_COMMANDKEY			_CFG_TR069(0x0014)	//T=str, Command Key


#define CSID_C_TR069_INFORM_ENABLE		_CFG_TR069(0x0020)	//T=u32, D=1, Enable PeriodicInform
#define CSID_C_TR069_INFORM_INTERVAL	_CFG_TR069(0x0021)	//T=u32, D=900, PeriodicInform Interval Time

#define CSID_C_TR069_MULTI_CONF			_CFG_TR069(0x0030)	//T=bin, the content of multi.conf

/* Reserved 0031 - 0050 for CSID_C_TR069_ATTRI_CONF */
#define CSID_C_TR069_ATTRI_CONF			_CFG_TR069(0x0031)	//T=bin, the content of attri.conf

/* Reserved 0100 - 0150 for CSID_C_TR069_DL_CONF */
#define CSID_C_TR069_DL_CONF			_CFG_TR069(0x0100)	//T=bin, the content of dl.conf


/* Status Items */
#define CSID_S_TR069_ALTERED		 	_STA_TR069(0x0001)	//T=u32, ui altered

/* Device Info */
#define CSID_S_TR069_DEVINFO_MANUFACTURER		_STA_TR069(0x0100)	//T=str, The manufacturer of the CPE
#define CSID_S_TR069_DEVINFO_MANUFACTUREROUI	_STA_TR069(0x0101)	//T=str, The manufacturerOUI
#define CSID_S_TR069_DEVINFO_MODELNAME			_STA_TR069(0x0102)	//T=str, Model Name
#define CSID_S_TR069_DEVINFO_DESCRIPT 			_STA_TR069(0x0103)	//T=str, Full description
#define CSID_S_TR069_DEVINFO_PRODUCTCLASS		_STA_TR069(0x0104)	//T=str, Product Class
#define CSID_S_TR069_DEVINFO_SERIALNUM			_STA_TR069(0x0105)	//T=str, Serial Number
#define CSID_S_TR069_DEVINFO_HWVERSION			_STA_TR069(0x0106)	//T=str, Hardware Version
#define CSID_S_TR069_DEVINFO_SPECVERSION  		_STA_TR069(0x010C) 	//T=str, the version of the specification
#define CSID_S_TR069_DEVINFO_PROVISIONCODE		_STA_TR069(0x010D)	//T=str, 
#define CSID_S_TR069_DEVINFO_SWVERSION			_STA_TR069(0x010E)	//T=str, Software Version

/* Management Server */
#define CSID_S_TR069_MANAGESERVER_PARAMETERKEY			_STA_TR069(0x0110)	//T=str, Parameterkey


// Reserved 4 LAN Devices
#define CSID_S_TR069_LANDEV_LANEthIntNnmEntries 	_STA_TR069(0x0122)	//T=u32, 
#define CSID_S_TR069_LANDEV_LANUSBIntNumEntries		_STA_TR069(0x0126)	//T=u32,
#define CSID_S_TR069_LANDEV_WLANConfNumEntries		_STA_TR069(0x013A)	//T=u32,



// Reserved 4 WAN Devices 
#define CSID_S_TR069_WANDEV_WANConnectionNNumEntries	_STA_TR069(0x0200)	//T=u32, 

#define CSID_S_TR069_WANDEV_WANCommIntConf_WANAccessType	_STA_TR069(0x0208)	//T=str,



#endif //ifndef _CSID_TR069_H

