/*
   * @file Member ID Definition of Group  Telephony Service
   *
   * Moderator: JasonJiang
   * Group ID: 0x00800000/0x80800000
*/

#ifndef _CSID_TELEPHONY_H
#define _CSID_TELEPHONY_H

#include "csid_gid.h"

#define _CFG_TELEPHONY(x)       (CSID_GIDC_TELEPHONY|(x))
#define _STA_TELEPHONY(x)       (CSID_GIDS_TELEPHONY|(x))

//callerID type
#define CALLER_ID_FSK_RING_PLUSE 1
#define CALLER_ID_DTMF 2
//special key
#define SPECIAL_KEY_PROMPT	1
#define SPECIAL_KEY_FLASH	2
#define SPECIAL_KEY_STAR	3

/* Configuration Items */
#define CSID_C_TELEPHONY_CALLER_ID        		_CFG_TELEPHONY(0x0001) //T=u8, callerID type 
#define CSID_C_TELEPHONY_DIALING_TIMEOUT        _CFG_TELEPHONY(0x0002) //T=u16, dialing timeout.
#define CSID_C_TELEPHONY_IMMEDIATE_DIALING		_CFG_TELEPHONY(0x0003) //T=u8, immidiate dialing, enable:1,diable:0 
#define CSID_C_TELEPHONY_CALL_LOG				_CFG_TELEPHONY(0x0004) //T=u8, call log. enable:1,diable:0
#define CSID_C_TELEPHONY_CALL_FORWARDING_ALL	_CFG_TELEPHONY(0x0005) //T=u8, enable:1 , diable:0
#define CSID_C_TELEPHONY_CALL_FORWARDING_NOANS	_CFG_TELEPHONY(0x0006) //T=u8, enable:1 , diable:0
#define CSID_C_TELEPHONY_CALL_FORWARDING_UNREACHABLE  _CFG_TELEPHONY(0x0007) //T=u8, enable:1 , diable:0
#define CSID_C_TELEPHONY_CALL_FORWARDING_BUSY	_CFG_TELEPHONY(0x0008) //T=u8, enable:1 , diable:0
#define CSID_C_TELEPHONY_CALL_FORWARDING_ALL_NUM    _CFG_TELEPHONY(0x0009) //T=str, phone number
#define CSID_C_TELEPHONY_CALL_FORWARDING_NOANS_NUM  _CFG_TELEPHONY(0x000A) //T=str, phone number
#define CSID_C_TELEPHONY_CALL_FORWARDING_UNREACHABLE_NUM  _CFG_TELEPHONY(0x000B) //T=str, phone number
#define CSID_C_TELEPHONY_CALL_FORWARDING_BUSY_NUM   _CFG_TELEPHONY(0x000C) //T=str, phone number
#define CSID_C_TELEPHONY_CALL_WAITING_ENABLE	_CFG_TELEPHONY(0x000D) //T=u8, enable:1 , diable:0
#define CSID_C_TELEPHONY_CALL_WAITING_SPECIAL_KEY	_CFG_TELEPHONY(0x000E) //T=u8, the definition of special key. (*,#,flash)
#define CSID_C_TELEPHONY_CALL_LOG_CLEAN_OUTGOING	_CFG_TELEPHONY(0x000F) //T=u8, clean the outgoing call log
#define CSID_C_TELEPHONY_CALL_LOG_CLEAN_INCOMING	_CFG_TELEPHONY(0x0010) //T=u8, clean the incoming call log
#define CSID_C_TELEPHONY_CALL_LOG_CLEAN_MISSED		_CFG_TELEPHONY(0x0011) //T=u8, clean the missed call log
#define CSID_C_TELEPHONY_PHONE_SUPPORT              _CFG_TELEPHONY(0x0012) //T=u8, support/enable the telephony capability 

#define CSID_C_TELEPHONY_SPEED_DIAL_ENABLE			_CFG_TELEPHONY(0x0050) //T=u8, enable:1. disable:0
#define CSID_C_TELEPHONY_SPEED_DIAL_NUM				_CFG_TELEPHONY(0x0060) //T=str, number of speed dial.



#define CSID_C_TELEPHONY_CALL_LOG_OUTGOING_COUNT    _CFG_TELEPHONY(0x0080)  //T=u8, the count of outgoing call log
#define CSID_C_TELEPHONY_CALL_LOG_INCOMING_COUNT    _CFG_TELEPHONY(0x0081)  //T=u8, the count of incoming call log
#define CSID_C_TELEPHONY_CALL_LOG_MISSED_COUNT      _CFG_TELEPHONY(0x0082)  //T=u8, the count of missed call log

#define CSID_C_TELEPHONY_CALL_LOG_OUTGOING_TABLE_START  _CFG_TELEPHONY(0x0090)  ///T=u8, the start address of outgoing call log
#define CSID_C_TELEPHONY_CALL_LOG_INCOMING_TABLE_START  _CFG_TELEPHONY(0x0091)  ///T=u8, the start address of incoming call log
#define CSID_C_TELEPHONY_CALL_LOG_MISSED_TABLE_START    _CFG_TELEPHONY(0x0092)  ///T=u8, the start address of missed call log

#define CSID_C_TELEPHONY_OUTGOING_CALL_NUM      _CFG_TELEPHONY(0x100)   //T=str, phone number of this outgoing call
#define CSID_C_TELEPHONY_OUTGOING_CALL_ST       _CFG_TELEPHONY(0x200)   //T=str, start time of this call
#define CSID_C_TELEPHONY_OUTGOING_CALL_ET       _CFG_TELEPHONY(0x300)   //T=str, end time of this call
#define CSID_C_TELEPHONY_OUTGOING_CALL_DURATION     _CFG_TELEPHONY(0x400)   //T=str, duration of this call

#define CSID_C_TELEPHONY_INCOMING_CALL_NUM      _CFG_TELEPHONY(0x500)   //T=str, phone number of this incoming call
#define CSID_C_TELEPHONY_INCOMING_CALL_ST       _CFG_TELEPHONY(0x600)   //T=str, start time of this call
#define CSID_C_TELEPHONY_INCOMING_CALL_ET       _CFG_TELEPHONY(0x700)   //T=str, end time of this call
#define CSID_C_TELEPHONY_INCOMING_CALL_DURATION     _CFG_TELEPHONY(0x800)   //T=str, duration of this call

#define CSID_C_TELEPHONY_MISSED_CALL_NUM        _CFG_TELEPHONY(0x900)   //T=str, phone number of this missed call
#define CSID_C_TELEPHONY_MISSED_CALL_TIME       _CFG_TELEPHONY(0xA00)   //T=str, the  time of this missed call arrival


/* Status Items */
#define CSID_S_TELEPHONY_ALTERED					_STA_TELEPHONY(0x0001)	//T=u8, telephony,except call fwd altered.
#define CSID_S_TELEPHONY_CALL_FWD_ALTERED			_STA_TELEPHONY(0x0002)	//T=u8, call forward page altered.
#define CSID_S_TELEPHONY_CF_ALL_STATUS				_STA_TELEPHONY(0x0003) 	//T=str, status of setting all call forwarding
#define CSID_S_TELEPHONY_CF_NOANS_STATUS			_STA_TELEPHONY(0x0004) 	//T=str, status of setting noanswer forwarding
#define CSID_S_TELEPHONY_CF_UNREACHABLE_STATUS		_STA_TELEPHONY(0x0005) 	//T=str, status of unreachable forwarding
#define CSID_S_TELEPHONY_CF_BUSY_STATUS				_STA_TELEPHONY(0x0006) 	//T=str, status of busy forwardin

#define CSID_S_TELEPHONY_CALL_LOG_OUTGOING_CLEAN	_STA_TELEPHONY(0x0010)	//T=u8, the to clean outgoing call log
#define CSID_S_TELEPHONY_CALL_LOG_INCOMING_CLEAN	_STA_TELEPHONY(0x0011)	//T=u8, the to clean  incoming call log
#define CSID_S_TELEPHONY_CALL_LOG_MISSED_CLEAN		_STA_TELEPHONY(0x0012)	//T=u8, the to clean missed call log
/*
#define CSID_S_TELEPHONY_CALL_LOG_OUTGOING_COUNT	_STA_TELEPHONY(0x0020)	//T=u8, the count of outgoing call log
#define CSID_S_TELEPHONY_CALL_LOG_INCOMING_COUNT	_STA_TELEPHONY(0x0021)	//T=u8, the count of incoming call log
#define CSID_S_TELEPHONY_CALL_LOG_MISSED_COUNT		_STA_TELEPHONY(0x0022)	//T=u8, the count of missed call log

#define CSID_S_TELEPHONY_CALL_LOG_OUTGOING_TABLE_START  _STA_TELEPHONY(0x0030)  ///T=u8, the start address of outgoing call log
#define CSID_S_TELEPHONY_CALL_LOG_INCOMING_TABLE_START  _STA_TELEPHONY(0x0031)  ///T=u8, the start address of incoming call log
#define CSID_S_TELEPHONY_CALL_LOG_MISSED_TABLE_START    _STA_TELEPHONY(0x0032)  ///T=u8, the start address of missed call log

#define CSID_S_TELEPHONY_OUTGOING_CALL_NUM		_STA_TELEPHONY(0x100)	//T=str, phone number of this outgoing call
#define CSID_S_TELEPHONY_OUTGOING_CALL_ST		_STA_TELEPHONY(0x200)	//T=str, start time of this call
#define CSID_S_TELEPHONY_OUTGOING_CALL_ET		_STA_TELEPHONY(0x300)	//T=str, end time of this call
#define CSID_S_TELEPHONY_OUTGOING_CALL_DURATION		_STA_TELEPHONY(0x400)	//T=str, duration of this call

#define CSID_S_TELEPHONY_INCOMING_CALL_NUM      _STA_TELEPHONY(0x500)   //T=str, phone number of this incoming call
#define CSID_S_TELEPHONY_INCOMING_CALL_ST       _STA_TELEPHONY(0x600)   //T=str, start time of this call
#define CSID_S_TELEPHONY_INCOMING_CALL_ET       _STA_TELEPHONY(0x700)   //T=str, end time of this call
#define CSID_S_TELEPHONY_INCOMING_CALL_DURATION     _STA_TELEPHONY(0x800)   //T=str, duration of this call

#define CSID_S_TELEPHONY_MISSED_CALL_NUM      	_STA_TELEPHONY(0x900)   //T=str, phone number of this missed call
#define CSID_S_TELEPHONY_MISSED_CALL_TIME       _STA_TELEPHONY(0xA00)   //T=str, the  time of this missed call arrival
*/

#endif

