/*
 * @file Member ID Definition of Group SYS.
 *
 * Moderator: WumingWu/RupertLi
 * Group ID: 0x80000000
 */

#ifndef _CSID_SYS_H
#define _CSID_SYS_H

#include "csid_gid.h"

#define _CFG_SYS(x)         (CSID_GIDC_SYS|(x))
#define _STA_SYS(x)         (CSID_GIDS_SYS|(x))

//AMIT default LAN IP and netmask (in byte order of host)
#define DEFAULT_AMIT_LAN_IP         0xC0A87BFE //192.168.123.254
#define DEFAULT_AMIT_LAN_NETMASK    0xFFFFFF00 //255.255.255.0

/* Status Items */

//==========================================================
// 0x0000~0x3FFF: Reserved.
//==========================================================

//==========================================================
// 0x4000~0x40FF: Section Address (please ref RDS/00018)
//==========================================================

#define CSID_S_SYS_SECTION_B        _STA_SYS(0x4001) //T=u32, The address of the B section
#define CSID_S_SYS_SECTION_P        _STA_SYS(0x4002) //T=u32, The address of the P section
#define CSID_S_SYS_SECTION_R        _STA_SYS(0x4003) //T=u32, The address of the R section
#define CSID_S_SYS_SECTION_A        _STA_SYS(0x4004) //T=u32, The address of the A section
#define CSID_S_SYS_SECTION_D        _STA_SYS(0x4005) //T=u32, The address of the D section
#define CSID_S_SYS_SECTION_E        _STA_SYS(0x4006) //T=u32, The address of the E section
#define CSID_S_SYS_SECTION_C        _STA_SYS(0x4007) //T=u32, The address of the C section
#define CSID_S_SYS_SECTION_F        _STA_SYS(0x4008) //T=u32, The address of the F section

#define CSID_S_SYS_SECTION_C_SIZE	_STA_SYS(0x40FF) //T=u32, D=65536, The size of the C section, Default 64k 

//==========================================================
// 0x4100~0x41FF: VIDI's CSID (maximum count is 256)
//==========================================================

#define CSID_S_SYS_VIDI_CSID        _STA_SYS(0x4100) //T=u32, Base CSID for VIDI CSIDs

//==========================================================
// 0x4200~0x42FF: System Information
//==========================================================

//items defined by SPO or FW engineers (permanent)
#define CSID_S_SYS_INFO_MASCOT      _STA_SYS(0x4200) //T=str, Codename of the project
#define CSID_S_SYS_INFO_FMID        _STA_SYS(0x4201) //T=u16, Family/Member ID
#define CSID_S_SYS_INFO_TP			_STA_SYS(0x4202) //T=u8, TARGET_PSERIES

//items defined by SPO or FW engineers (per each release)
#define CSID_S_SYS_INFO_FW_VER      _STA_SYS(0x4208) //T=str, firmware version (section A)
#define CSID_S_SYS_INFO_FW_REV      _STA_SYS(0x4209) //T=str, firmware source code revision (svn)
#define CSID_S_SYS_INFO_CSID_REV    _STA_SYS(0x420A) //T=str, firmware CSID revision (svn)
#define CSID_S_SYS_INFO_BOOT_VER    _STA_SYS(0x420B) //T=str, firmware boot version (section B)

//items defined by SPO or UI engineers (permanent)
#define CSID_S_SYS_INFO_ROM_ID      _STA_SYS(0x4210) //T=str, ID of ROM image

//items defined by SPO or UI engineers (per each release)
#define CSID_S_SYS_INFO_ECN_NO      _STA_SYS(0x4218) //T=str, ECN number
#define CSID_S_SYS_INFO_PV          _STA_SYS(0x4219) //T=u8, platform version

//items defined by customer (permanent)
#define CSID_S_SYS_INFO_MODEL_NAME  _STA_SYS(0x4220) //T=str, model name
#define CSID_S_SYS_INFO_EID_RULE    _STA_SYS(0x4221) //T=u16, rule to apply Ether ID
#define CSID_S_SYS_INFO_DEFAULT_IP  _STA_SYS(0x4222) //T=ipv4, default IP address

//items defined by customer (per each release)
#define CSID_S_SYS_INFO_UI_VER      _STA_SYS(0x4228) //T=str, UI version (section D)

//items defined by MP lines (per device)
#define CSID_S_SYS_INFO_BEID        _STA_SYS(0x4230) //T=mac, burn-in Ether ID

//UPNP items defined by customer 
#define CSID_S_SYS_UPNP_ICON_NAME          _STA_SYS(0x4231)   //T=str, define customer icon name
#define CSID_S_SYS_UPNP_MODEL_NAME         _STA_SYS(0x4232)   //T=str, define customer mode name
#define CSID_S_SYS_UPNP_MODEL_NUMBER       _STA_SYS(0x4233)   //T=str, define customer mode number
#define CSID_S_SYS_UPNP_MANUFACTURER       _STA_SYS(0x4234)   //T=str, define customer manufacturer
#define CSID_S_SYS_UPNP_DESCRIPTIONS       _STA_SYS(0x4235)   //T=str, define customer descriptions
#define CSID_S_SYS_UPNP_MANUFACTURER_URL   _STA_SYS(0x4236)   //T=str, define custormer manufacturer URL


//==========================================================
// Hardware Variation
//==========================================================
#define HW_VARIATION_PCBLAYER_4 0x00000000
#define HW_VARIATION_PCBLAYER_2 0x00000001

#define CSID_S_SYS_HW_VARIATION     _STA_SYS(0x4240) //T=u32, Hardware Variation

#define CSID_S_SYS_INFO_DRMNB        _STA_SYS(0x4250) //T=mac, burn-in Ether ID

//==========================================================
// 0xF000~0xF1FF:
//==========================================================

//#define CSID_S_SYS_PORT_COUNT_ETH   _STA_SYS(0xF101) //T=u8, count of Ethernet ports
//#define CSID_S_SYS_PORT_COUNT_WLAN  _STA_SYS(0xF102) //T=u8, count of WLAN ports
//#define CSID_S_SYS_PORT_COUNT_USB   _STA_SYS(0xF103) //T=u8, count of USB ports
//#define CSID_S_SYS_PORT_COUNT_PRN   _STA_SYS(0xF104) //T=u8, count of PRINT ports
//#define CSID_S_SYS_PORT_COUNT_COM   _STA_SYS(0xF105) //T=u8, count of COM ports

//==========================================================
// 0xF200~0xF2FF: Network Hardware Configuration
//==========================================================

#define CSID_S_SYS_LAN_INTERFACE_NUM	_STA_SYS(0xF200)	//T=u8, number of LAN interface
#define CSID_S_SYS_LAN0_INTERFACE		_STA_SYS(0xF201)	//T=str, name of LAN0 interface
#define CSID_S_SYS_WAN_INTERFACE_NUM	_STA_SYS(0xF230)	//T=u8, number of WAN interface
#define CSID_S_SYS_WAN0_INTERFACE		_STA_SYS(0xF231)	//T=str, name of WAN0 interface
#define CSID_S_SYS_WAN1_INTERFACE		_STA_SYS(0xF232)	//T=str, name of WAN1 interface

//==========================================================
// 0xF300~0xF3FF: Logic Interface Configuration
//==========================================================

#define CSID_S_SYS_IF_BR_NUM			_STA_SYS(0xF300)	//T=u8, number of Bridge interface
#define CSID_S_SYS_IF_BR0				_STA_SYS(0xF301)	//T=str, name of the BR0
#define CSID_S_SYS_IF_LAN_NUM			_STA_SYS(0xF330)	//T=u8, number of LAN interface
#define CSID_S_SYS_IF_LAN0				_STA_SYS(0xF331)	//T=str, name of LAN0 
#define CSID_S_SYS_IF_LAN0_MAC			_STA_SYS(0xF341)	//T=mac, MAC of LAN0
#define CSID_S_SYS_IF_WAN_NUM			_STA_SYS(0xF360)	//T=u8, number of WAN interface
#define CSID_S_SYS_IF_WAN0				_STA_SYS(0xF361)	//T=str, name of WAN0
#define CSID_S_SYS_IF_WAN1				_STA_SYS(0xF362)	//T=str, name of WAN1 
#define CSID_S_SYS_IF_WAN0_MAC			_STA_SYS(0xF371)	//T=mac, MAC of WAN0
#define CSID_S_SYS_IF_WAN1_MAC			_STA_SYS(0xF372)	//T=mac, MAC of WAN1
#define CSID_S_SYS_IF_WLAN_NUM			_STA_SYS(0xF390)	//T=u8, number of WLAN interface
#define CSID_S_SYS_IF_WLAN0				_STA_SYS(0xF391)	//T=str, name of WLAN0 
#define CSID_S_SYS_IF_WLAN0_MAC			_STA_SYS(0xF3A1)	//T=mac, MAC of WLAN0
#define CSID_S_SYS_IF_GLAN_NUM			_STA_SYS(0xF3C0)	//T=u8, number of GLAN interface
#define CSID_S_SYS_IF_GLAN0				_STA_SYS(0xF3C1)	//T=str, name of GLAN0 
#define CSID_S_SYS_IF_GLAN0_MAC			_STA_SYS(0xF3D1)	//T=mac, MAC of GLAN0 

//==========================================================
// 0xF400~0xF40F: System Memory Information
//==========================================================

#define CSID_S_SYS_MEM_TOTAL			_STA_SYS(0xF400)	//T=u32, System Total memory
#define CSID_S_SYS_MEM_USED				_STA_SYS(0xF401)	//T=u32, System Used memory
#define CSID_S_SYS_MEM_FREE				_STA_SYS(0xF402)	//T=u32, System Free memory


//==========================================================
// 0xF500~0xF50F: Wireless Hardward Information
//========================================================== 
#define CSID_S_SYS_WLAN_EEPROM			_STA_SYS(0xF500)	//T=bin, wireless EEPROM value (K power)


#endif //ifndef _CSID_SYS_H
