/*
 * @file Member ID Definition of STORAGE
 *
 * Moderator: Abby Yang
 * Group ID: 0x001f0000/0x801f0000
 */

#ifndef _CSID_STORAGE_H
#define _CSID_STORAGE_H

#include "csid_gid.h"

#define _CFG_STORAGE(x)		(CSID_GIDC_STORAGE|(x))
#define _STA_STORAGE(x)		(CSID_GIDS_STORAGE|(x))

/* Extra Definitions */
#define FTP_CODEPAGE_ARABIC864	0x00
#define FTP_CODEPAGE_GREEK737	0x01
#define FTP_CODEPAGE_KOREAN949	0x02
#define FTP_CODEPAGE_LATIN850	0x03
#define FTP_CODEPAGE_LATIN852	0x04
#define FTP_CODEPAGE_RUSSIAN866	0x05
#define FTP_CODEPAGE_SIMPLIFIED_CHINESE936	0x06
#define FTP_CODEPAGE_THAI					0x07
#define FTP_CODEPAGE_TRADITIONAL_CHINESE950	0x08
#define FTP_CODEPAGE_UNITED_STATE437		0x09
#define FTP_CODEPAGE_JAPANESE	0x0a
#define FTP_CODEPAGE_HEWBREW862	0x0b


/* Configuration Items */
#define CSID_C_STORAGE_DEVNUM		_CFG_STORAGE(0x0001) //T=u8, D=16, Device number
#define CSID_C_STORAGE_IPCAMNUM		_CFG_STORAGE(0x0002) //T=u8, D=16, IPCam number in each NVR

//Storage Setting
#define CSID_C_STORAGE_DEVICENAME	_CFG_STORAGE(0x0010) //T=str, D="", DeviceName
#define CSID_C_STORAGE_IP			_CFG_STORAGE(0x0020) //T=str, D="", IP
#define CSID_C_STORAGE_MAC			_CFG_STORAGE(0x0030) //T=str, D="", MAC
#define CSID_C_STORAGE_ID           _CFG_STORAGE(0x0040) //T=str, D="", ID
#define CSID_C_STORAGE_USR			_CFG_STORAGE(0x0050) //T=str, D="", Username
#define CSID_C_STORAGE_PWD			_CFG_STORAGE(0x0060) //T=str, D="", Password
#define CSID_C_STORAGE_ACTIVE		_CFG_STORAGE(0x0070) //T=str, D="", Active
#define CSID_C_STORAGE_CONFIRM		_CFG_STORAGE(0x0080) //T=u8, D=0, Storage confirm
#define CSID_C_STORAGE_AVAILABLE	_CFG_STORAGE(0x0090) //T=u8, D=1, Storage available
#define	CSID_C_STORAGE_FREENUM		_CFG_STORAGE(0x00a0) //T=u8, D=4, Free IPCam number
#define CSID_C_STORAGE_FC			_CFG_STORAGE(0x00c0) //T=u8, D=12, Storage File collector period
#define CSID_C_STORAGE_WIRELESS     _CFG_STORAGE(0x00d0) //T=u8, D=0, Storage wireless enable
#define CSID_C_STORAGE_HAVEWIRELESS _CFG_STORAGE(0x00e0) //T=u8, D=0, Storage wireless enable
#define CSID_C_STORAGE_MODELNUM	    _CFG_STORAGE(0x00f0) //T=str, D="", Model number

//Saved IPCam info of each Storage
#define CSID_C_STORAGE_N_SAVEDIPCAM_NAME	_CFG_STORAGE(0x0100) //T=str, D="", DeviceName
#define CSID_C_STORAGE_1_SAVEDIPCAM_NAME	_CFG_STORAGE(0x0110) //T=str, D="", DeviceName
#define CSID_C_STORAGE_2_SAVEDIPCAM_NAME	_CFG_STORAGE(0x0120) //T=str, D="", DeviceName
#define CSID_C_STORAGE_3_SAVEDIPCAM_NAME	_CFG_STORAGE(0x0130) //T=str, D="", DeviceName

//Samba Settings
#define CSID_C_STORAGE_SAMBA_HOSTNAME		_CFG_STORAGE(0x0200) //T=str, D="", Host Name
#define CSID_C_STORAGE_SAMBA_WORKGROUP		_CFG_STORAGE(0x0201) //T=str, D="", WorkGroup
#define CSID_C_STORAGE_SAMBA_SERVERCOMMENT	_CFG_STORAGE(0x0202) //T=str, D="", Server Comment

//FTPd Settings
#define CSID_C_STORAGE_FTP_ENABLE				_CFG_STORAGE(0x0210) //T=u32, D=1,disable=0,enable=1
#define CSID_C_STORAGE_FTP_PORT					_CFG_STORAGE(0x0211) //T=u32, D=21, ftp port.
#define CSID_C_STORAGE_FTP_MAX_CONNECTION		_CFG_STORAGE(0x0212) //T=u32, D=2,max connection per peer.
#define CSID_C_STORAGE_FTP_MAX_CLIENTS			_CFG_STORAGE(0x0213) //T=u32, D=5,max clients.
#define CSID_C_STORAGE_FTP_CLIENT_SUPPORT_UTF8	_CFG_STORAGE(0x0214) //T=u32, D=0, no=0,yes=1
#define CSID_C_STORAGE_FTP_CODEPAGE				_CFG_STORAGE(0x0215) //T=u32, D=0, codepage.

//Download state
#define CSID_C_STORAGE_DL_RUNNING_COUNT		_CFG_STORAGE(0x0231) //T=u8, D=0, running job counts
#define CSID_C_STORAGE_DL_WAITING_COUNT		_CFG_STORAGE(0x0232) //T=u8, D=0, waiting job counts
#define CSID_C_STORAGE_DL_SCHED_COUNT		_CFG_STORAGE(0x0233) //T=u8, D=0, schedule job counts
#define CSID_C_STORAGE_DL_LOG_COUNT			_CFG_STORAGE(0x0234) //T=u8, D=0, schedule job counts
#define CSID_C_STORAGE_DL_RUNNING_INFO		_CFG_STORAGE(0x0240) //T=str, D="", download parameter
#define CSID_C_STORAGE_DL_WAITING_INFO		_CFG_STORAGE(0x0250) //T=str, D="", download parameter
#define CSID_C_STORAGE_DL_SCHED_INFO		_CFG_STORAGE(0x0260) //T=str, D="", download parameter
#define CSID_C_STORAGE_DL_LOG				_CFG_STORAGE(0x0270) //T=str, D="", download parameter

//UPnP Settings
#define CSID_C_STORAGE_UPNPDB_REFRESH_TIME      _CFG_STORAGE(0x0280) //T=u8, D=0, UpnpDatabase regular refresh time

/* Status Items */

//HomeCom 1.0+ Register information
#define CSID_S_STORAGE_AGPINFO      _STA_STORAGE(0x0001) //T=u8,  D=1

#define CSID_S_STORAGE_REGNAME		_STA_STORAGE(0x0010) //T=str, D="", New NVR Name
#define CSID_S_STORAGE_REGIP		_STA_STORAGE(0x0020) //T=str, D="", New NVR IP
#define CSID_S_STORAGE_REGMAC		_STA_STORAGE(0x0030) //T=str, D="", New NVR MAC
#define CSID_S_STORAGE_REGCONFIRM	_STA_STORAGE(0x0040) //T=u8,  D=0
#define CSID_S_STORAGE_REGAVAILABLE	_STA_STORAGE(0x0050) //T=u8,  D=1
#define CSID_S_STORAGE_REGMODELNUM  _STA_STORAGE(0x0060) //T=str, D="", Device model number
#define CSID_S_STORAGE_REGINDEX		_STA_STORAGE(0x00a0) //T=u8,  D=-1, Status to Conf. area index
#define CSID_S_STORAGE_REGFAIL      _STA_STORAGE(0x00f0) //T=u8,  D=1

#define CSID_S_STORAGE_CAPACITY	    _STA_STORAGE(0x0110) //T=str, D="", NVR Capacity

//HomeCom 1.0+ Setting information
#define CSID_S_STORAGE_WIRELESSFAIL	_STA_STORAGE(0x0210) //T=u8, D=0, Wireless setting fail.
#define CSID_S_STORAGE_WIRELESSCHK	_STA_STORAGE(0x0220) //T=u8, D=0, Check wireless setting result.
#define CSID_S_STORAGE_WIRELESSCHANGE	_STA_STORAGE(0x0230) //T=u8, D=0, Wireless setting change.

//RT305CDS USB and BT status
//#define CSID_S_STORAGE_BT			_STA_STORAGE(0x0240) //T=u8, D=0, BT avail?.
#define CSID_S_STORAGE_USB			_STA_STORAGE(0x0240) //T=u8, D=0, USB avail? 1 avail,0 not avail
#define CSID_S_STORAGE_USB_FS		_STA_STORAGE(0x0241) //T=str, D="", USB disk file system type(N/A fat32 ntfs ext).

//Download Assistant Status
#define CSID_S_STORAGE_DL_TYPE		_STA_STORAGE(0x0250) //T=u8, D=0, download type ,HTTP FTP
#define CSID_S_STORAGE_DL_INFO		_STA_STORAGE(0x0251) //T=str, D="", download parameter dst url
#define CSID_S_STORAGE_DL_ALTERED	_STA_STORAGE(0x0252) //T=u8, D=0, download page UI changed ,
#define CSID_S_STORAGE_DL_ACTION_ALTERED	_STA_STORAGE(0x0253) //T=u8, D=0, download status UI changed ,
#define CSID_S_STORAGE_DL_ACTION_INFO	_STA_STORAGE(0x0254) //T=str, D="", download page UI changed ,

//Samba Status
#define CSID_S_STORAGE_SAMBA_ALTERED	_STA_STORAGE(0x0300) //T=u32, D=0, Samba Setting change alter.

//FTPd Status
#define CSID_S_STORAGE_FTP_ALTERED	_STA_STORAGE(0x0310) //T=u32, D=0, FTP Setting change alter.


//USB disk operation Status
#define CSID_S_STORAGE_DISK_CAPACITY		_STA_STORAGE(0x0320) //T=str, D="",capacity
#define CSID_S_STORAGE_DISK_ACT		_STA_STORAGE(0x0321) //T=u8, D=0, Act
#define CSID_S_STORAGE_DISK_PROGRESS		_STA_STORAGE(0x0322) //T=u8, D=0, Progress
#define CSID_S_STORAGE_DISK_FREE		_STA_STORAGE(0x0323) //T=str, D="", Progress
#define CSID_S_STORAGE_DISK_USED	_STA_STORAGE(0x0324) //T=str, D="", Progress
#define CSID_S_STORAGE_DISK_TOTAL		_STA_STORAGE(0x0325) //T=str, D="", Progress
#define CSID_S_STORAGE_DISK_IS_PROGRESS		_STA_STORAGE(0x0326) //T=u8, D=0, Act
#define CSID_S_STORAGE_DISK_ALTERED		_STA_STORAGE(0x0327) //T=u8, D=0, ui flag

#endif	//ifndef _CSID_STORAGE_H
