/*
 * @file Member ID Definition of Group SPAP.
 *
 * Moderator: JackChiang
 * Group ID: 0x00170000/0x80170000
 */

#ifndef _CSID_SPAP_H
#define _CSID_SPAP_H

#include "csid_gid.h"

#define _CFG_SPAP(x)			(CSID_GIDC_SPAP|(x))
#define _STA_SPAP(x)			(CSID_GIDS_SPAP|(x))

/* Configuration Items */
#define CSID_C_SPAP_ENABLE		_CFG_SPAP(0x0001) //T=u8, enable the rule , 1:yes 0:no
#define CSID_C_SPAP_TRIGGER_PORT	_CFG_SPAP(0x0011) //T=str, spap trigger port
#define CSID_C_SPAP_INCOMING_PORT       _CFG_SPAP(0x0021) //T=str, spap incoming port

/* Status Items */
#define CSID_S_SPAP_ALTERED		_STA_SPAP(0x0001)	//T=u8, ui altered

#endif //ifndef _CSID_SPAP_H
