/*
 * @file Member ID Definition of Group SNMP.
 *
 * Moderator: JackChiang
 * Group ID: 0x00160000/0x80160000
 */

#ifndef _CSID_SNMP_H
#define _CSID_SNMP_H

#include "csid_gid.h"

#define _CFG_SNMP(x)		(CSID_GIDC_SNMP|(x))
#define _STA_SNMP(x)		(CSID_GIDS_SNMP|(x))

/* Configuration Items */
#define CSID_C_SNMP_LOCAL_ENABLE	_CFG_SNMP(0x0001) //T=u8, enable local snmp , 1:yes 0:no
#define CSID_C_SNMP_REMOTE_ENABLE       _CFG_SNMP(0x0002) //T=u8, enable remote snmp , 1:yes 0:no
#define CSID_C_SNMP_GET_COMMUNITY   	_CFG_SNMP(0x0003) //T=str, snmp community in get query
#define CSID_C_SNMP_SET_COMMUNITY   	_CFG_SNMP(0x0004) //T=str, snmp community in set action
#define CSID_C_SNMP_TRIP_IP	    	_CFG_SNMP(0x0005) //T=str, snmp send trip message to which ip 
#define CSID_C_SNMP_VERSION        	_CFG_SNMP(0x0009) //T=u8, snmp version of community
#define CSID_C_SNMP_SYSLOCATION		_CFG_SNMP(0x000a) //T=str, router's information in syslocation
#define CSID_C_SNMP_SYSCONTACT		_CFG_SNMP(0x000b) //T=str, router's information in syscontact
#define CSID_C_SNMP_SYSNAME		_CFG_SNMP(0x000c) //T=str, router's information in sysname
#define CSID_C_SNMP_WAN_ACCESS_IP	_CFG_SNMP(0x000d) //T=str, wan access IP address 

/* Status Items */
#define CSID_S_SNMP_ALTERED		_STA_SNMP(0x0001) //T=u8, ui altered

#endif //ifndef _CSID_SNMP_H
