/*
 * @file Member ID Definition of Group SIP Server Setting
 *
 * Moderator: Terence Yang
 * Group ID: 0x00230000/0x80230000
 */

#ifndef _CSID_SIPSERV_H
#define _CSID_SIPSERV_H

#include "csid_gid.h"

#define _CFG_SIPSERV(x)		(CSID_GIDC_SIPSERV|(x))
#define _STA_SIPSERV(x)		(CSID_GIDS_SIPSERV|(x))

/* Extra Definitions */

/* Configuration Items */

// Server Setting 
#define CSID_C_SIPSERV_AUTH_EX         _CFG_SIPSERV(0x0001)	//T=u16, D=3600, Authentication Expired Time (60..65535) 
#define CSID_C_SIPSERV_AUTH_EXP        _CFG_SIPSERV(0x0002)	//T=u8, D=50, Authentication Expired Time Percentage (50% ~ 90%) 

// Lines 
// Line 0 (FXS)
#define CSID_C_SIPSERV_FXS_DOMAIN      _CFG_SIPSERV(0x0010)	//T=str, Domain Name  
#define CSID_C_SIPSERV_FXS_REG_ADDR    _CFG_SIPSERV(0x0020)	//T=ipv4, D={10.20.0.13}, Registrar Server Address  
#define CSID_C_SIPSERV_FXS_REG_PORT    _CFG_SIPSERV(0x0030)	//T=u16, D=5060, Registrar Server Port (1-65535) 
#define CSID_C_SIPSERV_FXS_PRO_ADDR    _CFG_SIPSERV(0x0040)	//T=ipv4, D={10.20.0.13}, Proxy Address  
#define CSID_C_SIPSERV_FXS_PRO_PORT    _CFG_SIPSERV(0x0050)	//T=u16, Proxy Port (1-65535) 
#define CSID_C_SIPSERV_FXS_OPR         _CFG_SIPSERV(0x0060)	//T=u8, D=0, Use Outbound Proxy, 0:dis 1:Enable  
#define CSID_C_SIPSERV_FXS_OPR_ADDR    _CFG_SIPSERV(0x0070)	//T=ipv4, D={10.20.0.13}, Outbound Proxy Address  
#define CSID_C_SIPSERV_FXS_OPR_PORT    _CFG_SIPSERV(0x0080)	//T=u16, D=5060, Outbound Proxy Port (1-65535) 
#define CSID_C_SIPSERV_FXS_DNSSRV      _CFG_SIPSERV(0x0090)	//T=u8, D=0, DNS SRV support, 0:dis 1:Enable  
#define CSID_C_SIPSERV_FXS_STATUS      _CFG_SIPSERV(0x00a0)	//T=u8, registed status, 0:unrgisted 1:registed  
#define CSID_C_SIPSERV_FXS2_DOMAIN     _CFG_SIPSERV(0x0110)	//T=str, Domain Name  
#define CSID_C_SIPSERV_FXS2_PRO_ADDR   _CFG_SIPSERV(0x0120)	//T=ipv4, D={10.20.0.13}, Proxy Address  
#define CSID_C_SIPSERV_FXS2_OPR_ADDR   _CFG_SIPSERV(0x0130)	//T=ipv4, D={10.20.0.13}, Outbound Proxy Address  
#define CSID_C_SIPSERV_FXS2_STATUS     _CFG_SIPSERV(0x0140)	//T=u8, registed status, 0:unrgisted 1:registed  
	 
// Line 1 (FXO) 
#define CSID_C_SIPSERV_FXO_DOMAIN      _CFG_SIPSERV(0x0210)	//T=str, Domain Name  
#define CSID_C_SIPSERV_FXO_REG_ADDR    _CFG_SIPSERV(0x0220)	//T=ipv4, D={10.20.0.13}, Registrar Server Address  
#define CSID_C_SIPSERV_FXO_REG_PORT    _CFG_SIPSERV(0x0230)	//T=u16, D=5060, Registrar Server Port (1-65535) 
#define CSID_C_SIPSERV_FXO_PRO_ADDR    _CFG_SIPSERV(0x0240)	//T=ipv4, D={10.20.0.13}, Proxy Address  
#define CSID_C_SIPSERV_FXO_PRO_PORT    _CFG_SIPSERV(0x0250)	//T=u16, D=5060, Proxy Port (1-65535) 
#define CSID_C_SIPSERV_FXO_OPR         _CFG_SIPSERV(0x0260)	//T=u8, D=0, Use Outbound Proxy, 0:dis 1:Enable  
#define CSID_C_SIPSERV_FXO_OPR_ADDR    _CFG_SIPSERV(0x0270)	//T=ipv4, D={10.20.0.13}, Outbound Proxy Address  
#define CSID_C_SIPSERV_FXO_OPR_PORT    _CFG_SIPSERV(0x0280)	//T=u16, D=5060, Outbound Proxy Port (1-65535)
#define CSID_C_SIPSERV_FXO_DNSSRV      _CFG_SIPSERV(0x0290)	//T=u8, D=0, DNS SRV support, 0:dis 1:Enable

/* Status Items */

/* Multisession Items (start fromn 0x2000) */

#endif //ifndef _CSID_SIPSERV_H
