/*
 * @file Member ID Definition of Group SIP Account
 *
 * Moderator: Terence Yang
 * Group ID: 0x00220000/0x80220000
 */

#ifndef _CSID_SIPACC_H
#define _CSID_SIPACC_H

#include "csid_gid.h"

#define _CFG_SIPACC(x)		(CSID_GIDC_SIPACC|(x))
#define _STA_SIPACC(x)		(CSID_GIDS_SIPACC|(x))

/* Extra Definitions */

/* Configuration Items */

// Table 1 FXS Setting

#define CSID_C_SIPACC_FXS_ACC           _CFG_SIPACC(0x0010)	//T=u8, D=1, Account, 0:Disable 1:Enable 
#define CSID_C_SIPACC_FXS_USER          _CFG_SIPACC(0x0020)	//T=str, D="2300", User Name
#define CSID_C_SIPACC_FXS_NAME          _CFG_SIPACC(0x0030)	//T=str, D="2300", Display Name   
#define CSID_C_SIPACC_FXS_AUTH          _CFG_SIPACC(0x0040)	//T=str, D="2300", Authentication User Name   
#define CSID_C_SIPACC_FXS_PASS          _CFG_SIPACC(0x0050)	//T=str, D="2300", Authentication Password  
#define CSID_C_SIPACC_FXS_PASSC         _CFG_SIPACC(0x0060)	//T=str, D="2300", Confirmed Password  
#define CSID_C_SIPACC_FXS_MWI           _CFG_SIPACC(0x0070)	//T=u8, D=0, MWI Subscribe, 0: Disable 1:Enable 
#define CSID_C_SIPACC_FXS_MWI_USER      _CFG_SIPACC(0x0080)	//T=str, MWI User Name   
#define CSID_C_SIPACC_FXS_MWI_AUTH      _CFG_SIPACC(0x0090)	//T=str, MWI Authentication User Name   
#define CSID_C_SIPACC_FXS_MWI_PASS      _CFG_SIPACC(0x00a0)	//T=str, MWI Authentication Password  
#define CSID_C_SIPACC_FXS_MWI_PASSC     _CFG_SIPACC(0x00b0)	//T=str, MWI Confirmed Password  
#define CSID_C_SIPACC_FXS_MWI_TIME      _CFG_SIPACC(0x00c0)	//T=u16, D=3600, MWI Refresh Timeout 
#define CSID_C_SIPACC_FXS_PA            _CFG_SIPACC(0x00d0)	//T=u8, D=0, P-Asserted, 0:Disable 1:Enable
#define CSID_C_SIPACC_FXS_PA_USER       _CFG_SIPACC(0x00e0)	//T=str, D="2300", Asserted Identity Username   
#define CSID_C_SIPACC_FXS_PA_NAME       _CFG_SIPACC(0x00f0)	//T=str, D="2300", Asserted Identity Displayname   
#define CSID_C_SIPACC_FXS2_ACC          _CFG_SIPACC(0x0110)	//T=u8, D=1, Account, 0:Disable 1:Enable 
#define CSID_C_SIPACC_FXS2_USER         _CFG_SIPACC(0x0120)	//T=str, D="2300", User Name
#define CSID_C_SIPACC_FXS2_NAME         _CFG_SIPACC(0x0130)	//T=str, D="2300", Display Name   
#define CSID_C_SIPACC_FXS2_AUTH         _CFG_SIPACC(0x0140)	//T=str, D="2300", Authentication User Name   
#define CSID_C_SIPACC_FXS2_PASS         _CFG_SIPACC(0x0150)	//T=str, D="2300", Authentication Password  

// Table 2 FXO Setting

#define CSID_C_SIPACC_FXO_ACC           _CFG_SIPACC(0x0210)	//T=u8, D=1, Account, 0:Disable 1:Enable
#define CSID_C_SIPACC_FXO_USER          _CFG_SIPACC(0x0220)	//T=str, D="2301", User Name
#define CSID_C_SIPACC_FXO_NAME          _CFG_SIPACC(0x0230)	//T=str, D="2301", Display Name
#define CSID_C_SIPACC_FXO_AUTH          _CFG_SIPACC(0x0240)	//T=str, D="2301", Authentication User Name
#define CSID_C_SIPACC_FXO_PASS          _CFG_SIPACC(0x0250)	//T=str, D="2301", Authentication Password
#define CSID_C_SIPACC_FXO_PASSC         _CFG_SIPACC(0x0260)	//T=str, D="2301", Confirmed Password
#define CSID_C_SIPACC_FXO_MWI           _CFG_SIPACC(0x0270)	//T=u8, D=0, MWI Subscribe, 0: Disable 1:Enable
#define CSID_C_SIPACC_FXO_MWI_USER      _CFG_SIPACC(0x0280)	//T=str, MWI User Name
#define CSID_C_SIPACC_FXO_MWI_AUTH      _CFG_SIPACC(0x0290)	//T=str, MWI Authentication User Name
#define CSID_C_SIPACC_FXO_MWI_PASS      _CFG_SIPACC(0x02a0)	//T=str, MWI Authentication Password
#define CSID_C_SIPACC_FXO_MWI_PASSC     _CFG_SIPACC(0x02b0)	//T=str, MWI Confirmed Password
#define CSID_C_SIPACC_FXO_MWI_TIME      _CFG_SIPACC(0x02c0)	//T=u16, D=3600, MWI Refresh Timeout
#define CSID_C_SIPACC_FXO_PA            _CFG_SIPACC(0x02d0)	//T=u8, D=0, P-Asserted, 0:Disable 1:Enable
#define CSID_C_SIPACC_FXO_PA_USER       _CFG_SIPACC(0x02e0)	//T=str, D="2301", Asserted Identity Username
#define CSID_C_SIPACC_FXO_PA_NAME       _CFG_SIPACC(0x02f0)	//T=str, D="2301", Asserted Identity Displayname

/* Status Items */

/* Multisession Items (start fromn 0x2000) */

#endif //ifndef _CSID_SIPACC_H
