/*
 * @file Member ID Definition of Group SENDMAIL.
 *
 * Moderator: GeorgeWang
 * Group ID: 0x00080000/0x80080000
 */  

#ifndef _CSID_SENDMAIL_H
#define _CSID_SENDMAIL_H

#include "csid_gid.h"

#define _CFG_SENDMAIL(x)		(CSID_GIDC_SENDMAIL|(x))
#define _STA_SENDMAIL(x)		(CSID_GIDS_SENDMAIL|(x))

/* Configuration Items */ 

#define CSID_C_SENDMAIL_ENABLE				_CFG_SENDMAIL(0x0001)	//T=u8, enable/disable
#define CSID_C_SENDMAIL_PORT				_CFG_SENDMAIL(0x0002)	//T=u16, service port
#define CSID_C_SENDMAIL_SERVER  			_CFG_SENDMAIL(0x0003)	//T=str, mail server
#define CSID_C_SENDMAIL_RECEIVER			_CFG_SENDMAIL(0x0004)	//T=str, mail receiver
#define CSID_C_SENDMAIL_SUBJECT 		   	_CFG_SENDMAIL(0x0005)	//T=str, mail subject
#define CSID_C_SENDMAIL_USER     			_CFG_SENDMAIL(0x0006)	//T=str, authenticating user 
#define CSID_C_SENDMAIL_PASSWORD    		_CFG_SENDMAIL(0x0007)	//T=str, authenticating password


#define CSID_C_SENDMAIL_EZGUARD_INTERVAL   	_CFG_SENDMAIL(0x0008)	//T=u32, send_email_time_interval
#define CSID_C_SENDMAIL_EZGUARD_PORT		_CFG_SENDMAIL(0x0009)	//T=u16, service port
#define CSID_C_SENDMAIL_EZGUARD_SERVER  	_CFG_SENDMAIL(0x0010)	//T=str, mail server
#define CSID_C_SENDMAIL_EZGUARD_RECEIVER	_CFG_SENDMAIL(0x0011)	//T=str, mail receiver
#define CSID_C_SENDMAIL_EZGUARD_SUBJECT 	_CFG_SENDMAIL(0x0012)	//T=str, mail subject
#define CSID_C_SENDMAIL_EZGUARD_USER     	_CFG_SENDMAIL(0x0013)	//T=str, authenticating user 
#define CSID_C_SENDMAIL_EZGUARD_PASSWORD    _CFG_SENDMAIL(0x0014)	//T=str, authenticating password
#define CSID_C_SENDMAIL_EZGUARD_ENABLE		_CFG_SENDMAIL(0x0015)	//T=u8, enable/disable for ui

/* Status Items */ 
#define CSID_S_SENDMAIL_STATUS      		_STA_SENDMAIL(0x0001)	//T=u16, sendmail status
#define CSID_S_SENDMAIL_ALTERED			_STA_SENDMAIL(0x0002)	//T=u8, ui altered
#define CSID_S_SENDMAIL_SAVE_ALTERED_ENABLE	_STA_SENDMAIL(0x0003)	//Unused
#define CSID_S_SENDMAIL_SAVE_ALTERED		_STA_SENDMAIL(0x0004)	//T=u8, enable/disable for ui
#define CSID_S_SENDMAIL_SENDOK                  _STA_SENDMAIL(0x0005)   //T=u32, mailtool send ok or not

#endif //ifndef _CSID_SENDMAIL_H
