/*
 * @file Member ID Definition of RS232 Modem
 *
 * Moderator: Eric chen
 * Group ID: 0x00420000/0x80420000
 */

#ifndef _CSID_RS232_H
#define _CSID_RS232_H

#include "csid_gid.h"

#define _CFG_RS232(x)		(CSID_GIDC_RS232|(x))
#define _STA_RS232(x)		(CSID_GIDS_RS232|(x))

/* Extra Definitions */

#define CNT_TYPE_RS232_ONDEMAND				0x00
#define CNT_TYPE_RS232_AUTORECONNECT		0x01
#define CNT_TYPE_RS232_MANUAL				0x02

#define CNT_STATUS_RS232_DISCONNECT			0x00
#define CNT_STATUS_RS232_CONNECTING			0x01
#define CNT_STATUS_RS232_CONNECT			0x02
#define CNT_STATUS_RS232_DISCONNECTING		0x03
#define CNT_STATUS_RS232_WAIT_TRAFFIC		0x05
#define CNT_STATUS_RS232_AUTH_FAIL			0x06
#define CNT_STATUS_RS232_BACKUP				0x07
#define CNT_STATUS_RS232_NOT_INSCHEDULE		0x08

/*	//define in CSID_3G.h
#define ONDEMAND_STATUS_DISCONNECT_NO_IP	0x00
#define ONDEMAND_STATUS_CONNECT_NO_IP		0x01
#define ONDEMAND_STATUS_CONNECT_GET_IP		0x02
*/
#define AUTHTYPE_RS232_AUTO					0x00
#define AUTHTYPE_RS232_PAP					0x01
#define AUTHTYPE_RS232_CHAP					0x02

#define KEEP_ALIVE_RS232_DISABLE			0x00
#define KEEP_ALIVE_RS232_PING				0x01
#define KEEP_ALIVE_RS232_LCP				0x02

#define AUTOBAK_STATUS_RS232_DISCONNECT		0x00
#define AUTOBAK_STATUS_RS232_CONNECTING		0x01
#define AUTOBAK_STATUS_RS232_CONNECT		0x02
#define AUTOBAK_STATUS_RS232_DISCONNECTING	0x03

#define BAUDRATE_38400		0x00
#define BAUDRATE_57600		0x01
#define BAUDRATE_115200		0x02
#define BAUDRATE_230400		0x03
#define BAUDRATE_460800		0x04

/* Configuration Items */
#define CSID_C_RS232_MODEM_SUPPORT			_CFG_RS232(0x0001)	//T=u32, D=0, 0:Not support, 1: Serial Modem support

#define CSID_C_RS232_NUMBER					_CFG_RS232(0x0002)	//T=str, Dialed Number
#define CSID_C_RS232_USER					_CFG_RS232(0x0003)	//T=str, user name
#define CSID_C_RS232_PASSWORD				_CFG_RS232(0x0004)	//T=str, user password
#define CSID_C_RS232_IDLETIME				_CFG_RS232(0x0005)	//T=u32, max idle time
#define CSID_C_RS232_CNT_TYPE				_CFG_RS232(0x0006)	//T=u32, connect type, Dial-on-Demand, autoconnect...
#define CSID_C_RS232_BUADRATE				_CFG_RS232(0x0007)	//T=u32, D=1, 0:38400/1:57600/2:115200/3:230400/4:460800 bps
#define CSID_C_RS232_IF_IP					_CFG_RS232(0x0008)	//T=ipv4, static interface ip
#define CSID_C_RS232_IF_PRIDNS				_CFG_RS232(0x0009)	//T=ipv4, dynamic interface primary DNS
#define CSID_C_RS232_IF_SECDNS				_CFG_RS232(0x000A)	//T=ipv4, dynamic interface secondary DNS
#define CSID_C_RS232_EXTRA_SEETING			_CFG_RS232(0x000B)	//T=str, for customer extra modem AT command

#define CSID_C_RS232_SERVICENAME			_CFG_RS232(0x0010)	//T=str, service name
#define CSID_C_RS232_MTU					_CFG_RS232(0x0011)	//T=u32, D=0, max transmission unit
#define CSID_C_RS232_AUTOBAK_ENABLE			_CFG_RS232(0x0012)	//T=u32, auto backup enable, 0:disable, 1:enable
#define CSID_C_RS232_PING_HOST_IP			_CFG_RS232(0x0013)	//T=ipv4, ping host IP for 3g auto backup
#define CSID_C_RS232_AUTHTYPE				_CFG_RS232(0x0014)	//T=u32, auth type, Auto, PAP, CHAP...
#define CSID_C_RS232_KEEP_ALIVE				_CFG_RS232(0x0015)	//T=u32, 3g keep alive, disable, ping, lcp
#define CSID_C_RS232_KA_PING_INTERVAL		_CFG_RS232(0x0016)	//T=u32, D=60, ping interval for 3g keep alive
#define CSID_C_RS232_KA_PING_IP				_CFG_RS232(0x0017)	//T=ipv4, ping IP for 3g keep alive
#define CSID_C_RS232_KA_LCP_INTERVAL		_CFG_RS232(0x0018)	//T=u32, D=10, lcp interval for 3g keep alive 
#define CSID_C_RS232_KA_LCP_TIMES			_CFG_RS232(0x0019)	//T=u32, D=3, lcp times for 3g keep alive
#define CSID_C_RS232_NAT_DISABLE			_CFG_RS232(0x001A)	//T=u32, wantype NAT disable

/* Status Items */
#define CSID_S_RS232_ALTERED				_STA_RS232(0x0001)	//T=u32, ui altered
#define CSID_S_RS232_MODEM_STATUS			_STA_RS232(0x0002)	//T=u32, MODEM status 0:offline, 1:Ready.

#define CSID_S_RS232_CNT_TIME				_STA_RS232(0x0100)	//T=u32, connect time
#define CSID_S_RS232_IF_IP					_STA_RS232(0x0101)	//T=ipv4, dynamic interface ip
#define CSID_S_RS232_IF_NM					_STA_RS232(0x0102)	//T=ipv4, dynamic interface netmask
#define CSID_S_RS232_IF_GW					_STA_RS232(0x0103)	//T=ipv4, dynamic interface gateway
#define CSID_S_RS232_IF_PRIDNS				_STA_RS232(0x0104)	//T=ipv4, dynamic interface primary DNS
#define CSID_S_RS232_IF_SECDNS				_STA_RS232(0x0105)	//T=ipv4, dynamic interface secondary DNS
#define CSID_S_RS232_CNT_STATUS				_STA_RS232(0x0200)	//T=u16, connect status
#define CSID_S_RS232_ERR_CODE				_STA_RS232(0x0201)	//T=u16, connect fail error code
#define CSID_S_RS232_PKTIN_NUM				_STA_RS232(0x0300)	//T=u32, number of packet input
#define CSID_S_RS232_PKTOUT_NUM				_STA_RS232(0x0301)	//T=u32, number of packet output
#define CSID_S_RS232_ONDEMAND_STATUS		_STA_RS232(0x0400)	//T=u16, demend wan type status for script so it don't care for UI
#define CSID_S_RS232_AUTOBAK_STATUS			_STA_RS232(0x0500)	//T=u16, 3g failover status

/* for RS232 Failover ping check */
#define CSID_S_RS232_WAN_IP					_STA_RS232(0x1000) //T=ipv4, wan ip
#define CSID_S_RS232_WAN_GW					_STA_RS232(0x2100) //T=ipv4, wan gateway
#define CSID_S_RS232_WAN_IF_NAME			_STA_RS232(0x2200) //T=str, the interface name of wan, ppp0, eth1, ixp1

#endif //ifndef _CSID_RS232_H
