/*
 * @file Member ID Definition of ROUTING.
 *
 * Moderator: JasonJiang
 * Group ID: 0x00130000/0x80130000
 */

#ifndef _CSID_ROUTING_H
#define _CSID_ROUTING_H

#include "csid_gid.h"

#define _CFG_ROUTING(x)         (CSID_GIDC_ROUTING|(x))
#define _STA_ROUTING(x)         (CSID_GIDS_ROUTING|(x))

/* Extra Definitions */

#define ROUTING_DYNAMIC_DISABLE         0x00
#define ROUTING_DYNAMIC_RIP_V1          0x01
#define ROUTING_DYNAMIC_RIP_V2          0x02

#define MULTIROUTE_WAN_IDX				0xE0
#define MULTIROUTE_WAN1_IDX				0xE1


/* Configuration Items */
#define CSID_C_ROUTING_DYNAMIC_ENABLE		_CFG_ROUTING(0x0001)	//T=u8,  enable/disable dynamic routing
#define CSID_C_ROUTING_STATIC_ENABLE		_CFG_ROUTING(0x0002)	//T=u8,  enable/disable static routing 
#define CSID_C_MULTIROUTE_FAILCHG_ENABLE	_CFG_ROUTING(0x0003)	//T=u32, D=1, enable/disable multi-wan fail change

/* for Multi-WAN Multi-Routing Reserved 256 items*/
#define CSID_C_MULTIROUTE_ENABLE			_CFG_ROUTING(0x0100)	//T=u32, enable/disable multi routing rule
#define CSID_C_MULTIROUTE_PROTO				_CFG_ROUTING(0x0200)	//T=str, Null, TCP, UDP, ...
#define CSID_C_MULTIROUTE_WAN_IDX			_CFG_ROUTING(0x0300)	//T=u32, Wan Index, --set-mark WanIdx	
#define CSID_C_MULTIROUTE_SRCIP_START		_CFG_ROUTING(0x0400)	//T=ipv4, The Start source IP
#define CSID_C_MULTIROUTE_SRCIP_END			_CFG_ROUTING(0x0500)	//T=ipv4, The End source IP	
#define CSID_C_MULTIROUTE_DSTIP_START		_CFG_ROUTING(0x0600)	//T=ipv4, The Start destination IP	
#define CSID_C_MULTIROUTE_DSTIP_END			_CFG_ROUTING(0x0700)	//T=ipv4, The End destination IP
#define CSID_C_MULTIROUTE_DSTPORT_START		_CFG_ROUTING(0x0800)	//T=u32, The start destination PORT
#define CSID_C_MULTIROUTE_DSTPORT_END		_CFG_ROUTING(0x0900)	//T=u32, The end destination PORT
/* end */


#define CSID_C_ROUTING_STATIC_RULE_ENABLE	_CFG_ROUTING(0x1000)	//T=u8, rule enable, 1:yes 0:no
#define CSID_C_ROUTING_STATIC_DEST_IP		_CFG_ROUTING(0x2000)	//T=ipv4, destination ip
#define CSID_C_ROUTING_STATIC_SUB_MASK		_CFG_ROUTING(0x3000)	//T=ipv4, subnet mask
#define CSID_C_ROUTING_STATIC_GW_IP			_CFG_ROUTING(0x4000)	//T=ipv4, gateway ip
#define CSID_C_ROUTING_STATIC_HOP			_CFG_ROUTING(0X5000)	//T=u16, numbers of hop

/* Status Items */
#define CSID_S_ROUTING_STATIC_RULE_NUM		_STA_ROUTING(0x0001)	//T=u16, number of static routing rules
#define CSID_S_ROUTING_ALTERED				_STA_ROUTING(0x0002)	//T=u8, ui altered

#endif //ifndef _CSID_ROUTING_H
