/*
 * @file Member ID Definition of Group QoS.
 *
 * Moderator: JasonJiang
 * Group ID: 0x00120000/0x80120000
 */

#ifndef _CSID_QOS_H
#define _CSID_QOS_H

#include "csid_gid.h"


//for "CSID_C_QOS_L7_AP_NAME"
#define L7_AP_NAME_FTP 0
#define L7_AP_NAME_HTTP 1
#define L7_AP_NAME_EDONKEY 2
#define L7_AP_NAME_BITTORRENT 3
#define L7_AP_NAME_MSN MESSAENGER 4
#define L7_AP_NAME_BT 5
#define L3_TCP 6
#define L3_UDP 7
#define L3_ICMP 8

#define _CFG_QOS(x)         (CSID_GIDC_QOS|(x))
#define _STA_QOS(x)         (CSID_GIDS_QOS|(x))

/* Configuration Items */
#define CSID_C_QOS_ENABLE			_CFG_QOS(0x0001)	//T=u8, qos enable, 1:yes 0:no
#define CSID_C_QOS_UP_BANDWIDTH         	_CFG_QOS(0x0002)    	//T=u16, upstreaming bandwidth of wan port,unit is kbps
#define CSID_C_QOS_DW_BANDWIDTH         	_CFG_QOS(0x0003)    	//T=u16, downloading bandwidth of wan port,unit is kbps
#define CSID_C_QOS_DW_HI_BWH                    _CFG_QOS(0x0004)        //T=u16, bandwidth of downlink for users with high priority
#define CSID_C_QOS_DW_NO_BWH                    _CFG_QOS(0x0005)        //T=u16, bandwidth of downlink for users with normal priority
#define CSID_C_QOS_DW_LO_BWH                    _CFG_QOS(0x0006)        //T=u16, bandwidth of downlink for users with low priority
#define CSID_C_QOS_UP_HI_BWH                    _CFG_QOS(0x0007)        //T=u16, bandwidth of uplink for users with high priority
#define CSID_C_QOS_UP_NO_BWH                    _CFG_QOS(0x0008)        //T=u16, bandwidth of uplink for users with normal priority
#define CSID_C_QOS_UP_LO_BWH                    _CFG_QOS(0x0009)        //T=u16, bandwidth of uplink for users with low priority

#define CSID_C_QOS_LOCAL_IP			_CFG_QOS(0x1000)	//T=ipv4, local ip 
#define CSID_C_QOS_LOCAL_PORT			_CFG_QOS(0x2000)	//T=u16, local port 
#define CSID_C_QOS_REMOTE_IP			_CFG_QOS(0x3000)	//T=ipv4, remote ip
#define CSID_C_QOS_REMOTE_PORT			_CFG_QOS(0x4000)	//T=u16, remote port 
#define CSID_C_QOS_PRIORITY			_CFG_QOS(0x5000)	//T=u16, priority level, 1=HIGH, 2=NORMAL, 3=LOW, 4=user define by self.
#define CSID_C_QOS_RULE_ENABLE			_CFG_QOS(0x6000)	//T=u8, rule enable, 1:yes 0:no
#define CSID_C_QOS_USING_RULE			_CFG_QOS(0x7000)	//T=u16, rule number
#define CSID_C_QOS_DEV				_CFG_QOS(0x8000)	//T=str, name of the interface you want to control.

#define CSID_C_QOS_L7_UP_BANDWIDTH 		_CFG_QOS(0x9000)  	//T=u16, restricted upstreaming bandwidth of L7 appications,unit is kbps
#define CSID_C_QOS_L7_DW_BANDWIDTH 		_CFG_QOS(0xA000)  	//T=u16, restricted download bandwidth of L7 appplications ,unit is kbps
#define CSID_C_QOS_L7_PROTOCOL   		_CFG_QOS(0xB000)  	//T=str, the name of L7 applications, like BT.

/* Status Items */
#define CSID_S_QOS_ALTERED			_STA_QOS(0x0001)	//T=u8, ui altered

#endif //ifndef _CSID_QOS_H
