/*
 * @file Member ID Definition of Group PPTP.
 *
 * Moderator: GeorgeWang
 * Group ID: 0x00050000/0x80050000
 */

#ifndef _CSID_PPTP_H
#define _CSID_PPTP_H

#include "csid_gid.h"

#define _CFG_PPTP(x)		(CSID_GIDC_PPTP|(x))
#define _STA_PPTP(x)		(CSID_GIDS_PPTP|(x))

/* Extra Definitions */

#define PPTP_CNT_TYPE_ONDEMAND			0x00
#define PPTP_CNT_TYPE_AUTORECONNECT		0x01
#define PPTP_CNT_TYPE_MANUAL			0x02

#define PPTP_AUTHTYPE_AUTO				0x00
#define PPTP_AUTHTYPE_PAP				0x01
#define PPTP_AUTHTYPE_CHAP				0x02
#define PPTP_AUTHTYPE_MSCHAP			0x04
#define PPTP_AUTHTYPE_MSCHAPV2			0x08
#define PPTP_AUTHTYPE_EAP				0x10

#define PPTP_PHASE1_DHCP				0x00
#define PPTP_PHASE1_FIXED				0x01

#define PPTP_CNT_STATUS_DISCONNECT		0x00
#define PPTP_CNT_STATUS_CONNECTING		0x01
#define PPTP_CNT_STATUS_CONNECT			0x02
#define PPTP_CNT_STATUS_DISCONNECTING	0x03
#define PPTP_CNT_STATUS_WAIT_TRAFFIC	0x05
#define PPTP_CNT_STATUS_AUTH_FAIL		0x06

/* Configuration Items */
/* Total 256 account */
#define CSID_C_PPTP_USER          		_CFG_PPTP(0x0100)	//T=str, user name
#define CSID_C_PPTP_PASSWORD      		_CFG_PPTP(0x0200)	//T=str, user password
#define CSID_C_PPTP_P1FIXED_IP         	_CFG_PPTP(0x0300)	//T=ipv4, fixed interface ip
#define CSID_C_PPTP_P1FIXED_NM         	_CFG_PPTP(0x0400)	//T=ipv4, fixed interface netmask
#define CSID_C_PPTP_P1FIXED_GW         	_CFG_PPTP(0x0500)	//T=ipv4, fixed interface gateway
#define CSID_C_PPTP_PNS_SERVER			_CFG_PPTP(0x0600)	//T=str, PNS server name/ip
#define CSID_C_PPTP_P1FIXED_PRIDNS     	_CFG_PPTP(0x0700)	//T=ipv4, fixed primary DNS
#define CSID_C_PPTP_P1FIXED_SECDNS     	_CFG_PPTP(0x0800)	//T=ipv4, fixed secondary DNS
#define CSID_C_PPTP_CNT_TYPE      _CFG_PPTP(0x0900)	//T=u16, connect type
#define CSID_C_PPTP_MTU           _CFG_PPTP(0x0a00)	//T=u16, D=0, max transmission unit
#define CSID_C_PPTP_IDLETIME      _CFG_PPTP(0x0b00)	//T=u16, D=600, max idle time
#define CSID_C_PPTP_HOLDOFFTIME   _CFG_PPTP(0x0c00)	//T=u16, D=300, wait time before rebuild
#define CSID_C_PPTP_AUTHTYPE      _CFG_PPTP(0x0d00)	//T=u16, auth type
#define CSID_C_PPTP_PHASE1_TYPE   _CFG_PPTP(0x0e00)	//T=u8, D=0, connect to server in phase1 stage
#define CSID_C_PPTP_CNT_ID        _CFG_PPTP(0x0f00)	//T=str, Connection ID
/* 255 account reserverd */ 

/* PPTP Client Items */
#define CSID_C_PPTP_CLI_ENABLE          _CFG_PPTP(0x1000)   //T=u8, D=0, enable pptp client
#define CSID_C_PPTP_CLI_USER_ENABLE     _CFG_PPTP(0x1100)   //T=u8, D=0, enable pptp client user
#define CSID_C_PPTP_CLI_TUNLNAME        _CFG_PPTP(0x1200)   //T=str, tunnel name
#define CSID_C_PPTP_CLI_PEERIP          _CFG_PPTP(0x1300)   //T=ipv4, peer ip
#define CSID_C_PPTP_CLI_USER            _CFG_PPTP(0x1400)   //T=str, user name
#define CSID_C_PPTP_CLI_PASSWORD        _CFG_PPTP(0x1500)   //T=str, user password
#define CSID_C_PPTP_CLI_ROUTE           _CFG_PPTP(0x1600)   //T=str, route
#define CSID_C_PPTP_CLI_CONNECT_TYPE    _CFG_PPTP(0x1700)   //T=u8, D=0, connect type
#define CSID_C_PPTP_CLI_MPPE            _CFG_PPTP(0x1800)   //T=u8, D=0, enable mppe
#define CSID_C_PPTP_CLI_NAT             _CFG_PPTP(0x1900)   //T=u8, D=0, enable nat
#define CSID_C_PPTP_CLI_ACTIVE          _CFG_PPTP(0x1a00)   //T=u8, D=0, client active
/* 255 account reserverd */

/* Status Items */
#define CSID_S_PPTP_CLI_ALTERED         _STA_PPTP(0x1001)   //T=u8, ui altered
#define CSID_S_PPTP_CLI_ACTIVE_TUNNELS  _STA_PPTP(0x1002)   //T=u8, D=0, tunnel numbers
#define CSID_S_PPTP_CLI_ACT_PEER_IDX    _STA_PPTP(0x1003)   //T=u8, D=0, peer index
#define CSID_S_PPTP_CLI_ACT_BUTTON      _STA_PPTP(0x1004)   //T=u8, D=0, peer action button
/* Account status */
#define CSID_S_PPTP_CLI_PEER_USER       _STA_PPTP(0x1100)    //T=str, username
#define CSID_S_PPTP_CLI_PEER_REAL_IP    _STA_PPTP(0x1200)    //T=ipv4, peer real ip
#define CSID_S_PPTP_CLI_PEER_IP         _STA_PPTP(0x1300)    //T=ipv4, peer virtual ip
#define CSID_S_PPTP_CLI_PEER_CALL_ID    _STA_PPTP(0x1400)    //T=s32, D=-1, peer call id
#define CSID_S_PPTP_CLI_PEER_IFNAME     _STA_PPTP(0x1500)    //T=str, peer interface name

/* Status Items */ 
/* Total 256 account */ 
#define CSID_S_PPTP_CNT_TIME      _STA_PPTP(0x0100)	//T=u32,   connect time
#define CSID_S_PPTP_IF_IP         _STA_PPTP(0x0200)	//T=ipv4,  dynamic interface ip
#define CSID_S_PPTP_IF_NM         _STA_PPTP(0x0300)	//T=ipv4,  dynamic interface netmask
#define CSID_S_PPTP_IF_GW         _STA_PPTP(0x0400)	//T=ipv4,  dynamic interface gateway
#define CSID_S_PPTP_IF_PRIDNS     _STA_PPTP(0x0500)	//T=ipv4,  dynamic interface primary DNS
#define CSID_S_PPTP_IF_SECDNS     _STA_PPTP(0x0600)	//T=ipv4,  dynamic interface secondary DNS
#define CSID_S_PPTP_CNT_STATUS    _STA_PPTP(0x0700)	//T=u16,   connect status
#define CSID_S_PPTP_PKTIN_NUM     _STA_PPTP(0x0800)	//T=u32,   number of packet input
#define CSID_S_PPTP_PKTOUT_NUM    _STA_PPTP(0x0900)	//T=u32,   number of packet output
#define CSID_S_PPTP_ALTERED		  _STA_PPTP(0x0a00)	//T=u8,    ui altered
/* 255 account reserverd */

#endif //ifndef _CSID_PPTP_H
