/*
 * @file Member ID Definition of Group PORTFW.
 *
 * Moderator: JasonJiang
 * Group ID: 0x000C0000/0x800C0000
 */

#ifndef _CSID_PORTFW_H
#define _CSID_PORTFW_H

#include "csid_gid.h"

#define _CFG_PORTFW(x)         (CSID_GIDC_PORTFW|(x))
#define _STA_PORTFW(x)         (CSID_GIDS_PORTFW|(x))

#define PROTO_BOTH	0
#define PROTO_TCP	1
#define PROTO_UDP	2

/* Configuration Items */
#define CSID_C_PORTFW_ENABLE			_CFG_PORTFW(0x0001)		//T=u8, whether starting port fowarding, 1:yes 0:no

#define CSID_C_PORTFW_RULE_ENABLE		_CFG_PORTFW(0x1000)		//T=u8, rule enable, 1:yes 0:no
#define CSID_C_PORTFW_SERVER_IP			_CFG_PORTFW(0x2000)		//T=ipv4, internal host ip
#define CSID_C_PORTFW_SERVER_PORT		_CFG_PORTFW(0x3000)		//T=str, forwarding port including port-range, ex 20-30
#define CSID_C_PORTFW_USE_RULE_NO		_CFG_PORTFW(0x4000)		//T=u16, use_rule number
#define CSID_C_PORTFW_PRIVATE_PORT		_CFG_PORTFW(0x5000)		//T=str, private port for lan server bind
#define CSID_C_PORTFW_PROTOCOL			_CFG_PORTFW(0x6000)		//T=u8, forward ptotocol, 0:BOTH 1:TCP 2:UDP
#define CSID_C_PORTFW_EXTERNAL_PORT     _CFG_PORTFW(0x7000)     //T=str, external port


/* Status Items */
#define CSID_S_PORTFW_RULE_NUM			_STA_PORTFW(0x0001)		//T=u16, number of port-fowarding rules
#define CSID_S_PORTFW_ALTERED			_STA_PORTFW(0x0002)		//T=u8, ui altered

#endif //ifndef _CSID_PORTFW_H
