/*
 * @file Member ID Definition of Group PKFILTER.
 *
 * Moderator: JasonJiang
 * Group ID: 0x000e0000/0x800e0000
 */

#ifndef _CSID_PKFILTER_H
#define _CSID_PKFILTER_H

#include "csid_gid.h"

#define _CFG_PKFILTER(x)                    (CSID_GIDC_PKFILTER|(x))
#define _STA_PKFILTER(x)                    (CSID_GIDS_PKFILTER|(x))

/* Configuration Items */
#define CSID_C_PKFILTER_OUT_ENABLE          _CFG_PKFILTER(0x0001) //T=u8, whether starting pf_outbound rule, 1:yes 0:no
#define CSID_C_PKFILTER_IN_ENABLE           _CFG_PKFILTER(0x0002) //T=u8, whether starting pf_inbound rule, 1:yes 0:no
#define CSID_C_PKFILTER_OUT_DENY_ALL        _CFG_PKFILTER(0x0003) //T=u8, deny all except any rule is matched
#define CSID_C_PKFILTER_IN_DENY_ALL         _CFG_PKFILTER(0x0004) //T=u8, deny all except any rule is matched
#define CSID_C_PKFILTER_SIP_DENY         	_CFG_PKFILTER(0x0005) //T=u8, set 1: deny all SIP packet.

#define CSID_C_PKFILTER_OUT_RULE_ENABLE     _CFG_PKFILTER(0x1000) //T=u8, rule enable, 1:yes p:no
#define CSID_C_PKFILTER_OUT_RULE_SIP0       _CFG_PKFILTER(0x1800) //T=ipv4, start of source IP range
#define CSID_C_PKFILTER_OUT_RULE_SIP       	_CFG_PKFILTER(0x2000) //T=str,  source IP range
#define CSID_C_PKFILTER_OUT_RULE_SPORT     _CFG_PKFILTER(0x2800) //T=str, source Port range:192.168.1.0-192.168.1.254
//#define CSID_C_PKFILTER_OUT_RULE_SPORT1     _CFG_PKFILTER(0x3000) //T=u16, end of source Port range
#define CSID_C_PKFILTER_OUT_RULE_DIP0       _CFG_PKFILTER(0x3800) //T=ipv4, start of destination IP range
#define CSID_C_PKFILTER_OUT_RULE_DIP       _CFG_PKFILTER(0x4000) //T=str, destination IP range:192.168.1.0-192.168.1.254
#define CSID_C_PKFILTER_OUT_RULE_DPORT     _CFG_PKFILTER(0x4800) //T=str, destination Port range
//#define CSID_C_PKFILTER_OUT_RULE_DPORT1     _CFG_PKFILTER(0x5000) //T=u16, end of destination Port range
#define CSID_C_PKFILTER_OUT_RULE_SCHE_NO    _CFG_PKFILTER(0x5800) //T=u16, number of using rule

#define CSID_C_PKFILTER_IN_RULE_ENABLE      _CFG_PKFILTER(0x9000) //T=u8, rule enable, 1:yes 0:no
#define CSID_C_PKFILTER_IN_RULE_SIP0        _CFG_PKFILTER(0x9800) //T=ipv4, start of source IP range
#define CSID_C_PKFILTER_IN_RULE_SIP        _CFG_PKFILTER(0xA000) //T=str, source IP range:192.168.1.0-192.168.1.254
#define CSID_C_PKFILTER_IN_RULE_SPORT      _CFG_PKFILTER(0xA800) //T=str, source Port range
//#define CSID_C_PKFILTER_IN_RULE_SPORT1      _CFG_PKFILTER(0xB000) //T=u16, end of source Port range
#define CSID_C_PKFILTER_IN_RULE_DIP0        _CFG_PKFILTER(0xB800) //T=ipv4, start of destination IP range
#define CSID_C_PKFILTER_IN_RULE_DIP        _CFG_PKFILTER(0xC000) //T=str, destination IP range:192.168.1.0-192.168.1.254
#define CSID_C_PKFILTER_IN_RULE_DPORT      _CFG_PKFILTER(0xC800) //T=str, destination Port range
//#define CSID_C_PKFILTER_IN_RULE_DPORT1      _CFG_PKFILTER(0xD000) //T=u16, end of destination Port range
#define CSID_C_PKFILTER_IN_RULE_SCHE_NO     _CFG_PKFILTER(0xD800) //T=u16, number of using rule

/* Status Items */
#define CSID_S_PKFILTER_IN_RULE_NUM         _STA_PKFILTER(0x0001) //T=u16, number of pf_inbound rules
#define CSID_S_PKFILTER_OUT_RULE_NUM        _STA_PKFILTER(0x0002) //T=u16, number of pf_outbound rules
#define CSID_S_PKFILTER_ALTERED			    _STA_PKFILTER(0x0003) //T=u8, ui altered

#endif //ifndef _CSID_PKFILTER_H
