/*
 * @file Member ID Definition of Group NTP
 * 
 * This group is for not only NTP (RFC-1305) but also other protocols, 
 * likes Time Protocol (RFC-868) and Daytime Protocol (RFC-867).
 *
 * Moderator: RupertLi
 * Group ID: 0x00070000/0x80070000
 */

#ifndef _CSID_NTP_H
#define _CSID_NTP_H

#include "csid_gid.h"

#define _CFG_NTP(x)     (CSID_GIDC_NTP|(x))
#define _STA_NTP(x)     (CSID_GIDS_NTP|(x))

/* synchronization status */

#define NTP_SYNC_STATUS_IDLE		0	//idle or just started
#define NTP_SYNC_STATUS_BUSY		1	//sync process is in progress
#define NTP_SYNC_STATUS_OK			2	//last sync completed and OK
#define NTP_SYNC_STATUS_FAIL		3	//last sync completed and FAIL

/* Configuration Items */

#define CSID_C_NTP_TZ_ENVAR         _CFG_NTP(0x0001) //T=str, TZ environment var
#define CSID_C_NTP_TIMEZONE_ID      _CFG_NTP(0x0002) //T=u16, value in time zone selecting options
#define CSID_C_NTP_AUTO_SYNC_ENABLE _CFG_NTP(0x0008) //T=u8, auto-sync enable
//reserve 16 time servers
#define CSID_C_NTP_SERVER_NAME      _CFG_NTP(0x0010) //T=str, time server name
#define CSID_C_NTP_CURRENT_YEAR     _CFG_NTP(0x0003) //current year
#define CSID_C_NTP_CURRENT_MONTH    _CFG_NTP(0x0004) //current month
#define CSID_C_NTP_CURRENT_DAY      _CFG_NTP(0x0005) //current day
#define CSID_C_NTP_CURRENT_HOUR     _CFG_NTP(0x0006) //current hour
#define CSID_C_NTP_CURRENT_MIN      _CFG_NTP(0x0007) //current min
#define CSID_C_NTP_CURRENT_SEC      _CFG_NTP(0x0009) //current sec

//daylight setting
#define CSID_C_NTP_DAYLIGHT_MODE         _CFG_NTP(0x0011) //T=str, daylight mode
#define CSID_C_NTP_DAYLIGHT_START_MONTH  _CFG_NTP(0x0012) //T=str, daylight start month
#define CSID_C_NTP_DAYLIGHT_END_MONTH    _CFG_NTP(0x0013) //T=str, daylight end month
#define CSID_C_NTP_DAYLIGHT_START_DAY    _CFG_NTP(0x0014) //T=str, daylight start day
#define CSID_C_NTP_DAYLIGHT_END_DAY      _CFG_NTP(0x0015) //T=str, daylight end day
#define CSID_C_NTP_DAYLIGHT_START_HOUR   _CFG_NTP(0x0016) //T=str, daylight start hour
#define CSID_C_NTP_DAYLIGHT_END_HOUR     _CFG_NTP(0x0017) //T=str, daylight end hour

/* Status Items */
#define CSID_S_NTP_ALTERED          _STA_NTP(0x0001) //T=u8, ui altered
#define CSID_S_NTP_SYNC_STATUS      _STA_NTP(0x0002) //T=u8, synchronization status
#define CSID_S_PCTIME_SYNC_ALTERED	_STA_NTP(0x0003) //T=u32, setting is altered

#endif //ifndef _CSID_NTP_H
