/*
 * @file Member ID Definition of Group Miscellaneous.
 *
 * Moderator: JasonJiang
 * Group ID: 0x00150000/0x80150000
 */

#ifndef _CSID_MISC_H
#define _CSID_MISC_H

#include "csid_gid.h"

#define _CFG_MISC(x)         (CSID_GIDC_MISC|(x))
#define _STA_MISC(x)         (CSID_GIDS_MISC|(x))


#define MISC_PING_STOP	0
#define MISC_PING_START	1


/* Configuration Items */
#define CSID_C_MISC_REMOTE_ADMIN_ENABLE		_CFG_MISC(0x0001)	//T=u8, rule enable, 1:yes 0:no
#define CSID_C_MISC_REMOTE_ADMIN_IP		_CFG_MISC(0x0002)	//T=ipv4, the ip of administrators
#define CSID_C_MISC_REMOTE_ADMIN_PORT		_CFG_MISC(0x0003)	//T=u16, the port of adminitrators 
#define CSID_C_MISC_REMOTE_ADMIN_NM		_CFG_MISC(0x0004)	//T=u16, the netmask of adminitrators 

#define CSID_C_MISC_DISCARD_PING			_CFG_MISC(0x0005)	//T=u8, whether discarding ping from wan, 1:yes 0:no
#define CSID_C_MISC_SPI_MODE				_CFG_MISC(0x0006)	//T=u8, whether enabling SPI mode, 1:yes 0:no
#define CSID_C_MISC_DOS_ATTACK				_CFG_MISC(0x0007)	//T=u8, whether protecting DoS attackment, 1:yes 0:no

#define CSID_C_MISC_DMZ_ENABLE				_CFG_MISC(0x0008)	//T=u8, DMZ enable, 1:yes 0:no
#define CSID_C_MISC_DMZ_HOST_IP				_CFG_MISC(0x0009)	//T=ipv4, the ip of DMZ host
#define CSID_C_MISC_NONSTANDARD_FTP_PORT	_CFG_MISC(0x000A)	//T=u16, the port of non-standard FTP port
#define CSID_C_MISC_UPNP_ENABLE				_CFG_MISC(0x000B)	//T=u8, UPnP enable, 1:yes 0:no
#define CSID_C_MISC_IGMP_ENABLE				_CFG_MISC(0x000C)	//T=u8,	 IGMP enable, 1:yes 0:no

#define CSID_C_MISC_SYSLOG_ENABLE			_CFG_MISC(0x0020)	//T=u8, enable to send log to collector
#define CSID_C_MISC_SYSLOG_COLLECTOR_IP		_CFG_MISC(0x0021)	//T=ipv4, syslog collector's ip
#define CSID_C_MISC_SYSLOG_COLLECTOR_PORT	_CFG_MISC(0x0022)	//T=u16, syslog collector's port

#define CSID_C_MISC_PING_TARGET				_CFG_MISC(0x0080)	//T=str, default target for ping test
#define CSID_C_MISC_WAKE_TARGET				_CFG_MISC(0x0081)	//T=mac, default target for wake on lan


/* Status Items */
#define CSID_S_MISC_ALTERED					_STA_MISC(0x0002)	//T=u8, ui altered
#define CSID_S_MISC_PING_PID				_STA_MISC(0x0003)	//T=u32, the pid of ping
#define CSID_S_MISC_PING_STATUS				_STA_MISC(0x0004) 	//T=u32, the status of ping 
#define CSID_S_MISC_PING_TARGET_TMP			_STA_MISC(0x0005)	//T=str, default target for ping test

#endif //ifndef _CSID_MISC_H
