/* vi: set sw=4 ts=4: */

/*
 * @file Member ID Definition of Group LOCAL.
 *
 * Moderator: GeorgeWang/RupertLi
 * Group ID: 0x00010000/0x80010000
 */

#ifndef _CSID_LOCAL_H
#define _CSID_LOCAL_H

#include "csid_gid.h"

#define _CFG_LOCAL(x)       (CSID_GIDC_LOCAL|(x))
#define _STA_LOCAL(x)       (CSID_GIDS_LOCAL|(x))

#define LOCAL_WANTYPE_DHCP              0x00
#define LOCAL_WANTYPE_NULL              0x01
#define LOCAL_WANTYPE_3G				0x10
#define LOCAL_WANTYPE_IBURST			0x11
#define LOCAL_WANTYPE_WIBRO             0x12
#define LOCAL_WANTYPE_WISP              0x13
#define LOCAL_WANTYPE_FIXED             0x20
#define LOCAL_WANTYPE_PPPOE             0x40
#define LOCAL_WANTYPE_PPPOE_MULTI       0x41
#define LOCAL_WANTYPE_PPTP              0x60
#define LOCAL_WANTYPE_L2TP              0x80
#define LOCAL_WANTYPE_DIALUP			0x90


#define LOCAL_WAN_STATUS_DISCONNECT     0x00
#define LOCAL_WAN_STATUS_CONNECTING     0x01
#define LOCAL_WAN_STATUS_CONNECT        0x02
#define LOCAL_WAN_STATUS_DISCONNECTING  0x03
#define LOCAL_WAN_STATUS_WAIT_TRAFFIC	0x05
#define LOCAL_WAN_STATUS_AUTH_FAIL		0x06


/* Configuration Items */

#define CSID_C_LOCAL_HOSTNAME           _CFG_LOCAL(0x0001) //T=str, local host name
#define CSID_C_LOCAL_PASSWORD           _CFG_LOCAL(0x0002) //T=str, D="admin", administrator password
#define CSID_C_LOCAL_WANTYPE            _CFG_LOCAL(0x0003) //T=u32, D=0, wan type (default is DHCP)
#define CSID_C_LOCAL_LANIP              _CFG_LOCAL(0x0004) //T=ipv4, D={192.168.123.254}, lan ip
#define CSID_C_LOCAL_LANNM              _CFG_LOCAL(0x0005) //T=ipv4, D={255.255.255.0}, lan subnet mask
#define CSID_C_LOCAL_ROUTER_TYPE		_CFG_LOCAL(0x0006) //T=u32, D=0, router type, 0:normal(1WAN+4LAN) 1:single ethernet
#define CSID_C_LOCAL_SIG_ETHER_PORT     _CFG_LOCAL(0x0007) //T=u32, D=2, For the "only one" ethernet port exists 0:no function 1:WAN 2:LAN
#define CSID_C_LOCAL_HOMECOM_ADMIN_USERNAME		_CFG_LOCAL(0x0008) //T=str, D="admin", UI username
#define CSID_C_LOCAL_HOMECOM_ADMIN_PASSWORD		_CFG_LOCAL(0x0009) //T=str, D="admin", UI password
#define CSID_C_LOCAL_ETHER_AUTO_DETECT	_CFG_LOCAL(0x000A) //T=u32, D=0, 0:stop auto-detection of DHCP, 1: start it.
#define CSID_C_LOCAL_USERNAME			_CFG_LOCAL(0x000B) //T=u32, D="admin", Login username	

#define CSID_C_LOCAL_WAN_MAC            _CFG_LOCAL(0x000F) //T=mac, MAC of WAN port

#define CSID_C_LOCAL_WLANENABLE         _CFG_LOCAL(0x0010) //T=u8, D=1, WLAN enable/disable (default is enable)
#define CSID_C_LOCAL_3G_ENABLE			_CFG_LOCAL(0x0011) //T=u32, D=0, 3G wantype enable/disable for UI page showing (default is disable)

/* Time control */
#define CSID_C_LOCAL_RESET_TIME         _CFG_LOCAL(0x0020) //T=u32, D=6, press RESET button time
#define CSID_C_LOCAL_WPS_LOCK_TIME      _CFG_LOCAL(0x0021) //T=u32, D=120, WPS enable time
#define CSID_C_LOCAL_WIFI_ONOFF_TIME    _CFG_LOCAL(0x0022) //T=u32, D=3, press WiFi on/off button time


/* for HOMECOM normal user */
#define CSID_C_LOCAL_HOMECOM_NORMAL_USERNAME	_CFG_LOCAL(0x0050) //T=str, UI username
#define CSID_C_LOCAL_HOMECOM_NORMAL_PASSWORD	_CFG_LOCAL(0x0060) //T=str, UI password
#define CSID_C_LOCAL_HOMECOM_NORMAL_AUTHORITY	_CFG_LOCAL(0x0070) //T=str, D="0", User authority


/* Reserved 16 items for Multi-WAN,  X is from 1 .... */
#define CSID_C_LOCAL_WAN1_ENABLE		_CFG_LOCAL(0x0100) //T=u32, D=0, Multi WAN Enbale/Disable, Starting from WAN1, Next will be WAN2 , ...
#define CSID_C_LOCAL_WAN1_CLONE_MAC		_CFG_LOCAL(0x0110) //T=mac, Clone MAC of WAN1 port
#define CSID_C_LOCAL_WAN1_WANTYPE       _CFG_LOCAL(0x0120) //T=u32, D=0, wan type (default is DHCP)

/* Status Items */

#define CSID_S_LOCAL_LOGIN_IP           _STA_LOCAL(0x0001) //T=ipv4, ip address of logged in user
#define CSID_S_LOCAL_WAN_IP             _STA_LOCAL(0x0002) //T=ipv4, wan ip
#define CSID_S_LOCAL_WAN_NM             _STA_LOCAL(0x0003) //T=ipv4, wan netmask
#define CSID_S_LOCAL_WAN_GW             _STA_LOCAL(0x0004) //T=ipv4, wan gateway
#define CSID_S_LOCAL_WAN_PRIDNS         _STA_LOCAL(0x0005) //T=ipv4, wan primary dns
#define CSID_S_LOCAL_WAN_SECDNS         _STA_LOCAL(0x0006) //T=ipv4, wan secondary dns
#define CSID_S_LOCAL_WAN_STATUS         _STA_LOCAL(0x0007) //T=u16, wan status
#define CSID_S_LOCAL_WANTYPE_ALTERED    _STA_LOCAL(0x0008) //T=u32, ui altered
#define CSID_S_LOCAL_WANSET_ALTERED     _STA_LOCAL(0x0009) //T=u32, ui altered
#define CSID_S_LOCAL_LAN_ALTERED        _STA_LOCAL(0x000a) //T=u32, ui altered
#define CSID_S_LOCAL_WAN_IF_NAME        _STA_LOCAL(0x000b) //T=str, the interface name of wan, ppp0, eth1, ixp1
#define CSID_S_LOCAL_CNT_TIME           _STA_LOCAL(0x000c) //T=u32, the connect time
#define CSID_S_LOCAL_DETECT_WAN			_STA_LOCAL(0x000d) //T=u32, auto wantype detect result,0=no detect,1=dhcp,2=pppoe
#define CSID_S_LOCAL_WAN_CNT_FORCE		_STA_LOCAL(0x000e) //T=u32, Force WAN trigger conncet,0=disable,1=enable
#define CSID_S_LOCAL_SEP_CFG_ALTERED    _STA_LOCAL(0x000f) //T=u32, D=0, single ethernet port configuration changing, 0:no change, 1:

#define CSID_S_LOCAL_ROOT_DNS			_STA_LOCAL(0x0010) //T=ipv4, D={192.203.230.10}, ns.nasa.gov, 	Mountain View, California, U.S.

#define CSID_S_LOCAL_WAN_PORT			_STA_LOCAL(0x0020) //T=u8, WAN port cable connected, 0=disconnect, 1=connected
#define CSID_S_LOCAL_LAN_PORT			_STA_LOCAL(0x0030) //T=u8, LANx cable connected, 0=disconnect, 1=connected

/* for AGP Testing */
#define CSID_S_LOCAL_LOGINED			_STA_LOCAL(0x0040) //T=u8, logined or not?  0=not, 1=yes
#define CSID_S_LOCAL_RESETCNT			_STA_LOCAL(0x0042) //T=u16, for record reset_cnt press times
#define CSID_S_LOCAL_WPSCNT 			_STA_LOCAL(0x0044) //T=u16, for record wps_cnt press times


/* Reserved 16 items for Multi-WAN,  X is from 1 .... */
#define CSID_S_LOCAL_WAN1_IP				_STA_LOCAL(0x0110) //T=ipv4, wanx ip, ex wan1 ip
#define CSID_S_LOCAL_WAN1_NM            	_STA_LOCAL(0x0120) //T=ipv4, wanx netmask
#define CSID_S_LOCAL_WAN1_GW            	_STA_LOCAL(0x0130) //T=ipv4, wanx gateway
#define CSID_S_LOCAL_WAN1_PRIDNS        	_STA_LOCAL(0x0140) //T=ipv4, wanx primary dns
#define CSID_S_LOCAL_WAN1_SECDNS        	_STA_LOCAL(0x0150) //T=ipv4, wanx secondary dns
#define CSID_S_LOCAL_WAN1_STATUS        	_STA_LOCAL(0x0160) //T=u32, wanx status
#define CSID_S_LOCAL_WAN1_WANTYPE_ALTERED   _STA_LOCAL(0x0170) //T=u32, ui altered
#define CSID_S_LOCAL_WAN1_WANSET_ALTERED    _STA_LOCAL(0x0180) //T=u32, ui altered
#define CSID_S_LOCAL_WAN1_IF_NAME       	_STA_LOCAL(0x0190) //T=str, the interface name of wan, ppp0, eth1, ixp1
#define CSID_S_LOCAL_WAN1_CNT_TIME      	_STA_LOCAL(0x01A0) //T=u32, the connect time
#define CSID_S_LOCAL_WAN1_DETECT_WAN		_STA_LOCAL(0x01B0) //T=u32, auto wantype detect result,0=no detect,1=dhcp,2=pppoe
#define CSID_S_LOCAL_WAN1_CNT_FORCE			_STA_LOCAL(0x01C0) //T=u32, Force WAN trigger conncet,0=disable,1=enable

#define CSID_S_LOCAL_HOMECOM_USER_STATUS	_STA_LOCAL(0x0200) //T=u8, D=0, Homecom user status.
#define CSID_S_LOCAL_RT8651C_SPECIAL_SNAT	_STA_LOCAL(0x0210) //T=u8, D=0, support RT8651 to connect using br0 interface

#define CSID_S_LOCAL_WAN_IF_NAME_3G_FAILOVER	_STA_LOCAL(0x0300) //T=str, the interface name of wan used by autobak ping check, ppp0, eth1, ixp1

#endif //ifndef _CSID_LOCAL_H
