/*
 * @file Member ID Definition of Group HTTP
 * 
 * Moderator: RupertLi
 * Group ID: 0x00020000/0x80020000
 */

#ifndef _CSID_HTTP_H
#define _CSID_HTTP_H

#include "csid_gid.h"

#define _CFG_HTTP(x)     (CSID_GIDC_HTTP|(x))
#define _STA_HTTP(x)     (CSID_GIDS_HTTP|(x))

/* Configuration Items */
#define CSID_C_HTTP_AUTH_TIMEOUT        _CFG_HTTP(0x0004) //T=u16, time out of administrator
#define CSID_C_HTTP_LANG_MODE           _CFG_HTTP(0x000F) //T=u8, language mode

/* Status Items */
#define CSID_S_HTTP_PID					_STA_HTTP(0x0001) //T=u32, Httpd PID

#define CSID_S_HTTP_AUTH_SCHEME         _STA_HTTP(0x0100) //T=u8, auth scheme: CGI, Basic or Digest?
#define CSID_S_HTTP_AUTH_PAGE401        _STA_HTTP(0x0101) //T=str, redirect page when CGI auth fail
#define CSID_S_HTTP_AUTH_REALM          _STA_HTTP(0x0102) //T=str, auth realm

#define CSID_S_HTTP_ERR_RESTART			_STA_HTTP(0x0110) //T=u32, D=0, if httpd err, rtstart it

//0x0200 ~ 0x027F
#define CSID_S_HTTP_LANG_TAB_TAG        _STA_HTTP(0x0201) //T=str, supported lang table, "tag" column
//0x0280 ~ 0x02FF
#define CSID_S_HTTP_LANG_ID_DEFAULT     _STA_HTTP(0x0280) //T=u8, default language id
#define CSID_S_HTTP_LANG_TAB_ID         _STA_HTTP(0x0281) //T=u8, supported lang table, "id" column

//Each Weblet has 0x100's CSID
#define CSID_S_HTTP_FWUPG_FW_SIZE       _STA_HTTP(0xF001) //T=u32, size of FW bin file
#define CSID_S_HTTP_FWUPG_FW_LEFT       _STA_HTTP(0xF002) //T=u32, size of FW data left

#endif //ifndef _CSID_HTTP_H
