/*
 * CSID Definition of Group GRE.
 *
 * Moderator: Chad Sheu
 * Group ID: 0x00710000/0x80710000
 */

#ifndef _CSID_GRE_H
#define _CSID_GRE_H

#include "csid_gid.h"

#define _CFG_GRE(x)		(CSID_GIDC_GRE|(x))
#define _STA_GRE(x)		(CSID_GIDS_GRE|(x))

/* Extra Definitions */
#define MAX_GRE_TUNNEL               8
#define MAX_GRE_PEER_SUBNET          8
#define MAX_TNAME_SIZE	 		   	16
#define MAX_WAN_IF_SIZE	 		   	16
#define MAX_CMD_SIZE               256

/* Configuration Items */
#define CSID_C_GRE_TNAME         _CFG_GRE(0x0010)	//T=str,  GRE tunnel name
#define CSID_C_GRE_ENABLE        _CFG_GRE(0x0020)	//T=u8,   enable/disable GRE tunnel
#define CSID_C_GRE_DT            _CFG_GRE(0x0030)	//T=u8,   default tunnel
#define CSID_C_GRE_PEER_IP       _CFG_GRE(0x0040)	//T=ipv4, the IP address of remote router
#define CSID_C_GRE_KEY           _CFG_GRE(0x0050)	//T=u32,  pre-shared key for the tunnel
#define CSID_C_GRE_TTL           _CFG_GRE(0x0060)	//T=u16,  time to live 
#define CSID_C_GRE_PEER_SUBNET   _CFG_GRE(0x0070)	//T=ipv4, the domain of the remote LAN 
#define CSID_C_GRE_PEER_MASK     _CFG_GRE(0x0140)	//T=u8,   the submask of the remote LAN 
#define CSID_C_GRE_LOCAL_IP      _CFG_GRE(0x0210)	//T=ipv4, the IP address of local router

/* Status Items */ 
#define CSID_S_GRE_ALTERED		 _STA_GRE(0x0001)	//T=u8,   UI altered

#endif 

