/*
 * @file CSMan Group ID Definition.
 *
 * Moderator: RupertLi
 */

#ifndef _CSID_GID_H
#define _CSID_GID_H

/* 0x0000 is reserved; 0x8000 is for CSMan and system parameters */

#define CSID_GIDC_SYS			0x00000000
#define CSID_GIDS_SYS			0x80000000

/* 0x0001~0x0FFF and 0x8000~0x8FFF are free to allocated */

#define CSID_GIDC_LOCAL			0x00010000
#define CSID_GIDS_LOCAL			0x80010000

#define CSID_GIDC_HTTP			0x00020000
#define CSID_GIDS_HTTP			0x80020000

#define CSID_GIDC_DHCP			0x00030000
#define CSID_GIDS_DHCP			0x80030000

#define CSID_GIDC_PPPOE			0x00040000
#define CSID_GIDS_PPPOE			0x80040000

#define CSID_GIDC_PPTP			0x00050000
#define CSID_GIDS_PPTP			0x80050000

#define CSID_GIDC_L2TP			0x00060000
#define CSID_GIDS_L2TP			0x80060000

#define CSID_GIDC_NTP			0x00070000
#define CSID_GIDS_NTP			0x80070000

#define CSID_GIDC_SENDMAIL		0x00080000
#define CSID_GIDS_SENDMAIL		0x80080000

#define CSID_GIDC_DDNS			0x00090000
#define CSID_GIDS_DDNS			0x80090000

#define CSID_GIDC_DNSPROXY		0x000a0000
#define CSID_GIDS_DNSPROXY		0x800a0000

#define CSID_GIDC_SCHEDULE		0x000b0000
#define CSID_GIDS_SCHEDULE		0x800b0000

#define CSID_GIDC_PORTFW		0x000c0000
#define CSID_GIDS_PORTFW		0x800c0000

#define CSID_GIDC_MACCTL		0x000d0000
#define CSID_GIDS_MACCTL		0x800d0000

#define CSID_GIDC_PKFILTER		0x000e0000
#define CSID_GIDS_PKFILTER		0x800e0000

#define CSID_GIDC_DMFILTER		0x000f0000
#define CSID_GIDS_DMFILTER		0x800f0000

#define CSID_GIDC_URLBLOCK		0x00100000
#define CSID_GIDS_URLBLOCK		0x80100000

#define CSID_GIDC_FIX			0x00110000
#define CSID_GIDS_FIX			0x80110000

#define CSID_GIDC_QOS			0x00120000
#define CSID_GIDS_QOS			0x80120000

#define CSID_GIDC_ROUTING		0x00130000
#define CSID_GIDS_ROUTING		0x80130000

#define CSID_GIDC_VCOMPUTER		0x00140000
#define CSID_GIDS_VCOMPUTER		0x80140000

#define CSID_GIDC_MISC			0x00150000
#define CSID_GIDS_MISC			0x80150000

#define CSID_GIDC_SNMP			0x00160000
#define CSID_GIDS_SNMP			0x80160000

#define CSID_GIDC_SPAP			0x00170000
#define CSID_GIDS_SPAP			0x80170000

#define CSID_GIDC_MROUTING		0x00180000
#define CSID_GIDS_MROUTING		0x80180000

#define CSID_GIDC_WLANAP		0x00190000
#define CSID_GIDS_WLANAP		0x80190000

#define CSID_GIDC_PPTPSERV		0x001a0000
#define CSID_GIDS_PPTPSERV		0x801a0000

#define CSID_GIDC_L2TPSERV		0x001b0000
#define CSID_GIDS_L2TPSERV		0x801b0000

#define CSID_GIDC_WLANCLI		0x001c0000
#define CSID_GIDS_WLANCLI		0x801c0000

#define CSID_GIDC_SDMZ			0x001d0000
#define CSID_GIDS_SDMZ			0x801d0000

#define CSID_GIDC_3G			0x001e0000
#define CSID_GIDS_3G			0x801e0000

#define CSID_GIDC_STORAGE		0x001f0000
#define CSID_GIDS_STORAGE		0x801f0000

#define CSID_GIDC_WEBUI			0x00200000
#define CSID_GIDS_WEBUI			0x80200000

#define CSID_GIDC_SIPBASIC		0x00210000
#define CSID_GIDS_SIPBASIC		0x80210000

#define CSID_GIDC_SIPACC		0x00220000
#define CSID_GIDS_SIPACC		0x80220000

#define CSID_GIDC_SIPSERV		0x00230000
#define CSID_GIDS_SIPSERV		0x80230000

#define CSID_GIDC_SIPNAT		0x00240000
#define CSID_GIDS_SIPNAT		0x80240000

#define CSID_GIDC_VOIPVOICE		0x00250000
#define CSID_GIDS_VOIPVOICE		0x80250000

#define CSID_GIDC_VOIPTONE		0x00260000
#define CSID_GIDS_VOIPTONE		0x80260000

#define CSID_GIDC_VOIPCSERV		0x00270000
#define CSID_GIDS_VOIPCSERV		0x80270000

#define CSID_GIDC_VOIPFXS		0x00280000
#define CSID_GIDS_VOIPFXS		0x80280000

#define CSID_GIDC_VOIPFXO		0x00290000
#define CSID_GIDS_VOIPFXO		0x80290000

#define CSID_GIDC_VOIPFAX		0x002a0000
#define CSID_GIDS_VOIPFAX		0x802a0000

#define CSID_GIDC_VOIPGDS		0x002b0000
#define CSID_GIDS_VOIPGDS		0x802b0000

#define CSID_GIDC_VOIPDP		0x002c0000
#define CSID_GIDS_VOIPDP		0x802c0000

#define CSID_GIDC_VOIPPB		0x002d0000
#define CSID_GIDS_VOIPPB		0x802d0000

#define CSID_GIDC_VOIPCSRN		0x002e0000
#define CSID_GIDS_VOIPCSRN		0x802e0000

#define CSID_GIDC_VOIP			0x002f0000
#define CSID_GIDS_VOIP			0x802f0000

#define CSID_GIDC_TR069 		0x00300000
#define CSID_GIDS_TR069	    	0x80300000

#define CSID_GIDC_HANDY         0x00310000
#define CSID_GIDS_HANDY         0x80310000

#define CSID_GIDC_WLANAPCLI		0x00320000
#define CSID_GIDS_WLANAPCLI		0x80320000

#define CSID_GIDC_IPCAM         0x00330000
#define CSID_GIDS_IPCAM         0x80330000

#define CSID_GIDC_IBURST		0x00340000
#define CSID_GIDS_IBURST		0x80340000

#define CSID_GIDC_WIBRO         0x00350000
#define CSID_GIDS_WIBRO         0x80350000

#define CSID_GIDC_WISP         0x00360000
#define CSID_GIDS_WISP         0x80360000

#define CSID_GIDC_GREEN			0x00400000
#define CSID_GIDS_GREEN			0x80400000

#define CSID_GIDC_XDSL			0x00410000
#define CSID_GIDS_XDSL			0x80410000

#define CSID_GIDC_RS232			0x00420000
#define CSID_GIDS_RS232			0x80420000

#define CSID_GIDC_MACLIST       0x00500000
#define CSID_GIDS_MACLIST       0x80500000

#define CSID_GIDC_MRTG       	0x00600000
#define CSID_GIDS_MRTG       	0x80600000

#define CSID_GIDC_VPN           0x00700000
#define CSID_GIDS_VPN           0x80700000

#define CSID_GIDC_TELEPHONY		0x00800000
#define CSID_GIDS_TELEPHONY		0x80800000

#define CSID_GIDC_GRE           0x00710000
#define CSID_GIDS_GRE           0x80710000 

//keep this group as the last one
#define CSID_GIDC_TEST			0x0FFF0000
#define CSID_GIDS_TEST			0x8FFF0000

/* 0x1000~0x7FFF are reserved */
/* 0x9000~0xFFFF are reserved */

#endif //ifndef _CSID_GID_H
