/*
 * @file Member ID Definition of Group FIX.
 *
 * Moderator: GeorgeWang
 * Group ID: 0x00110000/0x80110000
 */

#ifndef _CSID_FIX_H
#define _CSID_FIX_H

#include "csid_gid.h"

#define _CFG_FIX(x)		(CSID_GIDC_FIX|(x))
#define _STA_FIX(x)		(CSID_GIDS_FIX|(x))

/* Configuration Items */

#define CSID_C_FIX_IF_IP	      _CFG_FIX(0x0001)	//T=ipv4, fix ip
#define CSID_C_FIX_IF_NM	      _CFG_FIX(0x0002)	//T=ipv4, fix netmask
#define CSID_C_FIX_IF_GW	      _CFG_FIX(0x0003)	//T=ipv4, fix gateway
#define CSID_C_FIX_IF_PRIDNS	  _CFG_FIX(0x0004)	//T=ipv4, fix primary dns
#define CSID_C_FIX_IF_SECDNS	  _CFG_FIX(0x0005)	//T=ipv4, fix secondary dns
#define CSID_C_FIX_MTU            _CFG_FIX(0x0009)  //T=u16, MTU
#define CSID_C_FIX_NAT_DISABLE	  _CFG_FIX(0x000f)	//T=u32, Static IP wantype NAT disable


/* Reserved 16 items for Multi-WAN,  X is from 1 .... */
#define CSID_C_FIX1_IF_IP	      _CFG_FIX(0x0110)	//T=ipv4, fix ip
#define CSID_C_FIX1_IF_NM	      _CFG_FIX(0x0120)	//T=ipv4, fix netmask
#define CSID_C_FIX1_IF_GW	      _CFG_FIX(0x0130)	//T=ipv4, fix gateway
#define CSID_C_FIX1_IF_PRIDNS	  _CFG_FIX(0x0140)	//T=ipv4, fix primary dns
#define CSID_C_FIX1_IF_SECDNS	  _CFG_FIX(0x0150)	//T=ipv4, fix secondary dns
#define CSID_C_FIX1_NAT_DISABLE	  _CFG_FIX(0x0160)	//T=u32, Static IP wantype NAT disable


/* Status Items */

#define CSID_S_FIX_PKTIN_NUM     _STA_FIX(0x0001)	//T=u32,   number of packet input
#define CSID_S_FIX_PKTOUT_NUM    _STA_FIX(0x0002)	//T=u32,   number of packet output
#define CSID_S_FIX_ALTERED		 _STA_FIX(0x0003)	//T=u32, ui altered



/* Reserved 16 items for Multi-WAN,  X is from 1 .... */
#define CSID_S_FIX1_PKTIN_NUM   _STA_FIX(0x0100)	//T=u32,   number of packet input
#define CSID_S_FIX1_PKTOUT_NUM  _STA_FIX(0x0110)	//T=u32,   number of packet output
#define CSID_S_FIX1_ALTERED		_STA_FIX(0x0120)	//T=u32, ui altered


#endif //ifndef _CSID_FIX_H
