/* vi: set sw=4 ts=4: */

/*
 * @file Member ID Definition of Group DHCP. 
 *
 * DHCP Sever (DHCPD) & DHCP Client (DHCPC)
 *
 * Moderator: WumingWu
 * Group ID: 0x00030000/0x80030000
 *
 * // Configuration Items   (64K)
 *   // DHCP Daemon 0x0001 ~ 0x4FFF
 *   // DHCP Client 0x5001 ~ 0x6FFF
 *   // DHCP Probe  0x7001 ~ 0x7FFF
 *   // Reserved    0x8000 ~ 0xFFFF
 * // Status Items			(64K)
 *   // DHCP Daemon 0x0001 ~ 0x4FFF
 *   // DHCP Client 0x5001 ~ 0x6FFF
 *   // DHCP Probe  0x7001 ~ 0x7FFF
 *   // Reserved    0x8000 ~ 0xFFFF
 */

#ifndef _CSID_DHCP_H
#define _CSID_DHCP_H

#include "csid_gid.h"

#define _CFG_DHCP(x)		(CSID_GIDC_DHCP|(x))
#define _STA_DHCP(x)		(CSID_GIDS_DHCP|(x))

/* Extra Definitions */

#define DHCP_CNT_TYPE_ONDEMAND          0x00
#define DHCP_CNT_TYPE_AUTORECONNECT     0x01
#define DHCP_CNT_TYPE_MANUAL            0x02

#define DHCP_CNT_STATUS_DISCONNECT      0x00
#define DHCP_CNT_STATUS_CONNECTING      0x01
#define DHCP_CNT_STATUS_CONNECT         0x02
#define DHCP_CNT_STATUS_DISCONNECTING   0x03
#define DHCP_CNT_STATUS_LEASEFAIL		0x04
#define DHCP_CNT_STATUS_WAIT_TRAFFIC	0x05

/* Configuration Items */

/* DHCP Daemon */
/* DHCP Server (DHCPD) Basic Setting */
#define CSID_C_DHCP_SVR_ENABLE				_CFG_DHCP(0x0001)	//T=u8, D=1, Enable/Disable
#define CSID_C_DHCP_SVR_LEASETIME			_CFG_DHCP(0x0002)	//T=u32, D=86400, Lease Time (seconds)
#define CSID_C_DHCP_SVR_IPPOOL_START		_CFG_DHCP(0x0003)	//T=ipv4, D={192.168.123.100},  IP Pool Starting Address
#define CSID_C_DHCP_SVR_IPPOOL_END			_CFG_DHCP(0x0004)	//T=ipv4, D={192.168.123.200}, IP Pool Ending Address
#define CSID_C_DHCP_SVR_DOMAIN				_CFG_DHCP(0x0005)	//T=str, Domain Name
#define CSID_C_DHCP_SVR_PRIDNS				_CFG_DHCP(0x0006)	//T=ipv4, Primary DNS  
#define CSID_C_DHCP_SVR_SECDNS				_CFG_DHCP(0x0007)	//T=ipv4, Second DNS  
#define CSID_C_DHCP_SVR_PRIWINS				_CFG_DHCP(0x0008)	//T=ipv4, Primary WINS  
#define CSID_C_DHCP_SVR_SECWINS				_CFG_DHCP(0x0009)	//T=ipv4, Second WINS
#define CSID_C_DHCP_SVR_GATEWAY				_CFG_DHCP(0x000a)	//T=ipv4, Gateway default is LAN ip
#define CSID_C_DHCP_SVR_MAXLEASE			_CFG_DHCP(0x000b)	//T=u32, D=101, the Max. number of lease ip 

/* Fixed Mapping */
#define CSID_C_DHCP_SVR_FIXMAP_ENABLE		_CFG_DHCP(0x1000)	//T=u8, D=0, Enable/Disable
#define CSID_C_DHCP_SVR_FIXMAP_MAC			_CFG_DHCP(0x1200)	//T=mac, Mapped MAC
#define CSID_C_DHCP_SVR_FIXMAP_IP			_CFG_DHCP(0x1400)	//T=ipv4, Mapped IP

/* Basic Setting end */

/* DHCP Client */
#define CSID_C_DHCP_CLI_ENABLE				_CFG_DHCP(0x5001)	//T=u8, Client's Enable/Disable
#define CSID_C_DHCP_CLI_HOSTNAME			_CFG_DHCP(0x5002)	//T=str, Client's Host Name

#define CSID_C_DHCP_CLI_IF_IP				_CFG_DHCP(0x5004)	//T=ipv4, static interface ip
#define CSID_C_DHCP_CLI_IF_NM				_CFG_DHCP(0x5005)	//T=ipv4, static interface netmask
#define CSID_C_DHCP_CLI_IF_GW				_CFG_DHCP(0x5006)	//T=ipv4, static interface gateway
#define CSID_C_DHCP_CLI_IF_PRIDNS		    _CFG_DHCP(0x5007)	//T=ipv4, static interface Primary DNS
#define CSID_C_DHCP_CLI_IF_SECDNS		    _CFG_DHCP(0x5008)	//T=ipv4, static interface Second DNS
#define CSID_C_DHCP_CLI_MTU					_CFG_DHCP(0x5009)	//T=u32, MTU
#define CSID_C_DHCP_CLI_CNT_TYPE			_CFG_DHCP(0x500a)	//T=u32, Connect Type
#define CSID_C_DHCP_CLI_CHGTTL				_CFG_DHCP(0x500b)	//T=u8, Enable/Disable , Change the TTL value
#define CSID_C_DHCP_CLI_AUTOBKP				_CFG_DHCP(0x500c)	//T=u8, Enable/Disable , Auto Backup
#define CSID_C_DHCP_CLI_IDLETIME        	_CFG_DHCP(0x500d)	//T=u16, D=600, max idle time
#define CSID_C_DHCP_CLI_NAT_DISABLE        	_CFG_DHCP(0x500f)	//T=u32, Dynamic IP wantype NAT disable

/* Reserved 16 items for Multi-WAN,  X is from 1 .... */
#define CSID_C_DHCP_CLI1_ENABLE				_CFG_DHCP(0x5100)	//T=u8, Client's Enable/Disable
#define CSID_C_DHCP_CLI1_HOSTNAME			_CFG_DHCP(0x5110)	//T=str, Client's Host Name
#define CSID_C_DHCP_CLI1_IF_IP				_CFG_DHCP(0x5120)	//T=ipv4, static interface ip
#define CSID_C_DHCP_CLI1_IF_NM				_CFG_DHCP(0x5130)	//T=ipv4, static interface netmask
#define CSID_C_DHCP_CLI1_IF_GW				_CFG_DHCP(0x5140)	//T=ipv4, static interface gateway
#define CSID_C_DHCP_CLI1_IF_PRIDNS		    _CFG_DHCP(0x5150)	//T=ipv4, static interface Primary DNS
#define CSID_C_DHCP_CLI1_IF_SECDNS		    _CFG_DHCP(0x5160)	//T=ipv4, static interface Second DNS
#define CSID_C_DHCP_CLI1_MTU				_CFG_DHCP(0x5170)	//T=u32, MTU
#define CSID_C_DHCP_CLI1_CNT_TYPE			_CFG_DHCP(0x5180)	//T=u32, Connect Type
#define CSID_C_DHCP_CLI1_CHGTTL				_CFG_DHCP(0x5190)	//T=u32, Enable/Disable , Change the TTL value
#define CSID_C_DHCP_CLI1_AUTOBKP			_CFG_DHCP(0x51A0)	//T=u32, Enable/Disable , Auto Backup
#define CSID_C_DHCP_CLI1_IDLETIME        	_CFG_DHCP(0x51B0)	//T=u32, D=600, max idle time
#define CSID_C_DHCP_CLI1_NAT_DISABLE        _CFG_DHCP(0x51C0)	//T=u32, Dynamic IP wantype NAT disable


/* Status Items */
/* DHCP Daemon */
#define CSID_S_DHCP_SVR_PID					_STA_DHCP(0x0001)	//T=u16, The PID of DHCP Server
#define CSID_S_DHCP_SVR_ALTERED			    _STA_DHCP(0x0002)	//T=u8, ui altered
#define CSID_S_DHCP_SVR_DNS			        _STA_DHCP(0x0003)	//T=u8, if assign lan ip as dns

/* Client-List, 256 items are reserved */
#define CSID_S_DHCP_SVR_CLILIST_IP			_STA_DHCP(0x0100)	//T=ipv4, The IP of the Client in Client List
#define CSID_S_DHCP_SVR_CLILIST_HOSTNAME	_STA_DHCP(0x0200)	//T=str, The hostname of the Client in the Client List
#define CSID_S_DHCP_SVR_CLILIST_MAC			_STA_DHCP(0x0300)	//T=mac, The Mac Address of the Client in Client List
#define CSID_S_DHCP_SVR_CLILIST_LEASETIME	_STA_DHCP(0x0400)	//T=u32, remaining lease time
#define CSID_S_DHCP_SVR_CLILIST_TYPE		_STA_DHCP(0x0500)	//T=u8, wired or wireless mode
#define CSID_S_DHCP_SVR_CLILIST_WLAN		_STA_DHCP(0x0600)	//T=str, backup wireless client for speical issue
/* Client-List end */

/* DHCP Client */
#define CSID_S_DHCP_CLI_PID					_STA_DHCP(0x5001)	//T=u16, The PID of DHCP Client 
#define CSID_S_DHCP_CLI_IF_IP				_STA_DHCP(0x5002)	//T=ipv4, dynamic interface ip
#define CSID_S_DHCP_CLI_IF_NM				_STA_DHCP(0x5003)	//T=ipv4, dynamic interface netmask
#define CSID_S_DHCP_CLI_IF_GW				_STA_DHCP(0x5004)	//T=ipv4, dynamic interface gateway
#define CSID_S_DHCP_CLI_IF_PRIDNS		    _STA_DHCP(0x5005)	//T=ipv4, dynamic interface Primary DNS
#define CSID_S_DHCP_CLI_IF_SECDNS		    _STA_DHCP(0x5006)	//T=ipv4, dynamic interface Second DNS
#define CSID_S_DHCP_CLI_CNT_STATUS          _STA_DHCP(0x5007)	//T=u32, connect status
#define CSID_S_DHCP_CLI_ALTERED			    _STA_DHCP(0x5008)	//T=u32, ui altered
#define CSID_S_DHCP_CLI_LEASE_TIME			_STA_DHCP(0x5009)	//T=u32, uptime + leasetime

/* Reserved 16 items for Multi-WAN,  X is from 1 .... */
#define CSID_S_DHCP_CLI1_PID				_STA_DHCP(0x5100)	//T=u16, The PID of DHCP Client 
#define CSID_S_DHCP_CLI1_IF_IP				_STA_DHCP(0x5110)	//T=ipv4, dynamic interface ip
#define CSID_S_DHCP_CLI1_IF_NM				_STA_DHCP(0x5120)	//T=ipv4, dynamic interface netmask
#define CSID_S_DHCP_CLI1_IF_GW				_STA_DHCP(0x5130)	//T=ipv4, dynamic interface gateway
#define CSID_S_DHCP_CLI1_IF_PRIDNS		    _STA_DHCP(0x5140)	//T=ipv4, dynamic interface Primary DNS
#define CSID_S_DHCP_CLI1_IF_SECDNS		    _STA_DHCP(0x5150)	//T=ipv4, dynamic interface Second DNS
#define CSID_S_DHCP_CLI1_CNT_STATUS         _STA_DHCP(0x5160)	//T=u32, connect status
#define CSID_S_DHCP_CLI1_ALTERED			_STA_DHCP(0x5170)	//T=u32, ui altered
#define CSID_S_DHCP_CLI1_LEASE_TIME			_STA_DHCP(0x5180)	//T=u32, uptime + leasetime

#endif //ifndef _CSID_DHCP_H
